/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.bean;

import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.timestamp.client.bean.HashAlgorithm;
import java.util.Arrays;

public final class MessageImprint {
    private final HashAlgorithm hashAlgorithm;
    private final byte[] hashedMessage;

    public MessageImprint(HashAlgorithm hashAlgorithm, byte[] hashedMessage) {
        this.hashAlgorithm = hashAlgorithm;
        this.hashedMessage = hashedMessage;
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getHashedMessage() {
        return this.hashedMessage;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hashAlgorithm == null ? 0 : this.hashAlgorithm.hashCode());
        result = 31 * result + Arrays.hashCode(this.hashedMessage);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageImprint other = (MessageImprint)obj;
        if (this.hashAlgorithm != other.hashAlgorithm) {
            return false;
        }
        return Arrays.equals(this.hashedMessage, other.hashedMessage);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MessageImprint [hashAlgorithm=");
        builder.append((Object)this.hashAlgorithm);
        builder.append(", hashedMessage=");
        if (this.hashedMessage == null) {
            builder.append("none");
        } else {
            builder.append("0x");
            builder.append(Hex.toHexString((byte[])this.hashedMessage));
        }
        builder.append("]");
        return builder.toString();
    }
}

