/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.tx.ocr;

import com.alibaba.fastjson.JSONObject;
import cpcn.dsp.institution.api.system.DSPInstitutionEnvironment;
import cpcn.dsp.institution.api.tx.TxBaseResponse;
import cpcn.dsp.institution.api.util.ClientDecryptionUtil;

public class Tx4020Response
extends TxBaseResponse {
    private String institutionID;
    private String txSN;
    private String traceNo;
    private String responseCode;
    private String responseMessage;
    private String holderName;
    private String issuerBank;
    private String accountNumber;
    private String cardType;
    private String expiresEnd;

    public Tx4020Response(String responseMessage, String responseSignature) throws Exception {
        super(responseMessage, responseSignature);
    }

    public Tx4020Response(String responseMessage, String responseSignature, String responseDgtlEnvlp, String responseSignSN, String responseEncryptSN) throws Exception {
        super(responseMessage, responseSignature, responseDgtlEnvlp, responseSignSN, responseEncryptSN);
    }

    @Override
    protected void process(String document) throws Exception {
        if ("2000".equals(this.code)) {
            JSONObject json = JSONObject.parseObject((String)document);
            this.institutionID = json.getString("InstitutionID");
            this.txSN = json.getString("TxSN");
            this.traceNo = json.getString("TraceNo");
            this.responseCode = json.getString("ResponseCode");
            this.responseMessage = json.getString("ResponseMessage");
            this.holderName = json.getString("HolderName");
            this.issuerBank = json.getString("IssuerBank");
            if ("10".equals(DSPInstitutionEnvironment.msgEncryptType)) {
                this.accountNumber = ClientDecryptionUtil.decrypt(json.getString("AccountNumber"));
            } else if ("20".equals(DSPInstitutionEnvironment.msgEncryptType) || "30".equals(DSPInstitutionEnvironment.msgEncryptType)) {
                this.accountNumber = json.getString("AccountNumber");
            }
            this.cardType = json.getString("CardType");
            this.expiresEnd = json.getString("ExpiresEnd");
        }
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getTxSN() {
        return this.txSN;
    }

    public String getTraceNo() {
        return this.traceNo;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getHolderName() {
        return this.holderName;
    }

    public String getIssuerBank() {
        return this.issuerBank;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getExpiresEnd() {
        return this.expiresEnd;
    }
}

