/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200;

import cfca.sadk.lib.crypto.card.c200.ECCCardKey;
import cfca.sadk.org.bouncycastle.asn1.sec.SECNamedCurves;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.math.BigInteger;

public final class ECCCardPublicKey
extends ECCCardKey
implements ECPublicKey {
    private static final long serialVersionUID = 2724282825611671137L;
    private static final ECParameterSpec ecParameterSpec = ECCCardPublicKey.createECParameters();
    private final ECPoint Q;
    private final BigInteger iPubX;
    private final BigInteger iPubY;

    static final ECParameterSpec createECParameters() {
        X9ECParameters x9Params = SECNamedCurves.getByOID(X9ObjectIdentifiers.prime256v1);
        ECParameterSpec ecParameterSpec = new ECParameterSpec(x9Params.getCurve(), x9Params.getG(), x9Params.getN(), x9Params.getH(), x9Params.getSeed());
        return ecParameterSpec;
    }

    ECCCardPublicKey(byte[] defaultZ, long keyHandle, byte[] pubKeyX, byte[] pubKeyY, String CKID, int keyUsage) {
        super(defaultZ, keyHandle, pubKeyX, pubKeyY, CKID, keyUsage);
        this.iPubX = new BigInteger(1, pubKeyX);
        this.iPubY = new BigInteger(1, pubKeyY);
        this.Q = ecParameterSpec.getCurve().createPoint(this.iPubX, this.iPubY).normalize();
    }

    public ECCCardPublicKey(BCECPublicKey eccKey) throws IOException {
        super(eccKey);
        this.iPubX = new BigInteger(1, this.pubKeyX);
        this.iPubY = new BigInteger(1, this.pubKeyY);
        this.Q = ecParameterSpec.getCurve().createPoint(this.iPubX, this.iPubY).normalize();
    }

    public final byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithm = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, X9ObjectIdentifiers.prime256v1);
            byte[] encoded = new byte[65];
            encoded[0] = 4;
            if (this.pubKeyX.length != 32 || this.pubKeyY.length != 32) {
                throw new Exception("Encoded Failure for BCECPublicKey,pubKeyX length=" + this.pubKeyX.length + " and pubKeyY length=" + this.pubKeyY.length);
            }
            System.arraycopy(this.pubKeyX, 0, encoded, 1, 32);
            System.arraycopy(this.pubKeyY, 0, encoded, 33, 32);
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(algorithm, encoded);
            return info.getEncoded("DER");
        }
        catch (Exception e) {
            throw new RuntimeException("Encoded Failure for BCECPublicKey", e);
        }
    }

    public final ECParameterSpec getParams() {
        return ecParameterSpec;
    }

    public final ECParameterSpec getParameters() {
        return ecParameterSpec;
    }

    public final ECPoint getQ() {
        return this.Q;
    }

    public BigInteger getPubXByInt() {
        return this.iPubX;
    }

    public BigInteger getPubYByInt() {
        return this.iPubY;
    }

    final byte[] buildExternalData(byte[] sourceData) {
        byte[] sourceCardData = new byte[sourceData.length + 64];
        System.arraycopy(this.pubKeyX, 0, sourceCardData, 0, 32);
        System.arraycopy(this.pubKeyY, 0, sourceCardData, 32, 32);
        System.arraycopy(sourceData, 0, sourceCardData, 64, sourceData.length);
        return sourceCardData;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BCECCardPublicKey [CKID=");
        builder.append(this.CKID);
        builder.append(", keyHandle=");
        builder.append(this.keyHandle);
        builder.append(", keyUsage=");
        builder.append(this.keyUsage);
        builder.append(", internal=");
        builder.append(this.internal);
        builder.append(", pubKeyX=");
        builder.append(Hex.toHexString(this.pubKeyX));
        builder.append(", pubKeyY=");
        builder.append(Hex.toHexString(this.pubKeyY));
        builder.append(", defaultZ=");
        builder.append(Hex.toHexString(this.defaultZ));
        builder.append("]");
        return builder.toString();
    }

    public byte[] getPubX() {
        return this.iPubX.toByteArray();
    }

    public byte[] getPubY() {
        return this.iPubY.toByteArray();
    }
}

