/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.asn1.pkcs;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.pkcs.CSRDecoder;
import cfca.sadk.asn1.pkcs.CSREncoder;
import cfca.sadk.asn1.pkcs.CSRMetadata;
import cfca.sadk.asn1.pkcs.CSRPublicKeyHelper;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.lib.crypto.card.CardLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.pkcs.CertificationRequest;
import cfca.sadk.org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.SM2OutputFormat;
import cfca.sadk.system.global.P10RequestContextConfig;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.Base64;
import cfca.sadk.util.KeyUtil;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class PKCS10 {
    static final int SM2P10_OUTPUT_SIGNFORMAT_ASN1 = 1;
    static final int SM2P10_OUTPUT_SIGNFORMAT_RAW = 2;
    private static final String challengePassword = "111111";
    private int formatSignedBytes = CompatibleConfig.P10RequestFormatSignedBytes;
    private boolean needVerify = false;
    private boolean p10RequestVerifyState = false;
    private String defaultSubjectX500Name = "CN=certRequisition,O=CFCA TEST CA,C=CN";
    private final Session session;
    private KeyPair keyPair = null;
    private KeyPair tempKeyPair;
    private CSRMetadata metadata;

    public PKCS10() {
        this(BCSoftLib.INSTANCE());
    }

    public PKCS10(Session session) {
        this.session = session == null ? BCSoftLib.INSTANCE() : session;
        this.needVerify = P10RequestContextConfig.getP10RequestVerifyState();
    }

    public void load(byte[] p10Data) throws PKIException {
        PKCS10CertificationRequest p10CertificationRequest = CSRDecoder.decodedCertificationRequest(p10Data);
        this.load(p10CertificationRequest.toASN1Structure());
    }

    public void load(CertificationRequest certficationRequest) throws PKIException {
        CSRMetadata metadata;
        byte[] base64P10Data;
        if (certficationRequest == null) {
            throw new PKIException("load failure when certficationRequest parameter certficationRequest=null ");
        }
        try {
            base64P10Data = Base64.encode(certficationRequest.getEncoded());
        }
        catch (IOException e) {
            throw new PKIException("load failure when certficationRequest invalid certficationRequest: base64P10Data failed", e);
        }
        try {
            metadata = new CSRMetadata(certficationRequest);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("load failure when certficationRequest decodedCSRMetadata failed: " + Strings.fromByteArray(base64P10Data), (Throwable)e);
            throw new PKIException("load failure when certficationRequest decodedCSRMetadata failed", e);
        }
        Mechanism mechanism = metadata.mechanism;
        PublicKey publicKey = metadata.publicKey;
        byte[] sourceData = metadata.sourceData;
        byte[] signature = metadata.signature;
        boolean p10VerifyResult = true;
        if (this.needVerify) {
            try {
                p10VerifyResult = this.veirfyP10CertificationRequest(mechanism, publicKey, sourceData, signature, this.session);
            }
            catch (PKIException e) {
                LoggerManager.exceptionLogger.error("load failure when certficationRequest veirfyP10CertificationRequest failed: " + Strings.fromByteArray(base64P10Data), (Throwable)e);
                throw new PKIException("veirfyP10CertificationRequest verify failed", e);
            }
            this.p10RequestVerifyState = p10VerifyResult;
            if (!p10VerifyResult) {
                LoggerManager.exceptionLogger.error("load failure when certficationRequest veirfyP10CertificationRequest False: " + Strings.fromByteArray(base64P10Data));
                throw new PKIException("veirfyP10CertificationRequest verify failed");
            }
        }
        this.metadata = metadata;
        this.metadata.base64P10Data = Base64.encode(base64P10Data);
    }

    public void setNeedVerify(boolean needVerify) {
        this.needVerify = needVerify;
    }

    public void setDefaultSubjectDN(String defaultSubjectDN) {
        this.defaultSubjectX500Name = defaultSubjectDN;
    }

    public void setFormatSignedBytes(int formatSignedBytes) {
        this.formatSignedBytes = formatSignedBytes;
        LoggerManager.systemLogger.info("setFormatSignedBytes>>>>>>: formatSignedBytes=" + formatSignedBytes);
    }

    public byte[] generateDoublePKCS10Request(Mechanism mechanism, int keyLength) throws PKIException {
        return this.generateDoublePKCS10Request(mechanism, keyLength, this.session);
    }

    public byte[] generateDoublePKCS10Request(Mechanism mechanism, int keyLength, Session session) throws PKIException {
        return this.generateDoublePKCS10Request(mechanism, keyLength, new X500Name(this.defaultSubjectX500Name), challengePassword, session);
    }

    public byte[] generateDoublePKCS10Request(Mechanism mechanism, int keyLength, Session session, boolean isSoftKey) throws PKIException {
        return this.generateDoublePKCS10Request(mechanism, keyLength, new X500Name(this.defaultSubjectX500Name), challengePassword, session, isSoftKey);
    }

    public byte[] generateDoublePKCS10Request(Mechanism mechanism, int keyLength, X500Name subject, String challengePassword, Session session) throws PKIException {
        return this.generateDoublePKCS10Request(mechanism, keyLength, subject, challengePassword, session, true);
    }

    public byte[] generateDoublePKCS10Request(Mechanism mechanism, int keyLength, X500Name subject, String challengePassword, Session session, boolean isEncSoftKey) throws PKIException {
        PublicKey tempPublicKey;
        KeyPair tempKeyPair;
        if (session == null) {
            throw new PKIException("generateDoublePKCS10Request Failure: session=null!");
        }
        String keyType = Mechanisms.getKeyType(mechanism);
        KeyPair keypair = this.generateCSRKeyPair(mechanism, keyLength, session);
        if (this.isC200CardAndSM2Key(session, keyType)) {
            tempKeyPair = null;
            tempPublicKey = this.getC200InternalEncPublicKey(session);
        } else {
            tempKeyPair = KeyUtil.generateKeyPair(new Mechanism(keyType), keyLength, BCSoftLib.INSTANCE());
            tempPublicKey = tempKeyPair.getPublic();
        }
        this.metadata = this.generateCertificateSigningRequest(mechanism, subject, keypair, keyType, tempPublicKey, challengePassword, session);
        this.keyPair = keypair;
        this.tempKeyPair = tempKeyPair;
        return this.metadata.base64P10Data;
    }

    public byte[] generatePKCS10Request(Mechanism mechanism, int keyLength) throws PKIException {
        return this.generatePKCS10Request(mechanism, keyLength, this.session);
    }

    public byte[] generatePKCS10Request(Mechanism mechanism, int keyLength, Session session) throws PKIException {
        KeyPair keypair = this.generateCSRKeyPair(mechanism, keyLength, session);
        return this.generatePKCS10Request(mechanism, new X500Name(this.defaultSubjectX500Name), null, keypair.getPublic(), keypair.getPrivate(), session);
    }

    public byte[] generatePKCS10Request(Mechanism mechanism, X500Name subject, ASN1Set attributes, PublicKey publicKey, PrivateKey privateKey) throws PKIException {
        return this.generatePKCS10Request(mechanism, subject, attributes, publicKey, privateKey, this.session);
    }

    public byte[] generatePKCS10Request(Mechanism mechanism, X500Name subject, ASN1Set attributes, PublicKey publicKey, PrivateKey privateKey, Session session) throws PKIException {
        if (session == null) {
            throw new PKIException("generatePKCS10Request Failure: session=null!");
        }
        String keyType = Mechanisms.getKeyType(mechanism);
        KeyPair keypair = new KeyPair(publicKey, privateKey);
        this.metadata = this.generateCertificateSigningRequest(mechanism, subject, keypair, keyType, attributes, session);
        this.keyPair = keypair;
        this.tempKeyPair = null;
        return this.metadata.base64P10Data;
    }

    public byte[] generatePKCS10Request(Mechanism mechanism, X500Name subject, ASN1Set attributes, PublicKey publicKey, byte[] signature) throws PKIException {
        CertificationRequestInfo certRequestInfo;
        try {
            certRequestInfo = CSREncoder.buildCertificationRequestInfo(subject, attributes, publicKey);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("generatePKCS10Request failure when buildCertificationRequestInfo", (Throwable)e);
            throw new PKIException("generatePKCS10Request failure when buildCertificationRequestInfo", e);
        }
        return this.generatePKCS10Request(mechanism, certRequestInfo, signature);
    }

    public byte[] generatePKCS10Request(Mechanism mechanism, CertificationRequestInfo certRequestInfo, byte[] signature) throws PKIException {
        try {
            CertificationRequest certRequest = CSREncoder.buildCertificationRequest(mechanism, certRequestInfo, signature);
            this.metadata = new CSRMetadata(certRequest);
            return CSREncoder.buildCertificationRequestData(certRequest);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("generatePKCS10Request failure", (Throwable)e);
            throw new PKIException("generatePKCS10Request failure", e);
        }
    }

    public CertificationRequestInfo generateCertificationRequestInfo(X500Name subject, ASN1Set attributes, PublicKey publicKey) {
        try {
            return CSREncoder.buildCertificationRequestInfo(subject, attributes, publicKey);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("generateCertificationRequestInfo failure", (Throwable)e);
            throw new SecurityException("generateCertificationRequestInfo failure", e);
        }
    }

    public String generateCertificationRequest(Mechanism mechanism, X500Name subject, ASN1Set attributes, PublicKey publicKey, PrivateKey privateKey) throws PKIException {
        String base64P10Text = null;
        byte[] base64P10Data = this.generatePKCS10Request(mechanism, subject, attributes, publicKey, privateKey);
        try {
            base64P10Text = Strings.fromByteArray(base64P10Data);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("generateCertificationRequest base64P10Data to base64String failure", (Throwable)e);
            throw new PKIException("generateCertificationRequest failure", e);
        }
        return base64P10Text;
    }

    public byte[] parseCertificationRequestInfoToBytes(CertificationRequestInfo certRequestInfo) throws PKIException {
        try {
            return CSREncoder.buildCertificationRequestInfoData(certRequestInfo);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("parseCertificationRequestInfoToBytes failure", (Throwable)e);
            throw new PKIException("parseCertificationRequestInfoToBytes failure", e);
        }
    }

    public byte[] getTemporaryPublicKeyDataFromAttributes(ASN1Set attributes) throws PKIException {
        byte[] base64TemporaryPublicKeyData = null;
        byte[] temporaryPublicKeyData = CSRPublicKeyHelper.buildTemporaryPublicKeyDataFromP10(attributes);
        if (temporaryPublicKeyData != null) {
            LoggerManager.exceptionLogger.error("getTemporaryPublicKeyDataFromAttributes warining: temporaryPublicKeyData=null");
            base64TemporaryPublicKeyData = Base64.encode(temporaryPublicKeyData);
        }
        return base64TemporaryPublicKeyData;
    }

    public String getTemporaryPublicKeyFromAttributes(ASN1Set attributes) throws PKIException {
        String base64TemporaryPublicKeyText = null;
        byte[] base64TemporaryPublicKeyData = this.getTemporaryPublicKeyDataFromAttributes(attributes);
        if (base64TemporaryPublicKeyData != null) {
            try {
                base64TemporaryPublicKeyText = Strings.fromByteArray(base64TemporaryPublicKeyData);
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("getTemporaryPublicKeyDataFromAttributes warining: temporaryPublicKeyData=null");
                throw new PKIException("getTemporaryPublicKeyDataFromAttributes warining: temporaryPublicKeyData base64 failed", e);
            }
        }
        return base64TemporaryPublicKeyText;
    }

    private PublicKey getC200InternalEncPublicKey(Session session) throws PKIException {
        CardLib cardLib;
        PublicKey pubKey = null;
        if (session instanceof CardLib && (cardLib = (CardLib)session).isC200Card()) {
            try {
                pubKey = session.exportEncPublicKey();
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("getC200InternalEncPublicKey failure", (Throwable)e);
                throw new PKIException("getC200InternalEncPublicKey failure", e);
            }
        }
        return pubKey;
    }

    public int getKeySize() {
        if (this.metadata == null || this.metadata.publicKey == null) {
            throw new IllegalArgumentException("PKCS#10 publicKey is null");
        }
        try {
            return CSRPublicKeyHelper.buildP10PublicKeySize(this.metadata.publicKey);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("PKCS#10 publicKey invalid keyType: " + this.metadata.publicKey.getClass(), (Throwable)e);
            throw new IllegalArgumentException("PKCS#10 publicKey invalid keyType: " + this.metadata.publicKey.getClass());
        }
    }

    public ASN1Set getAttributes() {
        return this.metadata == null ? null : this.metadata.attributes;
    }

    public PublicKey getPublicKey() {
        return this.metadata == null ? null : this.metadata.publicKey;
    }

    public PublicKey getTemporaryPublicKey() {
        return this.metadata == null ? null : this.metadata.tempPublicKey;
    }

    public String getSubject() {
        return this.metadata == null ? null : this.metadata.subject.toString();
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public KeyPair getTemporaryKeyPair() {
        return this.tempKeyPair;
    }

    public PrivateKey getTemporaryPrivateKey() {
        return this.tempKeyPair == null ? null : this.tempKeyPair.getPrivate();
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair == null ? null : this.keyPair.getPrivate();
    }

    public String getSignatureAlgorithm() {
        return this.metadata == null ? null : this.metadata.mechanism.getMechanismType();
    }

    public byte[] getSignature() {
        return this.getSignature(2);
    }

    public byte[] getSignature(int sm2OutputFormat) {
        byte[] signature;
        if (this.metadata == null) {
            signature = null;
        } else if (this.metadata.signature == null) {
            signature = null;
        } else if (this.metadata.isSM2SignType()) {
            switch (sm2OutputFormat) {
                case 1: 
                case 2: {
                    signature = this.formatOutputSM2SignValue(this.metadata.signature, sm2OutputFormat);
                    break;
                }
                default: {
                    signature = this.metadata.signature;
                    break;
                }
            }
        } else {
            signature = this.metadata.signature;
        }
        return signature;
    }

    public boolean getP10RequestVerifyState() {
        return this.p10RequestVerifyState;
    }

    public int getCertReqType() {
        return this.metadata == null ? 0 : this.metadata.certReqType;
    }

    public PublicKey getPubKeyFromSubPubKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PKIException {
        return CSRPublicKeyHelper.buildPublicKeyFrom(subjectPublicKeyInfo);
    }

    public static boolean isP10RequestSignatureValid(byte[] base64P10Request) throws PKIException {
        try {
            return CSRDecoder.isP10RequestSignatureValid(base64P10Request);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("isP10RequestSignatureValid<<<<<<Failure: " + SADKDebugger.dump(base64P10Request), (Throwable)e);
            throw new PKIException("isP10RequestSignatureValid failure", e);
        }
    }

    public static PKCS10CertificationRequest decodedP10(byte[] base64P10RequestData) throws PKIException {
        try {
            return CSRDecoder.decodedCertificationRequest(base64P10RequestData);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("decodedP10<<<<<<Failure: " + SADKDebugger.dump(base64P10RequestData), (Throwable)e);
            throw new PKIException("decodedP10 failure", e);
        }
    }

    public static String getSubjectFromP10Request(byte[] base64P10RequestData) throws PKIException {
        try {
            return CSRDecoder.getSubjectFromP10Request(base64P10RequestData);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getSubjectFromP10Request<<<<<<Failure: " + SADKDebugger.dump(base64P10RequestData), (Throwable)e);
            throw new PKIException("getSubjectFromP10Request failure", e);
        }
    }

    public static String getSignatureAlgorithmFromP10Request(byte[] base64P10RequestData) throws PKIException {
        try {
            return CSRDecoder.getSignatureAlgorithmFromP10Request(base64P10RequestData);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getSignatureAlgorithmFromP10Request<<<<<<Failure: " + SADKDebugger.dump(base64P10RequestData), (Throwable)e);
            throw new PKIException("getSignatureAlgorithmFromP10Request failure", e);
        }
    }

    public static byte[] getSignatureFromP10Request(byte[] base64P10RequestData) throws PKIException {
        try {
            return CSRDecoder.getSignatureFromP10Request(base64P10RequestData);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getSignatureFromP10Request<<<<<<Failure: " + SADKDebugger.dump(base64P10RequestData), (Throwable)e);
            throw new PKIException("getSignatureFromP10Request failure", e);
        }
    }

    private CSRMetadata generateCertificateSigningRequest(Mechanism mechanism, X500Name subject, KeyPair keypair, String keyType, PublicKey tempPublicKey, String challengePassword, Session session) throws PKIException {
        DERSet attributes = null;
        if (tempPublicKey != null) {
            attributes = CSRPublicKeyHelper.buildTemporaryPublicKeyP10Attributes(tempPublicKey, challengePassword, keyType);
        }
        return this.generateCertificateSigningRequest(mechanism, subject, keypair, keyType, attributes, session);
    }

    private CSRMetadata generateCertificateSigningRequest(Mechanism mechanism, X500Name subject, KeyPair keypair, String keyType, ASN1Set attributes, Session session) throws PKIException {
        if (keypair == null) {
            throw new PKIException("generateCertificateSigningRequest parameter invalid: keypair=null");
        }
        if (keyType == null) {
            throw new PKIException("generateCertificateSigningRequest parameter invalid: keyType=null");
        }
        if (subject == null) {
            throw new PKIException("generateCertificateSigningRequest parameter invalid: subject=null");
        }
        if (mechanism == null) {
            throw new PKIException("generateCertificateSigningRequest parameter invalid: mechanism=null");
        }
        if (session == null) {
            throw new PKIException("generateCertificateSigningRequest parameter invalid: session=null");
        }
        PublicKey publicKey = keypair.getPublic();
        PrivateKey privateKey = keypair.getPrivate();
        CertificationRequestInfo certRequestInfo = CSREncoder.buildCertificationRequestInfo(subject, attributes, publicKey);
        byte[] sourceData = CSREncoder.buildCertificationRequestInfoData(certRequestInfo);
        byte[] signature = this.signP10CertificationRequest(mechanism, privateKey, sourceData, keyType, session);
        byte[] base64P10Data = CSREncoder.buildCertificationRequestData(mechanism, certRequestInfo, signature);
        CSRMetadata metadata = new CSRMetadata(mechanism, subject, publicKey, attributes, sourceData, signature);
        metadata.base64P10Data = base64P10Data;
        return metadata;
    }

    private KeyPair generateCSRKeyPair(Mechanism mechanism, int keyLength, Session session) throws PKIException {
        Mechanism generateMechanism;
        if (mechanism == null) {
            throw new PKIException("generateCSRKeyPair parameter invalid: mechanism=null");
        }
        if (session == null) {
            throw new PKIException("generateCSRKeyPair parameter invalid: session=null");
        }
        String keyType = Mechanisms.getKeyType(mechanism);
        if (keyType == null) {
            throw new PKIException("generateCSRKeyPair Failure: unsupported algorithm: " + mechanism.getMechanismType());
        }
        if ("ECC".equals(keyType)) {
            String curveName = CSRPublicKeyHelper.buildCurveNameFrom(mechanism);
            generateMechanism = new Mechanism(keyType, mechanism.getParam(), curveName);
        } else {
            generateMechanism = new Mechanism(keyType, mechanism.getParam());
        }
        return KeyUtil.generateKeyPair(generateMechanism, keyLength, session);
    }

    private boolean isC200CardAndSM2Key(Session session, String keyType) {
        boolean isSM2C200Card = false;
        if (session instanceof CardLib) {
            isSM2C200Card = ((CardLib)session).isC200Card() && "SM2".equals(keyType);
        }
        return isSM2C200Card;
    }

    private byte[] signP10CertificationRequest(Mechanism mechanism, PrivateKey privateKey, byte[] certificationRequestInfoData, String keyType, Session session) throws PKIException {
        byte[] signature = null;
        try {
            signature = session.sign(mechanism, privateKey, certificationRequestInfoData);
        }
        catch (Exception e) {
            throw new PKIException("signP10CertificationRequest call failure: signing failed", e);
        }
        if ("SM2".equals(keyType)) {
            try {
                signature = this.formatOutputSM2SignValue(signature, this.formatSignedBytes);
            }
            catch (Exception e) {
                throw new PKIException("signP10CertificationRequest call failure: format signValue failed->" + SADKDebugger.dump(signature), e);
            }
        } else if ("ECC".equals(keyType)) {
            signature = signature.length != 64 ? signature : SM2OutputFormat.sm2FormatSignedASN1Bytes(signature);
        }
        return signature;
    }

    private boolean veirfyP10CertificationRequest(Mechanism mechanism, PublicKey publicKey, byte[] certificationRequestInfoData, byte[] signature, Session session) throws PKIException {
        byte[] signBytes = null;
        if (Mechanisms.isSM2Type(mechanism)) {
            try {
                signBytes = SM2OutputFormat.sm2FormatSigned64Bytes(signature);
            }
            catch (Exception e) {
                throw new PKIException("veirfyP10CertificationRequest Failure: Build FormatSigned64Bytes Failure", e);
            }
        } else {
            signBytes = signature;
        }
        return session.verify(mechanism, publicKey, certificationRequestInfoData, signBytes);
    }

    private byte[] formatOutputSM2SignValue(byte[] signedBytes, int formatSignedBytes) {
        LoggerManager.systemLogger.info("signP10CertificationRequest(#0x01=ASN1(R+S): DEFAULT; #0x02=RAW(R+S)): formatSignedBytes=" + formatSignedBytes);
        byte[] returnSignedBytes = formatSignedBytes == 2 ? (signedBytes.length == 64 ? signedBytes : SM2OutputFormat.sm2FormatSigned64Bytes(signedBytes)) : (signedBytes.length != 64 ? signedBytes : SM2OutputFormat.sm2FormatSignedASN1Bytes(signedBytes));
        return returnSignedBytes;
    }
}

