/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.EncryptUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.svs.api.util.XmlUtil;
import cpcn.dsp.institution.api.security.DigitalEnvelopeUtil;
import cpcn.dsp.institution.api.security.HardwareConfig;
import cpcn.dsp.institution.api.security.SM4Util;
import cpcn.dsp.institution.api.security.Verifier;
import cpcn.dsp.institution.api.util.StringUtil;
import java.security.Key;

public class SMVerifier
implements Verifier {
    private static final String deviceName = "JSOFT_LIB";
    private static final Mechanism mechanism = new Mechanism("SM2");
    private static Session session;
    private X509Cert x509Cert;

    public SMVerifier(X509Cert x509Cert) throws Exception {
        this.x509Cert = x509Cert;
        JCrypto.getInstance().initialize(deviceName, null);
        session = JCrypto.getInstance().openSession(deviceName);
    }

    @Override
    public boolean verify(String message, String signature) throws Exception {
        byte[] data = message.getBytes("UTF-8");
        byte[] sig = StringUtil.hex2bytes(signature);
        return this.verify(data, sig);
    }

    @Override
    public boolean verify(byte[] message, byte[] signature) throws Exception {
        if (HardwareConfig.hardwareFlag) {
            String responseString = HardwareConfig.svBusiness.sm2P7HashDetachVerifySign(message, new String(signature), "-1");
            return DigitalEnvelopeUtil.dealResponse(responseString);
        }
        Signature sig = new Signature();
        return sig.p7VerifyMessageDetach(message, signature, session);
    }

    @Override
    public String symmetricEncrypt(String message, String symmetricCipher) throws Exception {
        if (HardwareConfig.hardwareFlag) {
            String response = HardwareConfig.svBusiness.symmetricDecryptBySerNetPlatform(symmetricCipher.getBytes(), message.getBytes(), "SM4/CBC/PKCS7Padding");
            if (DigitalEnvelopeUtil.dealResponse(response)) {
                return XmlUtil.getNodeText((String)response, (String)"SrcBase64");
            }
            return null;
        }
        return SM4Util.encrypt(message, symmetricCipher);
    }

    @Override
    public String getSN() throws Exception {
        return String.valueOf(this.x509Cert.getSerialNumber());
    }

    @Override
    public String asymmetricEncrypt(byte[] message) throws Exception {
        byte[] base64Bytes = EncryptUtil.encrypt((Mechanism)mechanism, (Key)this.x509Cert.getPublicKey(), (byte[])message, (Session)session);
        return new String(base64Bytes, "UTF-8");
    }
}

