/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.exception;

import java.util.Locale;
import java.util.ResourceBundle;

public enum TSAErrorCode {
    timestampConfigFileMissing(0x60000000, "TimestampConfig file missing"),
    timestampConfigLoadFailure(0x60000001, "TimestampConfig load failure"),
    timestampConfigSaveFailure(0x60000002, "TimestampConfig save failure"),
    timestampConfigEncryptFailure(0x60000003, "TimestampConfig encrypt password failure"),
    timestampConfigDecryptFailure(0x60000004, "TimestampConfig decrypt password failure"),
    serverUrlInvalidMalformedURL(0x60000010, "serverUrl invalid malformedURL"),
    serverUrlNotSupportProtocol(0x60000011, "serverUrl not support protocol other than http or https"),
    serverUrlHTTPSRequireSSLContext(1610612754, "serverUrl https require SSLContext"),
    serverUrlHTTPAddBasicAuthFailure(1610612755, "serverUrl add basic authorization failure"),
    serverUrlSendHTTPRequestFailure(0x60000020, "serverUrl http request send failure"),
    serverUrlSendHTTPFailure(1610612769, "serverUrl http message send failure"),
    serverUrlSendShortagePacket(0x60000022, "serverUrl http message send too small"),
    serverUrlSendExceedMaxPacket(1610612771, "serverUrl http message send too large"),
    serverUrlRecvHTTPFailure(1610612772, "serverUrl http message receive failure"),
    serverUrlRecvShortagePacket(1610612773, "serverUrl http message receive too small"),
    serverUrlRecvInvalidPacket(0x60000026, "serverUrl http message receive invalid tsa"),
    httpsMissingTrustManager(0x60000030, "https missing trustManager"),
    httpsSSLContentInstanceFailure(1610612785, "https instance failure"),
    httpsSSLContentInitFailure(1610612786, "https init with trustManager/keyManager failure"),
    httpsSSLKeyManagerFilePathMissing(0x60000040, "https keyManager init failure with jksKeyFilePath missing"),
    httpsSSLKeyManagerFilePathNotFound(1610612801, "https keyManager init failure with jksKeyFilePath not found"),
    httpsSSLKeyManagerFilePasswordMissing(1610612802, "https keyManager init failure with jksKeyStoreFilePassword missing"),
    httpsSSLKeyManagerFilePasswordInvalid(1610612803, "https keyManager init failure with jksKeyStoreFilePassword invalid"),
    httpsSSLKeyManagerAlgorithmInvalid(0x60000044, "https keyManager init failure with algorithm invalid"),
    httpsSSLKeyManagerKeyStoreInvalid(1610612805, "https keyManager init failure with keystore invalid"),
    httpsSSLKeyManagerCertificateInvalid(0x60000046, "https keyManager init failure with certificate invalid"),
    httpsSSLKeyManagerIOError(1610612807, "https keyManager init failure with IOException"),
    httpsSSLKeyManagerUnknownError(1610612808, "https keyManager init failure with Exception"),
    httpsSSLTrustManagerFilePathMissing(0x60000050, "https trustManager init failure with jksTrustFilePath missing"),
    httpsSSLTrustManagerFilePathNotFound(1610612817, "https trustManager init failure with jksTrustFilePath not found"),
    httpsSSLTrustManagerFilePasswordMissing(1610612818, "https trustManager init failure with jksTrustStoreFilePassword missing"),
    httpsSSLTrustManagerFilePasswordInvalid(1610612819, "https trustManager init failure with jksTrustStoreFilePassword invalid"),
    httpsSSLTrustManagerAlgorithmInvalid(1610612820, "https trustManager init failure with algorithm invalid"),
    httpsSSLTrustManagerKeyStoreInvalid(0x60000055, "https trustManager init failure with keystore invalid"),
    httpsSSLTrustManagerCertificateInvalid(0x60000056, "https trustManager init failure with certificate invalid"),
    httpsSSLTrustManagerIOError(1610612823, "https trustManager init failure with IOException"),
    httpsSSLTrustManagerUnknownError(1610612824, "https trustManager init failure with Exception"),
    httpsSSLContextManagerBuildFailureMissingConfig(0x60000060, "SSLContextManager build failure when missing timestampConfig"),
    httpsSSLContextManagerBuildFailureMissingHttpURL(0x60000061, "SSLContextManager build failure with missing timestampConfig@HttpURL"),
    httpsSSLContextManagerBuildFailureInvalidHttpURL(0x60000062, "SSLContextManager build failure with invalid timestampConfig@HttpURL"),
    httpsSSLContextManagerBuildFailureNotSupportProtocol(0x60000063, "SSLContextManager build failure with unsupport timestampConfig@HttpURL"),
    httpsSSLContextManagerBuildFailureRequiredTrustFile(0x60000064, "SSLContextManager build failure with missing timestampConfig@trustFile"),
    businessTrustFilenameInvalid(0x60000070, "businessTrust filename invalid other than sm2/p12/pfx"),
    businessTrustGetSM2PrivatekeyFailure(1610612849, "businessTrust GetSM2Privatekey failure"),
    businessTrustGetRSAPrivatekeyFailure(1610612850, "businessTrust GetRSAPrivatekey failure"),
    businessTrustGetSM2CertFailure(1610612851, "businessTrust GetSM2Cert failure"),
    businessTrustGetRSACertFailure(1610612852, "businessTrust GetRSACert failure"),
    businessTrustSM2FileCheckingSignedFailure(1610612853, "businessTrust checkSM2File failure when do sign"),
    businessTrustRSAFileCheckingSignedFailure(0x60000076, "businessTrust checkRSAFile failure when do sign"),
    businessTrustSM2FileCheckingVerifyFailure(0x60000077, "businessTrust checkSM2File failure when do verify"),
    businessTrustRSAFileCheckingVerifyFailure(1610612856, "businessTrust checkRSAFile failure when do verify"),
    businessTrustSM2FileCheckingNotMatch(1610612857, "businessTrust checkSM2File not match"),
    businessTrustRSAFileCheckingNotMatch(1610612858, "businessTrust checkRSAFile not match"),
    businessTrustCertFileInvalid(1610612859, "businessTrust invalid trustCertFile"),
    signedFailureInvalidCertValidate(0x60000080, "signed failure with invalid cert validate"),
    signedFailureMissingSignedPrivateKey(1610612865, "signed failure with missing signedPrivateKey"),
    signedFailureMissingSignedCert(1610612866, "signed failure with missing signedCert"),
    signedFailureMissingMessageImprint(1610612867, "signed failure with missing messageImprint"),
    signedFailureMissingNonceOptional(1610612868, "signed failure with missing nonceOptional"),
    signedFailureGetEncodedMessageImprint(1610612869, "signed failure when getEncoded of messageImprint"),
    signedFailureGetEncodedNonceOptional(0x60000086, "signed failure when getEncoded of nonceOptional"),
    signedFailureHashedMessage(1610612871, "signed failure when done hashedMessage"),
    signedFailureP7SignByHash(0x60000088, "signed failure when done P7SignByHash"),
    timestampClientMissingPolicyMode(0x60001000, "TimestampHelper missing parameter@PolicyMode"),
    timestampClientMissingConfig(0x60001001, "TimestampClient missing parameter@timestampConfig"),
    timestampClientMissingHashAlgorithm(1610616834, "TimestampClient missing parameter@hashAlgorithm"),
    timestampClientMissingSourceMessage(1610616835, "TimestampClient missing parameter@sourceMessage"),
    timestampClientMissingSourceStream(1610616836, "TimestampClient missing parameter@sourceStream"),
    timestampClientMissingMessageImprint(1610616837, "TimestampClient missing parameter@messageImprint"),
    timestampClientMessageImprintMissingAlgorithm(0x60001006, "TimestampClient messageImprint missing hashAlgorithm"),
    timestampClientMessageImprintMissingHashedMessage(1610616839, "TimestampClient messageImprint missing hashedMessage"),
    timestampClientMessageImprintInvalid(1610616840, "TimestampClient invalid parameter@messageImprint"),
    timestampClientMessageImprintInvalidHashAlgorithm(1610616841, "TimestampClient messageImprint invalid hashAlgorithm"),
    timestampClientMessageImprintMissingSourceData(1610616842, "TimestampClient messageImprint missing sourceData"),
    timestampClientMessageImprintBuildFailure(1610616843, "TimestampClient messageImprint build failure"),
    timestampClientRequestMessageBuildFailure(1610616844, "TimestampClient requestMessage build failure"),
    timestampClientBuildRequestorFailure(1610616845, "TimestampClient requestor build failure"),
    timestampClientResponseNonceMissing(0x60001010, "TimestampClient response without nonce"),
    timestampClientResponseNonceInvalid(0x60001011, "TimestampClient response with invalid nonce"),
    timestampClientResponsePolicyIdMissing(1610616850, "TimestampClient response without policyId"),
    timestampClientResponsePolicyIdInvalid(1610616851, "TimestampClient response with invalid policyId)"),
    timestampClientResponseMessageImprintMissing(1610616852, "TimestampClient response without messageImprint"),
    timestampClientResponseMessageImprintInvalid(1610616853, "TimestampClient response with invalid messageImprint)"),
    timestampClientResponseSignedDataOrSignedCertInvalid(0x60001016, "TimestampClient response with invalid signedData or invalid signedCert"),
    timestampClientRequesterNotSetting(1610616855, "TimestampClient requester not setting"),
    timestampClientResponseFailure(0x6000FFFF, "TimestampClient response failure"),
    timestampTSASignedDataInvalid(0x60002000, "timestamp TSASignedData encode invalid"),
    timestampTSASignedDataMissingStatusInfo(1610620929, "timestamp TSASignedData missing statusInfo"),
    timestampTSASignedDataMissingStatusCode(0x60002002, "timestamp TSASignedData missing statusCode"),
    timestampTSASignedDataUnknownStatusCode(1610620931, "timestamp TSASignedData unknown statusCode"),
    timestampTSASignedDataMissingTimeStampToken(1610620932, "timestamp TSASignedData missing timeStampToken"),
    timestampTSASignedDataContainTimeStampToken(1610620933, "timestamp TSASignedData contain timeStampToken"),
    timestampTSASignedDataMissingFailInfo(0x60002006, "timestamp TSASignedData missing failInfo"),
    timestampTSASignedDataInvalidFailInfo(1610620935, "timestamp TSASignedData invalid failInfo"),
    timestampTSASignedDataPKIFreeTextFailure(1610620936, "timestamp TSASignedData freeText fetch failure"),
    timestampTSASignedDataInvalidContentInfo(1610620937, "timestamp TSASignedData invalid content"),
    timeStampTokenInfoMissingHashAlgorithm(1610625025, "timeStampTokenInfo missing hashAlgorithm"),
    timeStampTokenInfoInvalidHashAlgorithm(1610625026, "timeStampTokenInfo invalid hashAlgorithm"),
    timeStampTokenInfoMissingHashedMessage(0x60003003, "timeStampTokenInfo missing hashedMessage"),
    timeStampTokenInfoInvalidHashedMessage(1610625028, "timeStampTokenInfo invalid hashedMessage"),
    timeStampTokenInfoGenTimeFormatFailure(1610625029, "timeStampTokenInfo genTime format failure"),
    timeStampTokenInfoAccuracyFetchFailure(0x60003006, "timeStampTokenInfo accuracy fetch failure"),
    timeStampTokenInfoExtensionsFetchFailure(1610625031, "timeStampTokenInfo extensions fetch failure"),
    timeStampTokenInfoNonceFetchFailure(1610625032, "timeStampTokenInfo nonce fetch failure"),
    timeStampTokenInfoPolicyFetchFailure(1610625033, "timeStampTokenInfo policy fetch failure"),
    timeStampTokenInfoSerialNumberFetchFailure(1610625034, "timeStampTokenInfo serialNumber fetch failure"),
    timeStampTokenInfoTsaNameFetchFailure(1610625035, "timeStampTokenInfo tsaName fetch failure"),
    timeStampTokenInfoVersionFetchFailure(1610625036, "timeStampTokenInfo version fetch failure"),
    timeStampTokenValidationFailure(0x60004000, "timeStampToken contentInfo object not for a timestamp"),
    timeStampTokenFailureWithTSAException(1610629121, "timeStampToken construct throw TSAException"),
    timeStampTokenFailureWithIllegalArgumentException(1610629122, "timeStampToken construct throw IllegalArgumentException"),
    timeStampTokenFailureWithIOException(1610629123, "timeStampToken construct throw IOException"),
    timeStampTokenFailureWithException(0x60004004, "timeStampToken construct throw Exception"),
    timeStampTokenSourceDataFetchFailure(1610629125, "timeStampToken sourceData fetch failure"),
    timeStampTokenSignedCertFetchFailure(0x60004006, "timeStampToken signedCert fetch failure"),
    timeStampTokenSignedCertMissing(1610629127, "timeStampToken signedCert missing"),
    timeStampTokenSignedCertMoreThanOne(1610629128, "timeStampToken signedCert more than one"),
    timeStampTokenSignedCertFetchCertBytesFailure(1610629129, "timeStampToken signedCert fetch certBytes failure"),
    timeStampTokenSignedCertConvertToX509CertFailure(1610629130, "timeStampToken signedCert convert to X509Cert failure"),
    timeStampTokenSignedAttributesMissing(1610629131, "timeStampToken missing signedAttributes"),
    timeStampTokenSignedTimeMissing(1610629132, "timeStampToken missing signing-time attribute value"),
    timeStampTokenSignedTimeInvalid(1610629133, "timeStampToken invalid signing-time attribute value"),
    timeStampTokenSignedTimeRequiredSingle(1610629134, "timeStampToken signing-time attribute MUST have a single attribute value"),
    timeStampTokenSignedTimeInvalidStructure(1610629135, "timeStampToken signing-time attribute value not a valid 'Time' structure"),
    timeStampTokenSignedDataInvalidSignature(1610633217, "timeStampToken signature not valid"),
    timeStampTokenSignedCertInvalidValidate(1610633218, "timeStampToken signercert validate not valid"),
    timeStampTokenSignedCertInvalidSignature(1610633219, "timeStampToken signercert signature not valid"),
    timeStampTokenSignedCertIsRevoked(1610633220, "timeStampToken signercert is revoked"),
    timestampHelperMissingTimestampConfig(1610641409, "timestampHelper missing timestampConfig"),
    statusHttpError(0x40000000, "TSA response failure with HTTPStatusInfo"),
    statusVerifiedError(0x50000000, "Timestamp verified failure"),
    statusPkiError(0x70000000, "TSA response failure with PKIStatusInfo"),
    UnknownError(-1, "TSA response failure with HTTPStatusInfo");

    public final int errorCode;
    public final String errorInfo;

    private TSAErrorCode(int errorCode, String errorInfo) {
        String info;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("timestampError", Locale.getDefault());
            info = bundle.getString("0x" + Integer.toHexString(errorCode));
        }
        catch (Exception e) {
            info = errorInfo;
        }
        this.errorCode = errorCode;
        this.errorInfo = info;
    }

    final String description() {
        return this.description(0);
    }

    final String description(int subcode) {
        return this.description(0, null);
    }

    public String description(String message) {
        return this.description(0, message);
    }

    public String description(int subcode, String message) {
        String name = super.toString();
        String code = Integer.toHexString(this.errorCode + subcode);
        String desc = null;
        desc = message == null ? String.format("0x%s-%-24s: %s", code, name, this.errorInfo) : String.format("0x%s-%-24s: %s\n\t\t%s", code, name, this.errorInfo, message);
        return desc;
    }
}

