/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.tx;

import com.alibaba.fastjson.JSONObject;
import cpcn.dsp.institution.api.codec.Base64;
import cpcn.dsp.institution.api.security.SignatureFactory;
import cpcn.dsp.institution.api.util.StringUtil;

public abstract class TxBaseResponse {
    protected String base64Message;
    protected String responseSignature;
    protected String responsePlainText;
    protected String code;
    protected String message;
    protected String txCode;
    protected String dgtlEnvlp;
    protected String signSN;
    protected String encrptSN;

    public TxBaseResponse(String responseMessage, String responseSignature) throws Exception {
        this.base64Message = responseMessage;
        this.responseSignature = responseSignature;
        byte[] data = Base64.decode(responseMessage);
        this.responsePlainText = new String(data, "UTF-8");
        byte[] signature = StringUtil.hex2bytes(responseSignature);
        if (!SignatureFactory.getVerifier().verify(data, signature)) {
            throw new Exception("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\u3002");
        }
        String document = this.responsePlainText;
        JSONObject jsonObject = JSONObject.parseObject((String)document);
        this.code = jsonObject.getString("Code");
        this.message = jsonObject.getString("Message");
        this.txCode = jsonObject.getString("TxCode");
        this.process(document);
    }

    public TxBaseResponse(String responseMessage, String responseSignature, String responseDgtlEnvlp, String responseSignSN, String responseEncryptSN) throws Exception {
        this.base64Message = responseMessage;
        this.dgtlEnvlp = SignatureFactory.getSigner(responseEncryptSN).decrpt(responseDgtlEnvlp);
        this.responsePlainText = SignatureFactory.getSigner(responseEncryptSN).decrypt(responseMessage, responseDgtlEnvlp);
        if (!SignatureFactory.getVerifier().verify(this.responsePlainText, responseSignature)) {
            throw new Exception("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\u3002");
        }
        String document = this.responsePlainText;
        JSONObject jsonObject = JSONObject.parseObject((String)document);
        this.code = jsonObject.getString("Code");
        this.message = jsonObject.getString("Message");
        this.txCode = jsonObject.getString("TxCode");
        this.process(document);
    }

    protected abstract void process(String var1) throws Exception;

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTxCode() {
        return this.txCode;
    }

    public String getDgtlEnvlp() {
        return this.dgtlEnvlp;
    }

    public String getSignSN() {
        return this.signSN;
    }

    public String getEncrptSN() {
        return this.encrptSN;
    }

    public String getResponsePlainText() {
        return this.responsePlainText;
    }
}

