/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.EncryptUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.svs.api.util.XmlUtil;
import cpcn.dsp.institution.api.codec.Base64;
import cpcn.dsp.institution.api.security.DigitalEnvelopeUtil;
import cpcn.dsp.institution.api.security.HardwareConfig;
import cpcn.dsp.institution.api.security.RandomCipherGenerateUtil;
import cpcn.dsp.institution.api.security.Signer;
import cpcn.dsp.institution.api.util.StringUtil;
import java.security.Key;
import java.security.PrivateKey;

public class SMSigner
implements Signer {
    private static final String signAlg = "sm3WithSM2Encryption";
    private PrivateKey privateKey;
    private X509Cert x509Cert;
    private String serviceID;
    private boolean flag = false;
    private static final String deviceName = "JSOFT_LIB";
    private static final Mechanism mechanism = new Mechanism("SM2");
    private static Session session;

    public SMSigner(String filename, String password) throws Exception {
        this(filename, password, null);
    }

    public SMSigner(String filename, String password, String serviceID) throws Exception {
        this.x509Cert = CertUtil.getCertFromSM2((String)filename);
        this.privateKey = KeyUtil.getPrivateKeyFromSM2((String)filename, (String)password);
        JCrypto.getInstance().initialize(deviceName, null);
        session = JCrypto.getInstance().openSession(deviceName);
        if (null == serviceID) {
            this.serviceID = serviceID;
            this.flag = true;
        }
    }

    @Override
    public String sign(String message) throws Exception {
        return StringUtil.bytes2hex(this.sign(message.getBytes("UTF-8")));
    }

    @Override
    public byte[] sign(byte[] data, String algorithm) throws Exception {
        return this.sign(data);
    }

    @Override
    public byte[] sign(byte[] data) throws Exception {
        if (HardwareConfig.hardwareFlag && this.flag) {
            String response = HardwareConfig.svBusiness.sm2P7DetachSign(this.serviceID, data);
            if (DigitalEnvelopeUtil.dealResponse(response)) {
                String signatureBase64 = XmlUtil.getNodeText((String)response, (String)"SignatureBase64");
                return Base64.decode(signatureBase64);
            }
            return null;
        }
        Signature signature = new Signature();
        return Base64.decode(signature.p7SignMessageDetach(signAlg, data, this.privateKey, this.x509Cert, session));
    }

    @Override
    public String decrypt(String message, String digitalEnvelope) throws Exception {
        if (HardwareConfig.hardwareFlag && this.flag) {
            String response = HardwareConfig.svBusiness.getSymmetricKeyByEnvpNetPlatform(String.valueOf(this.x509Cert.getSerialNumber()), digitalEnvelope);
            if (DigitalEnvelopeUtil.dealResponse(response)) {
                String base64Envelope = XmlUtil.getNodeText((String)response, (String)"SrcBase64");
                digitalEnvelope = Base64.decode(XmlUtil.getNodeText((String)base64Envelope, (String)"SrcBase64"), "UTF-8");
            }
        } else {
            digitalEnvelope = new String(EncryptUtil.decrypt((Mechanism)mechanism, (Key)this.privateKey, (byte[])digitalEnvelope.getBytes(), (Session)session), "UTF-8");
        }
        return DigitalEnvelopeUtil.generatePlainText(digitalEnvelope, message, this.privateKey.getAlgorithm());
    }

    @Override
    public String getSN() throws Exception {
        return String.valueOf(this.x509Cert.getSerialNumber());
    }

    @Override
    public String getSymmetricCipher() throws Exception {
        return RandomCipherGenerateUtil.randomHexString(16);
    }

    @Override
    public String getAlgorithmType() throws Exception {
        return this.x509Cert.getSignatureAlgName();
    }

    @Override
    public String decrpt(String message) throws Exception {
        return new String(EncryptUtil.decrypt((Mechanism)mechanism, (Key)this.privateKey, (byte[])message.getBytes(), (Session)session), "UTF-8");
    }
}

