/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.tx;

import cpcn.dsp.institution.api.codec.Base64;
import cpcn.dsp.institution.api.security.SignatureFactory;
import cpcn.dsp.institution.api.system.DSPInstitutionEnvironment;
import cpcn.dsp.institution.api.util.StringUtil;
import org.apache.log4j.Logger;

public abstract class TxBaseRequest {
    protected static final Logger logger = Logger.getLogger((String)"system");
    protected String txCode;
    protected String requestPlainText;
    protected String requestMessage;
    protected String requestSignature;
    protected String requestDgtlEnvlp;
    protected String requestSignSN;
    protected String requestEncryptSN;

    public String getRequestPlainText() {
        return this.requestPlainText;
    }

    public String getRequestMessage() {
        return this.requestMessage;
    }

    public String getRequestSignature() {
        return this.requestSignature;
    }

    public String getRequestDgtlEnvlp() {
        return this.requestDgtlEnvlp;
    }

    public String getRequestSignSN() {
        return this.requestSignSN;
    }

    public String getRequestEncryptSN() {
        return this.requestEncryptSN;
    }

    public abstract void process() throws Exception;

    protected void postProcess(String document) throws Exception {
        this.requestPlainText = document;
        byte[] data = this.requestPlainText.getBytes("UTF-8");
        if ("10".equals(DSPInstitutionEnvironment.msgEncryptType)) {
            this.requestMessage = new String(Base64.encode(data));
        } else if ("20".equals(DSPInstitutionEnvironment.msgEncryptType) || "30".equals(DSPInstitutionEnvironment.msgEncryptType)) {
            this.requestSignSN = SignatureFactory.getSigner().getSN();
            this.requestEncryptSN = SignatureFactory.getVerifier().getSN();
            String randomKeyData = SignatureFactory.getSigner().getSymmetricCipher();
            byte[] randomKey = randomKeyData.getBytes("UTF-8");
            this.requestDgtlEnvlp = SignatureFactory.getVerifier(this.requestEncryptSN).asymmetricEncrypt(randomKey);
            this.requestMessage = SignatureFactory.getVerifier(this.requestEncryptSN).symmetricEncrypt(this.requestPlainText, randomKeyData);
        }
        byte[] signature = SignatureFactory.getSigner().sign(data);
        this.requestSignature = StringUtil.bytes2hex(signature);
    }
}

