/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.system.Environments;
import cfca.sadk.util.p12.P12FileECCImpl;
import cfca.sadk.util.p12.P12FileFacade;
import cfca.sadk.util.p12.P12FileRSAImpl;
import cfca.sadk.util.p12.P12FileSM2Impl;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.PrivateKey;

public final class P12FileKit {
    static final P12FileKit INSTANCE;
    final P12FileFacade eccFacade = new P12FileECCImpl();
    final P12FileFacade rsaFacade = new P12FileRSAImpl();
    final P12FileFacade sm2Facade = new P12FileSM2Impl();

    private P12FileKit() {
    }

    public static String SM2GenerateKeyPair(int bitLength, String password) throws PKIException {
        return P12FileKit.INSTANCE.sm2Facade.generateKeyPair(new Mechanism("SM2"), bitLength, password);
    }

    public static String SM2GenerateP10(String base64EncryptedKeyData, String password) throws PKIException {
        return P12FileKit.INSTANCE.sm2Facade.generateP10(base64EncryptedKeyData, password);
    }

    public static String SM2CombineP12(String base64EncryptedKeyData, String base64CertData, String password) throws PKIException {
        return P12FileKit.INSTANCE.sm2Facade.combineP12(base64EncryptedKeyData, base64CertData, password);
    }

    public static String SM2CombineP12File(X509Cert x509Cert, PrivateKey priKey, String passWord, String sm2FileName) throws PKIException {
        return P12FileKit.INSTANCE.sm2Facade.combineP12File(x509Cert, priKey, passWord, sm2FileName);
    }

    public static byte[] SM2CombineP12Data(X509Cert x509Cert, PrivateKey priKey, String password) throws PKIException {
        return P12FileKit.INSTANCE.sm2Facade.combineP12Data(x509Cert, priKey, password);
    }

    public static String RSAGenerateKeyPair(int bitLength, String password) throws PKIException {
        return P12FileKit.INSTANCE.rsaFacade.generateKeyPair(new Mechanism("RSA"), bitLength, password);
    }

    public static String RSAGenerateP10(String base64EncryptedKeyData, String password) throws PKIException {
        return P12FileKit.INSTANCE.rsaFacade.generateP10(base64EncryptedKeyData, password);
    }

    public static String RSACombineP12(String base64EncryptedKeyData, String base64CertData, String password) throws PKIException {
        return P12FileKit.INSTANCE.rsaFacade.combineP12(base64EncryptedKeyData, base64CertData, password);
    }

    public static String RSACombineP12File(X509Cert x509Cert, PrivateKey priKey, String password, String p12FileName) throws PKIException {
        return P12FileKit.INSTANCE.rsaFacade.combineP12File(x509Cert, priKey, password, p12FileName);
    }

    public static byte[] RSACombineP12Data(X509Cert x509Cert, PrivateKey priKey, String password) throws PKIException {
        return P12FileKit.INSTANCE.rsaFacade.combineP12Data(x509Cert, priKey, password);
    }

    public static P12FileFacade ecc() {
        return P12FileKit.INSTANCE.eccFacade;
    }

    public static P12FileFacade rsa() {
        return P12FileKit.INSTANCE.rsaFacade;
    }

    public static P12FileFacade sm2() {
        return P12FileKit.INSTANCE.sm2Facade;
    }

    static {
        Environments.environments();
        INSTANCE = new P12FileKit();
    }
}

