/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.asn1.pkcs.PKCS12;
import cfca.sadk.asn1.pkcs.PKCS12_SM2;
import cfca.sadk.entity.JKSEntity;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.sec.ECPrivateKey;
import cfca.sadk.org.bouncycastle.openssl.PEMParser;
import cfca.sadk.org.bouncycastle.util.io.pem.PemObject;
import cfca.sadk.system.Environments;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyUtil {
    private static final String PRIVATEKEY = "PRIVATE KEY";
    private static final String PUBLICKEY = "PUBLIC KEY";
    private static final int notPemFormat = 0;
    private static final int isPemFormat = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SM2PrivateKey getPrivateKeyFromSM2(String sm2FilePath, String sm2FilePwd) throws PKIException {
        SM2PrivateKey sM2PrivateKey;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromSM2>>>>>>Running");
            buffer.append("\n sm2FilePath: ");
            buffer.append(SADKDebugger.dump(sm2FilePath));
            buffer.append("\n sm2FilePwd: hidden ");
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                byte[] encoding;
                if (sm2FilePath == null) {
                    throw new PKIException("getPrivateKeyFromSM2 Failure: SM2File sm2FilePath should not be null");
                }
                if (sm2FilePwd == null) {
                    throw new PKIException("getPrivateKeyFromSM2 Failure: SM2File sm2FilePwd should not be null");
                }
                try {
                    encoding = FileHelper.read(sm2FilePath);
                }
                catch (Exception e) {
                    throw new PKIException("getPrivateKeyFromSM2 Failure when readSM2File", e);
                }
                SM2PrivateKey privateKey = KeyUtil.getPrivateKeyFromSM2(encoding, sm2FilePwd);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("getPrivateKeyFromSM2<<<<<<Finished: privateKey=" + SADKDebugger.dump(privateKey));
                }
                sM2PrivateKey = privateKey;
                Object var7_10 = null;
                if (!isFailed) return sM2PrivateKey;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("getPrivateKeyFromSM2<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("getPrivateKeyFromSM2<<<<<<Failure", e);
                throw new PKIException("getPrivateKeyFromSM2 Failure: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromSM2>>>>>>Running");
            buffer.append("\n sm2FilePath: ");
            buffer.append(SADKDebugger.dump(sm2FilePath));
            buffer.append("\n sm2FilePwd: hidden ");
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return sM2PrivateKey;
        StringBuffer buffer = new StringBuffer();
        buffer.append("getPrivateKeyFromSM2>>>>>>Running");
        buffer.append("\n sm2FilePath: ");
        buffer.append(SADKDebugger.dump(sm2FilePath));
        buffer.append("\n sm2FilePwd: hidden ");
        LoggerManager.exceptionLogger.error(buffer.toString());
        return sM2PrivateKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SM2PrivateKey getPrivateKeyFromSM2(InputStream sm2FileInputStream, String sm2FilePwd) throws PKIException {
        SM2PrivateKey sM2PrivateKey;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromSM2>>>>>>Running");
            buffer.append("\n sm2FileInputStream: ");
            buffer.append(SADKDebugger.dump(sm2FileInputStream));
            buffer.append("\n sm2FilePwd: hidden ");
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                byte[] encoding;
                int dLength;
                if (sm2FileInputStream == null) {
                    throw new PKIException("getPrivateKeyFromSM2 Failure: SM2File sm2FileInputStream should not be null");
                }
                try {
                    dLength = sm2FileInputStream.available();
                }
                catch (IOException e) {
                    throw new PKIException("getPrivateKeyFromSM2 Failure: SM2File sm2FileInputStream invalid", e);
                }
                if (dLength > 1024000) {
                    throw new PKIException("getPrivateKeyFromSM2 Failure: SM2File sm2FileInputStream too large");
                }
                try {
                    encoding = new byte[dLength];
                    sm2FileInputStream.read(encoding);
                }
                catch (Exception e) {
                    throw new PKIException("getPrivateKeyFromSM2 Failure: SM2File sm2FileInputStream read failure", e);
                }
                SM2PrivateKey privateKey = KeyUtil.getPrivateKeyFromSM2(encoding, sm2FilePwd);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("getPrivateKeyFromSM2<<<<<<Finished: privateKey=" + SADKDebugger.dump(privateKey));
                }
                sM2PrivateKey = privateKey;
                Object var8_12 = null;
                if (!isFailed) return sM2PrivateKey;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("getPrivateKeyFromSM2<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("getPrivateKeyFromSM2<<<<<<Failure", e);
                throw new PKIException("getPrivateKeyFromSM2 Failure: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromSM2>>>>>>Running");
            buffer.append("\n sm2FileInputStream: ");
            buffer.append(SADKDebugger.dump(sm2FileInputStream));
            buffer.append("\n sm2FilePwd: hidden ");
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return sM2PrivateKey;
        StringBuffer buffer = new StringBuffer();
        buffer.append("getPrivateKeyFromSM2>>>>>>Running");
        buffer.append("\n sm2FileInputStream: ");
        buffer.append(SADKDebugger.dump(sm2FileInputStream));
        buffer.append("\n sm2FilePwd: hidden ");
        LoggerManager.exceptionLogger.error(buffer.toString());
        return sM2PrivateKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SM2PrivateKey getPrivateKeyFromSM2(byte[] sm2FileData, String sm2FilePwd) throws PKIException {
        SM2PrivateKey sM2PrivateKey;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromSM2>>>>>>Running");
            buffer.append("\n sm2FileData: ");
            buffer.append(SADKDebugger.dump(sm2FileData));
            buffer.append("\n sm2FilePwd: hidden ");
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                if (sm2FileData == null) {
                    throw new PKIException("getPrivateKeyFromSM2 Failure: SM2File sm2FileData should not be null");
                }
                if (sm2FilePwd == null) {
                    throw new PKIException("getPrivateKeyFromSM2 Failure: SM2File sm2FilePwd should not be null");
                }
                PKCS12_SM2 P12 = new PKCS12_SM2(sm2FileData);
                SM2PrivateKey privateKey = P12.getPrivateKey(sm2FilePwd);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("getPrivateKeyFromSM2<<<<<<Finished: privateKey=" + SADKDebugger.dump(privateKey));
                }
                sM2PrivateKey = privateKey;
                Object var7_9 = null;
                if (!isFailed) return sM2PrivateKey;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("getPrivateKeyFromSM2<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("getPrivateKeyFromSM2<<<<<<Failure", e);
                throw new PKIException("getPrivateKeyFromSM2 Failure: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromSM2>>>>>>Running");
            buffer.append("\n sm2FileData: ");
            buffer.append(SADKDebugger.dump(sm2FileData));
            buffer.append("\n sm2FilePwd: hidden ");
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return sM2PrivateKey;
        StringBuffer buffer = new StringBuffer();
        buffer.append("getPrivateKeyFromSM2>>>>>>Running");
        buffer.append("\n sm2FileData: ");
        buffer.append(SADKDebugger.dump(sm2FileData));
        buffer.append("\n sm2FilePwd: hidden ");
        LoggerManager.exceptionLogger.error(buffer.toString());
        return sM2PrivateKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey getPrivateKeyFromPFX(String pfxFilePath, String pfxFilePwd) throws PKIException {
        PrivateKey privateKey;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromPFX>>>>>>Running");
            buffer.append("\n pfxFilePath: ");
            buffer.append(SADKDebugger.dump(pfxFilePath));
            buffer.append("\n pfxFilePwd: hidden");
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                byte[] encoding;
                if (pfxFilePath == null) {
                    throw new PKIException("getPrivateKeyFromPFX Failure: PFXFile pfxFilePath should not be null");
                }
                try {
                    encoding = FileHelper.read(pfxFilePath);
                }
                catch (Exception e) {
                    throw new PKIException("getPrivateKeyFromPFX Failure: PFXFile read failure", e);
                }
                PrivateKey privateKey2 = KeyUtil.getPrivateKeyFromPFX(encoding, pfxFilePwd);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("getPrivateKeyFromPFX<<<<<<Finished: privateKey=" + SADKDebugger.dump(privateKey2));
                }
                privateKey = privateKey2;
                Object var7_10 = null;
                if (!isFailed) return privateKey;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("getPrivateKeyFromPFX<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("getPrivateKeyFromPFX<<<<<<Failure", e);
                throw new PKIException("getPrivateKeyFromPFX Failure: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromPFX>>>>>>Running");
            buffer.append("\n pfxFilePath: ");
            buffer.append(SADKDebugger.dump(pfxFilePath));
            buffer.append("\n pfxFilePwd: hidden");
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return privateKey;
        StringBuffer buffer = new StringBuffer();
        buffer.append("getPrivateKeyFromPFX>>>>>>Running");
        buffer.append("\n pfxFilePath: ");
        buffer.append(SADKDebugger.dump(pfxFilePath));
        buffer.append("\n pfxFilePwd: hidden");
        LoggerManager.exceptionLogger.error(buffer.toString());
        return privateKey;
    }

    public static PrivateKey getPrivateKeyFromPFX(InputStream pfxFileInputStream, String pfxFilePwd) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromPFX>>>>>>Running");
            buffer.append("\n pfxFileInputStream: ");
            buffer.append(SADKDebugger.dump(pfxFileInputStream));
            buffer.append("\n pfxFilePwd: hidden");
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encoding;
            int dLength;
            if (pfxFileInputStream == null) {
                throw new PKIException("getPrivateKeyFromPFX Failure: PFXFile pfxFileInputStream should not be null");
            }
            try {
                dLength = pfxFileInputStream.available();
            }
            catch (IOException e) {
                throw new PKIException("getPrivateKeyFromPFX Failure: PFXFile pfxFileInputStream invalid", e);
            }
            if (dLength > 1024000) {
                throw new PKIException("getPrivateKeyFromPFX Failure: PFXFile pfxFileInputStream too large");
            }
            try {
                encoding = new byte[dLength];
                pfxFileInputStream.read(encoding);
            }
            catch (Exception e) {
                throw new PKIException("getPrivateKeyFromPFX Failure: PFXFile pfxFileInputStream read failure", e);
            }
            PrivateKey privateKey = KeyUtil.getPrivateKeyFromPFX(encoding, pfxFilePwd);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getPrivateKeyFromPFX<<<<<<Finished: privateKey=" + SADKDebugger.dump(privateKey));
            }
            return privateKey;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getPrivateKeyFromPFX<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getPrivateKeyFromPFX<<<<<<Failure", e);
            throw new PKIException("getPrivateKeyFromPFX Failure: " + e.getMessage(), e);
        }
    }

    public static PrivateKey getPrivateKeyFromPFX(byte[] pfxFileData, String pfxFilePwd) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromPFX>>>>>>Running");
            buffer.append("\n pfxFileData: ");
            buffer.append(SADKDebugger.dump(pfxFileData));
            buffer.append("\n pfxFilePwd: hidden");
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (pfxFileData == null) {
                throw new PKIException("getPrivateKeyFromPFX Failure: PFXFile pfxFileData should not be null");
            }
            if (pfxFilePwd == null) {
                throw new PKIException("getPrivateKeyFromPFX Failure: PFXFile pfxFilePwd should not be null");
            }
            PKCS12 pkcs12 = new PKCS12(pfxFileData);
            PrivateKey privateKey = pkcs12.decrypt(pfxFilePwd.toCharArray());
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getPrivateKeyFromPFX<<<<<<Finished: privateKey=" + SADKDebugger.dump(privateKey));
            }
            return privateKey;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getPrivateKeyFromPFX<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getPrivateKeyFromPFX<<<<<<Failure", e);
            throw new PKIException("getPrivateKeyFromPFX Failure: " + e.getMessage(), e);
        }
    }

    public static PrivateKey getPrivateKeyFromJKS(String jksFilePath, String jksFilePwd, String alias) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromJKS>>>>>>Running");
            buffer.append("\n jksFilePath: ");
            buffer.append(SADKDebugger.dump(jksFilePath));
            buffer.append("\n jksFilePwd: hidden");
            buffer.append("\n alias: ");
            buffer.append(SADKDebugger.dump(alias));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (jksFilePath == null) {
                throw new PKIException("getPrivateKeyFromJKS Failure: JKSFile jksFilePath should not be null");
            }
            if (jksFilePwd == null) {
                throw new PKIException("getPrivateKeyFromJKS Failure: JKSFile jksFilePwd should not be null");
            }
            if (alias == null) {
                throw new PKIException("getPrivateKeyFromJKS Failure: JKSFile alias should not be null");
            }
            try {
                JKSEntity ks = new JKSEntity(jksFilePath, jksFilePwd);
                PrivateKey privateKey = ks.getPrivateKey(alias);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("getPrivateKeyFromPFX<<<<<<Finished: privateKey=" + SADKDebugger.dump(privateKey));
                }
                return privateKey;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("getPrivateKeyFromJKS Failure: JKSFile Parsed Failure", e);
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getPrivateKeyFromJKS<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getPrivateKeyFromJKS<<<<<<Failure", e);
            throw new PKIException("getPrivateKeyFromJKS Failure: " + e.getMessage(), e);
        }
    }

    public static PrivateKey getPrivateKeyFromJKS(InputStream jksInputStream, String jksFilePwd, String alias) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromJKS>>>>>>Running");
            buffer.append("\n jksInputStream: ");
            buffer.append(SADKDebugger.dump(jksInputStream));
            buffer.append("\n jksFilePwd: hidden");
            buffer.append("\n alias: ");
            buffer.append(SADKDebugger.dump(alias));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (jksInputStream == null) {
                throw new PKIException("getPrivateKeyFromJKS Failure: JKSFile jksInputStream should not be null");
            }
            if (jksFilePwd == null) {
                throw new PKIException("getPrivateKeyFromJKS Failure: JKSFile jksFilePwd should not be null");
            }
            if (alias == null) {
                throw new PKIException("getPrivateKeyFromJKS Failure: JKSFile alias should not be null");
            }
            try {
                JKSEntity ks = new JKSEntity(jksInputStream, jksFilePwd);
                PrivateKey privateKey = ks.getPrivateKey(alias);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("getPrivateKeyFromPFX<<<<<<Finished: privateKey=" + SADKDebugger.dump(privateKey));
                }
                return privateKey;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("getPrivateKeyFromJKS Failure: JKSFile Parsed Failure", e);
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getPrivateKeyFromJKS<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getPrivateKeyFromJKS<<<<<<Failure", e);
            throw new PKIException("getPrivateKeyFromJKS Failure: " + e.getMessage(), e);
        }
    }

    public static KeyPair generateKeyPair(Mechanism keypairType, int bitLength, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateKeyPair>>>>>>Running");
            buffer.append(" Mechanism: ").append(keypairType);
            buffer.append(" bitLength: ").append(bitLength);
            buffer.append(" session: ").append(session);
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if ("SM2".equals(keypairType.getMechanismType())) {
                bitLength = 256;
            }
            KeyPair keypair = session.generateKeyPair(keypairType, bitLength);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("generateKeyPair<<<<<<Finished: keypair=" + SADKDebugger.dump(keypair));
            }
            return keypair;
        }
        catch (PKIException e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateKeyPair<<<<<<Failure");
            buffer.append(" Mechanism: ").append(keypairType);
            buffer.append(" bitLength: ").append(bitLength);
            buffer.append(" session: ").append(session);
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateKeyPair<<<<<<Failure");
            buffer.append(" Mechanism: ").append(keypairType);
            buffer.append(" bitLength: ").append(bitLength);
            buffer.append(" session: ").append(session);
            LoggerManager.exceptionLogger.error(buffer.toString(), e);
            throw new PKIException("generateKeyPair Failure", e);
        }
    }

    public static Key generateKey(Mechanism symmetricKeyType, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateKey>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(SADKDebugger.dump(symmetricKeyType));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            Key symmetricKey = session.generateKey(symmetricKeyType);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("generateKey<<<<<<Finished: symmetricKey=" + SADKDebugger.dump(symmetricKey));
            }
            return symmetricKey;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("generateKey<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("generateKey<<<<<<Failure", e);
            throw new PKIException("generateKey Failure: " + e.getMessage(), e);
        }
    }

    public static Key generateKey(Mechanism symmetricKeyType, byte[] keyData, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateKey>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(SADKDebugger.dump(symmetricKeyType));
            buffer.append("\n keyData: ");
            buffer.append(SADKDebugger.dump(keyData));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            Key symmetricKey = session.generateKey(symmetricKeyType, keyData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("generateKey<<<<<<Finished: symmetricKey=" + SADKDebugger.dump(symmetricKey));
            }
            return symmetricKey;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("generateKey<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("generateKey<<<<<<Failure", e);
            throw new PKIException("generateKey Failure: " + e.getMessage(), e);
        }
    }

    public static SM2PublicKey getSM2PublicKey(byte[] pubX, byte[] pubY) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getSM2PublicKey>>>>>>Running");
            buffer.append("\n pubX: ");
            buffer.append(SADKDebugger.dump(pubX));
            buffer.append("\n pubY: ");
            buffer.append(SADKDebugger.dump(pubY));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            SM2PublicKey publicKey = new SM2PublicKey(pubX, pubY);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getSM2PublicKey<<<<<<Finished: SM2PublicKey=" + SADKDebugger.dump(publicKey));
            }
            return publicKey;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getSM2PublicKey<<<<<<Failure", e);
            throw new SecurityException("getSM2PublicKey Failure: " + e.getMessage(), e);
        }
    }

    public static SM2PrivateKey getSM2PrivateKey(byte[] da, byte[] pubX, byte[] pubY) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getSM2PrivateKey>>>>>>Running");
            buffer.append("\n da: hidden");
            buffer.append("\n pubX: ");
            buffer.append(SADKDebugger.dump(pubX));
            buffer.append("\n pubY: ");
            buffer.append(SADKDebugger.dump(pubY));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            SM2PrivateKey privateKey = new SM2PrivateKey(da, pubX, pubY);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getSM2PrivateKey<<<<<<Finished: SM2PrivateKey=" + SADKDebugger.dump(privateKey));
            }
            return privateKey;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getSM2PrivateKey<<<<<<Failure", e);
            throw new SecurityException("getSM2PrivateKey Failure: " + e.getMessage(), e);
        }
    }

    public static SM2PublicKey getSM2PublicKey(byte[] encoding) throws PKIException {
        SM2PublicKey publicKey;
        if (encoding == null || encoding.length == 0) {
            throw new PKIException("missing encoding forSM2PublicKey");
        }
        try {
            byte[] derEncodedBytes = KeyUtil.getKeyBytes(encoding, PUBLICKEY);
            publicKey = new SM2PublicKey(derEncodedBytes);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("getSM2PublicKey failed:" + SADKDebugger.dump(encoding), (Throwable)e);
            throw new PKIException("getSM2PublicKey failed:", e);
        }
        return publicKey;
    }

    public static SM2PrivateKey getSM2PrivateKey(byte[] encoding) throws PKIException {
        SM2PrivateKey privateKey;
        if (encoding == null || encoding.length == 0) {
            throw new PKIException("missing encoding SM2PrivateKey");
        }
        try {
            byte[] derEncodedBytes = KeyUtil.getKeyBytes(encoding, PRIVATEKEY);
            privateKey = KeyUtil.getPrivateKeyFrom(derEncodedBytes);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("getSM2PrivateKey failed: " + SADKDebugger.dump(encoding), (Throwable)e);
            throw new PKIException("getSM2PrivateKey failed:", e);
        }
        return privateKey;
    }

    public static Key generateKey(Mechanism keyType, byte[] keyData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateKey>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(SADKDebugger.dump(keyType));
            buffer.append("\n keyData: ");
            buffer.append(SADKDebugger.dump(keyData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            String type = keyType.getMechanismType();
            SecretKeySpec symmetricKey = null;
            if ("DESede".equals(type)) {
                if (keyData.length != 24) {
                    throw new PKIException("generateKey Failure: DES3 KEY must be 24 bytes");
                }
                symmetricKey = new SecretKeySpec(keyData, type);
            } else if ("SM4".equals(type)) {
                if (keyData.length != 16) {
                    throw new PKIException("generateKey Failure: SM4 KEY must be 16 bytes");
                }
                symmetricKey = new SecretKeySpec(keyData, type);
            } else if (type.equals("RC4")) {
                if (keyData.length != 16) {
                    throw new PKIException("generateKey Failure: RC4 KEY must be 16 bytes");
                }
                symmetricKey = new SecretKeySpec(keyData, type);
            } else {
                throw new PKIException("generateKey Failure: do not support this key type:" + type);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("generateKey<<<<<<Finished: symmetricKey=" + SADKDebugger.dump(symmetricKey));
            }
            return symmetricKey;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("generateKey<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("generateKey<<<<<<Failure", e);
            throw new PKIException("generateKey Failure: " + e.getMessage(), e);
        }
    }

    public static BufferedReader getBufferedReader(byte[] encoding) throws PKIException {
        if (encoding == null || encoding.length == 0) {
            throw new PKIException("missing encoding");
        }
        BufferedReader br = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(encoding);
            InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF8");
            br = new BufferedReader(isr);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("getBufferedReader Failure: ", (Throwable)e);
            throw new PKIException("getBufferedReader Failure: " + e.getMessage(), e);
        }
        return br;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getKeyFormat(byte[] encoding, String keywords) throws PKIException {
        BufferedReader br = null;
        if (encoding == null) {
            throw new IllegalArgumentException("encoding is missing");
        }
        if (keywords == null) {
            throw new IllegalArgumentException("keywords is missing");
        }
        int format = 0;
        try {
            try {
                br = KeyUtil.getBufferedReader(encoding);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.trim().equals("")) continue;
                    if (line.contains(keywords)) {
                        format = 1;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("getKeyFormat failed:", (Throwable)e);
                throw new PKIException("getKeyFormat failed:", e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (br == null) throw throwable;
                br.close();
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e1) {}
        if (br == null) return format;
        br.close();
        return format;
    }

    private static SM2PrivateKey getPrivateKeyFrom(byte[] encoding) {
        SM2PrivateKey privateKey;
        ASN1Sequence seq = ASN1Sequence.getInstance(encoding);
        if (seq.size() < 2) {
            throw new SecurityException("encoding not valid");
        }
        ASN1Encodable asn1Value = seq.getObjectAt(1);
        if (asn1Value instanceof ASN1Sequence) {
            privateKey = new SM2PrivateKey(encoding);
        } else {
            ECPrivateKey key = ECPrivateKey.getInstance(encoding);
            privateKey = new SM2PrivateKey(key.getKey(), null, null);
        }
        return privateKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getKeyBytes(byte[] encoding, String keywords) throws Exception {
        byte[] derEncodedBytes;
        BufferedReader bufferReader = null;
        try {
            block11: {
                try {
                    if (ASN1Parser.isDERSequence(encoding)) {
                        derEncodedBytes = encoding;
                        break block11;
                    }
                    int format = KeyUtil.getKeyFormat(encoding, keywords);
                    bufferReader = KeyUtil.getBufferedReader(encoding);
                    if (format == 0) {
                        derEncodedBytes = Base64.decode(encoding);
                    } else {
                        PEMParser parser = new PEMParser(bufferReader);
                        PemObject pem = parser.readPemObject();
                        derEncodedBytes = pem.getContent();
                        parser.close();
                        bufferReader = null;
                    }
                }
                catch (Exception e) {
                    throw new Exception("getKeyBytes failed:", e);
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (bufferReader == null) throw throwable;
                bufferReader.close();
                throw throwable;
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e1) {}
        if (bufferReader == null) return derEncodedBytes;
        bufferReader.close();
        return derEncodedBytes;
    }

    static {
        Environments.environments();
    }
}

