/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.jni;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.jcajce.provider.SADKProvider;
import cfca.sadk.lib.crypto.rsa.RSAOperation;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;

public class JNIRSA {
    public static boolean dowithPrivateKey(byte[] input, byte[] privateKey, byte[] output, RSAPrivateKey priKey) throws Exception {
        boolean allowed = JNIRSA.allowedJNI(priKey);
        boolean finished = allowed ? cryptokit.jni.JNIRSA.dowithPrivateKey((byte[])input, (byte[])privateKey, (byte[])output) : RSAOperation.dowithPrivateKey(priKey, input, output) > 0;
        return finished;
    }

    private static boolean allowedJNI(RSAPrivateKey priKey) throws Exception {
        boolean canUsedNative = true;
        if (priKey != null) {
            if (priKey instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey crtKey = (RSAPrivateCrtKey)priKey;
                if (BigInteger.ZERO.equals(crtKey.getPrimeP()) || BigInteger.ZERO.equals(crtKey.getPrimeQ())) {
                    canUsedNative = false;
                }
            } else {
                canUsedNative = false;
            }
        }
        return canUsedNative;
    }

    public static boolean dowithPublicKey(byte[] input, byte[] publicKey, byte[] output) throws Exception {
        return cryptokit.jni.JNIRSA.dowithPublicKey((byte[])input, (byte[])publicKey, (byte[])output);
    }

    public static final KeyPair RSAGenerateKeyPair(int bitLength) throws Exception {
        try {
            if (bitLength < 0 || bitLength > 4096 || bitLength % 512 != 0) {
                throw new SecurityException("RSAGenerateKeyPair failure with invalid bitLength=" + bitLength);
            }
            KeyPairGenerator keyPairGen = null;
            try {
                keyPairGen = KeyPairGenerator.getInstance("RSA", SADKProvider.INSTANCE());
            }
            catch (Exception e) {
                throw new SecurityException("RSAGenerateKeyPair failure with exception: " + e.getMessage(), e);
            }
            try {
                keyPairGen.initialize(bitLength);
                KeyPair keypair = keyPairGen.generateKeyPair();
                return keypair;
            }
            catch (Exception e) {
                throw new SecurityException("RSAGenerateKeyPair failure with exception: " + e.getMessage(), e);
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PKIException("RSAGenerateKeyPair failure with throwable: " + e.getMessage(), e);
        }
    }
}

