/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.api;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM3Digest;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.system.SecureRandoms;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.util.Base64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;

public final class TimestampConfig {
    private static final Logger logger = LoggerFactory.getLogger(TimestampConfig.class);
    private static final String keyBusinessCertPath = "timestamp.business.certPath";
    private static final String keyBusinessCertPassword = "timestamp.business.certPassword";
    private static final String keyBusinessTrustCertPath = "timestamp.business.trustCertPath";
    private static final String keyBusinessTrustCRLPath = "timestamp.business.trustCRLPath";
    private static final String keyHttpAuthUsername = "timestamp.http.auth.username";
    private static final String keyHttpAuthPassword = "timestamp.http.auth.password";
    private static final String keyHttpTimeout = "timestamp.http.timeout";
    private static final String keyHttpURL = "timestamp.http.url";
    private static final String keySslKeyStoreFilePath = "timestamp.ssl.jksKeyStoreFilePath";
    private static final String keySslKeyStorePassword = "timestamp.ssl.jksKeyStoreFilePassword";
    private static final String keySslTrustStoreFilePath = "timestamp.ssl.jksTrustFilePath";
    private static final String keySslTrustStorePassword = "timestamp.ssl.jksTrustFilePassword";
    private static final String keySslProtocol = "timestamp.ssl.protocol";
    private static final String keySslHostnameChecker = "timestamp.ssl.hostnameChecker";
    private static final Map<String, String> commentItems = new HashMap<String, String>();
    private String sslProtocol;
    private String jksTrustFilePath;
    private String jksTruestFilePassword;
    private String jksKeyStoreFilePath;
    private String jksKeyStoreFilePassword;
    private boolean hostnameChecker;
    private String httpAuthUsername;
    private String httpAuthPassword;
    private String httpURL;
    private int httpTimeout;
    private String businessCertPath;
    private String businessCertPassword;
    private String businessTrustCertPath;
    private String businessTrustCRLPath;
    private int passwordEncryptTimes = 0;

    public TimestampConfig() {
    }

    public static final TimestampConfig buildDefaultTimestampConfig() throws TSAException {
        TimestampConfig config;
        File file = new File("config/timestamp.properties");
        if (file.exists() && file.isFile()) {
            config = new TimestampConfig(file.getAbsolutePath());
        } else {
            logger.info("file not found: {}", (Object)file.getAbsoluteFile());
            config = new TimestampConfig();
        }
        return config;
    }

    public TimestampConfig(String configFilePath) throws TSAException {
        this.loadConfig(configFilePath);
    }

    private final synchronized void loadConfig(String configFilePath) throws TSAException {
        logger.info("TimestampConfig File callLoadConfig running: {}", (Object)configFilePath);
        File configFile = new File(configFilePath);
        if (!configFile.isFile() || !configFile.exists()) {
            throw new TSAException(TSAErrorCode.timestampConfigFileMissing, "TimestampConfig File not found: " + configFile.getAbsolutePath());
        }
        OrderedProperties properties = new OrderedProperties();
        FileInputStream configInputStream = null;
        try {
            logger.info("TimestampConfig File load running: {}", (Object)configFilePath);
            configInputStream = new FileInputStream(configFile);
            properties.load(configInputStream);
            logger.info("TimestampConfig File load finished: {}", (Object)configFilePath);
        }
        catch (FileNotFoundException e) {
            throw new TSAException(TSAErrorCode.timestampConfigLoadFailure, "TimestampConfig File load failure: " + configFile, (Throwable)e);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timestampConfigLoadFailure, "TimestampConfig File load failure: " + configFile, (Throwable)e);
        }
        finally {
            try {
                if (configInputStream != null) {
                    configInputStream.close();
                }
            }
            catch (IOException e) {
                logger.warn("TimestampConfig File load and closed failure: {}", (Object)configFile, (Object)e);
            }
        }
        this.passwordEncryptTimes = 0;
        this.businessCertPath = properties.getProperty(keyBusinessCertPath, null);
        this.businessCertPassword = this.changedPassword(properties, keyBusinessCertPassword);
        this.businessTrustCertPath = properties.getProperty(keyBusinessTrustCertPath, null);
        this.businessTrustCRLPath = properties.getProperty(keyBusinessTrustCRLPath, null);
        this.jksTrustFilePath = properties.getProperty(keySslTrustStoreFilePath, null);
        this.jksTruestFilePassword = this.changedPassword(properties, keySslTrustStorePassword);
        this.jksKeyStoreFilePath = properties.getProperty(keySslKeyStoreFilePath, null);
        this.jksKeyStoreFilePassword = this.changedPassword(properties, keySslKeyStorePassword);
        this.sslProtocol = properties.getProperty(keySslProtocol, "TLSv1.2").trim();
        this.hostnameChecker = "true".equals(properties.getProperty(keySslHostnameChecker, "true"));
        this.httpURL = properties.getProperty(keyHttpURL, "http://127.0.0.1/timestamp");
        this.httpTimeout = Integer.parseInt(properties.getProperty(keyHttpTimeout, "2000"));
        this.httpAuthUsername = properties.getProperty(keyHttpAuthUsername, null);
        this.httpAuthPassword = this.changedPassword(properties, keyHttpAuthPassword);
        if (this.passwordEncryptTimes != 0) {
            FileOutputStream configOutputStream = null;
            try {
                logger.info("TimestampConfig File store running: {}", (Object)configFilePath);
                configOutputStream = new FileOutputStream(configFile);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                properties.store(configOutputStream, "changed " + configFile + " on " + sdf.format(new Date()));
                logger.info("TimestampConfig File store finished: {}", (Object)configFilePath);
            }
            catch (FileNotFoundException e) {
                throw new TSAException(TSAErrorCode.timestampConfigSaveFailure, "TimestampConfig File save failure: " + configFile, (Throwable)e);
            }
            catch (Exception e) {
                throw new TSAException(TSAErrorCode.timestampConfigSaveFailure, "TimestampConfig File save failure: " + configFile, (Throwable)e);
            }
            finally {
                try {
                    if (configOutputStream != null) {
                        configOutputStream.close();
                    }
                }
                catch (IOException e) {
                    logger.warn("TimestampConfig File changed and closed failure: {}", (Object)configFile, (Object)e);
                }
            }
        }
        logger.info("TimestampConfig File callLoadConfig finished: {}", (Object)configFilePath);
        this.passwordEncryptTimes = 0;
    }

    private final String changedPassword(Properties properties, String configKey) throws TSAException {
        String encryptPrefix = "ENCRYPT@";
        String plainPassword = properties.getProperty(configKey, "").trim();
        if (plainPassword.startsWith("ENCRYPT@")) {
            logger.info("TimestampConfig File decryptPassword configKey: {}", (Object)configKey);
            try {
                plainPassword = PasswordTool.decryptPassword(plainPassword.substring("ENCRYPT@".length()));
            }
            catch (Exception e) {
                logger.error("TimestampConfig File decryptPassword configKey: {}={}", (Object)configKey, (Object)plainPassword);
                throw new TSAException(TSAErrorCode.timestampConfigDecryptFailure, "TimestampConfig File decryptPassword failure: " + configKey, (Throwable)e);
            }
        }
        logger.info("TimestampConfig File encryptPassword configKey: {}", (Object)configKey);
        try {
            properties.setProperty(configKey, "ENCRYPT@" + PasswordTool.encryptPassword(plainPassword));
            ++this.passwordEncryptTimes;
        }
        catch (Exception e) {
            logger.error("TimestampConfig File encryptPassword configKey: {}", (Object)configKey);
            throw new TSAException(TSAErrorCode.timestampConfigEncryptFailure, "TimestampConfig File encryptPassword failure: " + configKey, (Throwable)e);
        }
        return plainPassword;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getJksTrustFilePath() {
        return this.jksTrustFilePath;
    }

    public void setJksTrustFilePath(String jksTrustFilePath) {
        this.jksTrustFilePath = jksTrustFilePath;
    }

    public String getJksTruestFilePassword() {
        return this.jksTruestFilePassword;
    }

    public void setJksTruestFilePassword(String jksTruestFilePassword) {
        this.jksTruestFilePassword = jksTruestFilePassword;
    }

    public String getJksKeyStoreFilePath() {
        return this.jksKeyStoreFilePath;
    }

    public void setJksKeyStoreFilePath(String jksKeyStoreFilePath) {
        this.jksKeyStoreFilePath = jksKeyStoreFilePath;
    }

    public String getJksKeyStoreFilePassword() {
        return this.jksKeyStoreFilePassword;
    }

    public void setJksKeyStoreFilePassword(String jksKeyStoreFilePassword) {
        this.jksKeyStoreFilePassword = jksKeyStoreFilePassword;
    }

    public String getHttpAuthUsername() {
        return this.httpAuthUsername;
    }

    public void setHttpAuthUsername(String httpAuthUsername) {
        this.httpAuthUsername = httpAuthUsername;
    }

    public String getHttpAuthPassword() {
        return this.httpAuthPassword;
    }

    public void setHttpAuthPassword(String httpAuthPassword) {
        this.httpAuthPassword = httpAuthPassword;
    }

    public String getHttpURL() {
        return this.httpURL;
    }

    public void setHttpURL(String httpURL) {
        this.httpURL = httpURL;
    }

    public int getHttpTimeout() {
        return this.httpTimeout;
    }

    public void setHttpTimeout(int httpTimeout) {
        this.httpTimeout = httpTimeout;
    }

    public String getBusinessCertPath() {
        return this.businessCertPath;
    }

    public void setBusinessCertPath(String businessCertPath) {
        this.businessCertPath = businessCertPath;
    }

    public String getBusinessCertPassword() {
        return this.businessCertPassword;
    }

    public void setBusinessCertPassword(String businessCertPassword) {
        this.businessCertPassword = businessCertPassword;
    }

    public String getBusinessTrustCertPath() {
        return this.businessTrustCertPath;
    }

    public void setBusinessTrustCertPath(String businessTrustCertPath) {
        this.businessTrustCertPath = businessTrustCertPath;
    }

    public String getBusinessTrustCRLPath() {
        return this.businessTrustCRLPath;
    }

    public void setBusinessTrustCRLPath(String businessTrustCRLPath) {
        this.businessTrustCRLPath = businessTrustCRLPath;
    }

    public boolean isHostnameChecker() {
        return this.hostnameChecker;
    }

    public void setHostnameChecker(boolean hostnameChecker) {
        this.hostnameChecker = hostnameChecker;
    }

    public final String toString() {
        return this.toString(false);
    }

    public final String toString(boolean hidden) {
        StringBuilder builder = new StringBuilder();
        builder.append("TimestampConfig [");
        builder.append("\n\t sslProtocol=");
        builder.append(this.sslProtocol);
        builder.append("\n\t jksTrustFilePath=");
        builder.append(this.jksTrustFilePath);
        builder.append("\n\t jksTruestFilePassword=");
        builder.append(hidden ? "" : this.jksTruestFilePassword);
        builder.append("\n\t jksKeyStoreFilePath=");
        builder.append(this.jksKeyStoreFilePath);
        builder.append("\n\t jksKeyStoreFilePassword=");
        builder.append(hidden ? "" : this.jksKeyStoreFilePassword);
        builder.append("\n\t jksHostnameChecker=");
        builder.append(this.hostnameChecker);
        builder.append("\n\t httpAuthUsername=");
        builder.append(this.httpAuthUsername);
        builder.append("\n\t httpAuthPassword=");
        builder.append(this.httpAuthPassword);
        builder.append("\n\t httpURL=");
        builder.append(this.httpURL);
        builder.append("\n\t httpTimeout=");
        builder.append(this.httpTimeout);
        builder.append("\n\t businessCertPath=");
        builder.append(this.businessCertPath);
        builder.append("\n\t businessCertPassword=");
        builder.append(hidden ? "" : this.businessCertPassword);
        builder.append("\n\t businessTrustCertPath=");
        builder.append(this.businessTrustCertPath);
        builder.append("\n\t businessTrustCRLPath=");
        builder.append(this.businessTrustCRLPath);
        builder.append("]");
        return builder.toString();
    }

    static {
        commentItems.put(keyBusinessCertPath, "\u4e1a\u52a1\u7b7e\u540d\u8bc1\u4e66\u5bc6\u94a5\u6587\u4ef6\u8def\u5f84\uff08\u540e\u7f00\u540d\u8981\u6c42PFX/P12\uff09");
        commentItems.put(keyBusinessCertPassword, "\u4e1a\u52a1\u7b7e\u540d\u8bc1\u4e66\u5bc6\u94a5\u6587\u4ef6\u53e3\u4ee4\uff08\u660e\u6587\u65f6\u7a0b\u5e8f\u81ea\u52a8\u52a0\u5bc6\u66f4\u65b0\uff09");
        commentItems.put(keyBusinessTrustCertPath, "\u4fe1\u4efb\u8bc1\u4e66\u6587\u4ef6\u8def\u5f84\uff0c\u6821\u9a8c\u65f6\u95f4\u6233\u7b7e\u540d\u8bc1\u4e66\u6709\u6548\u6027\uff08\u6ca1\u6709\u5219\u4e0d\u6821\u9a8c\uff09");
        commentItems.put(keyBusinessTrustCRLPath, "\u540a\u9500\u5217\u8868\u6587\u4ef6\u8def\u5f84\uff0c\u6821\u9a8c\u65f6\u95f4\u6233\u7b7e\u540d\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u6ca1\u6709\u5219\u4e0d\u6821\u9a8c\uff09");
        commentItems.put(keyHttpAuthUsername, "HTTP\u57fa\u672c\u8ba4\u8bc1\u7528\u6237\u540d\u79f0\uff08\u6ca1\u6709\u5219\u586b\u5145\u5230HTTP\u62a5\u6587\u5934\uff09");
        commentItems.put(keyHttpAuthPassword, "HTTP\u57fa\u672c\u8ba4\u8bc1\u7528\u6237\u5bc6\u7801\uff08\u660e\u6587\u65f6\u7a0b\u5e8f\u81ea\u52a8\u52a0\u5bc6\u66f4\u65b0\uff09");
        commentItems.put(keyHttpTimeout, "HTTP\u8bf7\u6c42\u8d85\u65f6\u65f6\u95f4\uff08\u5355\u4f4d\u6beb\u79d2\uff09");
        commentItems.put(keyHttpURL, "HTTP\u8bf7\u6c42\u8bbf\u95ee\u5730\u5740\uff0c\u5fc5\u987b\u4e3ahttp://\u6216\u8005https://\u4e3a\u524d\u7f00");
        commentItems.put(keySslKeyStoreFilePath, "HTTPS\u53cc\u5411\u5b89\u5168\u901a\u4fe1\u8bc1\u4e66\u5bc6\u94a5\u6587\u4ef6\u8def\u5f84");
        commentItems.put(keySslKeyStorePassword, "HTTPS\u53cc\u5411\u5b89\u5168\u901a\u4fe1\u8bc1\u4e66\u5bc6\u94a5\u6587\u4ef6\u53e3\u4ee4\uff08\u660e\u6587\u65f6\u7a0b\u5e8f\u81ea\u52a8\u52a0\u5bc6\u66f4\u65b0\uff09");
        commentItems.put(keySslTrustStoreFilePath, "HTTPS\u5b89\u5168\u901a\u4fe1\u8bc1\u4e66\u5bc6\u94a5\u6587\u4ef6\u8def\u5f84");
        commentItems.put(keySslTrustStorePassword, "HTTPS\u5b89\u5168\u901a\u4fe1\u8bc1\u4e66\u5bc6\u94a5\u6587\u4ef6\u53e3\u4ee4\uff08\u660e\u6587\u65f6\u7a0b\u5e8f\u81ea\u52a8\u52a0\u5bc6\u66f4\u65b0\uff09");
        commentItems.put(keySslProtocol, "HTTPS\u5b89\u5168\u901a\u4fe1\u534f\u8bae\uff08JDK1.6\u4e0d\u652f\u6301TLSv1.1\u3001TLSv1.2\uff09");
        commentItems.put(keySslHostnameChecker, "HTTPS\u5b89\u5168\u901a\u4fe1\u534f\u8bae\u662f\u5426\u6821\u9a8c\u670d\u52a1\u5668\u8bc1\u4e66\u522b\u540dIP\u5730\u5740\u548c\u8bbf\u95ee\u5730\u5740\u4e00\u81f4\u6027");
    }

    final class OrderedProperties
    extends Properties {
        private static final long serialVersionUID = 4193737010591705590L;
        private final LinkedHashSet<Object> items = new LinkedHashSet();

        OrderedProperties() {
        }

        @Override
        public Enumeration<Object> keys() {
            return Collections.enumeration(this.items);
        }

        @Override
        public Object put(Object key, Object value) {
            this.items.add(key);
            return super.put(key, value);
        }

        @Override
        public Set<Object> keySet() {
            return this.items;
        }

        @Override
        public Set<String> stringPropertyNames() {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (Object e : this.items) {
                set.add((String)e);
            }
            return set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void store(OutputStream out, String comments) throws IOException {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, "UTF8"));
            if (comments != null) {
                bw.write("#" + comments);
                bw.newLine();
            }
            OrderedProperties orderedProperties = this;
            synchronized (orderedProperties) {
                Enumeration<Object> e = this.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String val = (String)this.get(key);
                    String comment = (String)commentItems.get(key);
                    if (comment != null) {
                        bw.write("#" + comment);
                        bw.newLine();
                    }
                    bw.write(key + "=" + val);
                    bw.newLine();
                }
            }
            bw.flush();
        }
    }

    static final class PasswordTool {
        PasswordTool() {
        }

        static final String encryptPassword(String password) throws Exception {
            byte[] iv = SecureRandoms.getInstance().genBytes(16);
            IK ik = PasswordTool.KDF();
            byte[] enBytes = BCSoftLib.INSTANCE().encrypt(new Mechanism("SM4/CBC/PKCS7Padding", (Object)ik.iv(iv)), ik.key(), password.getBytes("utf8"));
            byte[] ouBytes = new byte[iv.length + enBytes.length];
            System.arraycopy(iv, 0, ouBytes, 0, iv.length);
            System.arraycopy(enBytes, 0, ouBytes, iv.length, enBytes.length);
            return Base64.toBase64String((byte[])((byte[])ouBytes.clone()));
        }

        static final String decryptPassword(String base64EncryptPassword) throws Exception {
            if (base64EncryptPassword.length() < 16) {
                throw new Exception("the length of encrepted password must be more than 16!");
            }
            byte[] data = Base64.decode((String)base64EncryptPassword);
            byte[] iv = Arrays.copyOfRange(data, 0, 16);
            IK ik = PasswordTool.KDF();
            byte[] encryptBytes = Arrays.copyOfRange(data, 16, data.length);
            byte[] passowrd = BCSoftLib.INSTANCE().decrypt(new Mechanism("SM4/CBC/PKCS7Padding", (Object)ik.iv(iv)), ik.key(), encryptBytes);
            return new String((byte[])passowrd.clone());
        }

        static final IK KDF() throws Exception {
            byte[] message = "OCSP@+VSEXAMLONGINX%He&&LONG".getBytes("utf8");
            byte[] ct = new byte[]{0, 0, 0, 1};
            SM3Digest sm3 = new SM3Digest();
            sm3.update(message, 0, message.length);
            sm3.update(ct, 0, ct.length);
            byte[] hash = new byte[32];
            sm3.doFinal(hash, 0);
            return new IK(hash);
        }

        static final class IK {
            final byte[] iv = new byte[16];
            final byte[] kx = new byte[16];

            IK(byte[] hash) {
                System.arraycopy(hash, 0, this.iv, 0, this.iv.length);
                System.arraycopy(hash, 16, this.kx, 0, this.kx.length);
            }

            private final CBCParam iv(byte[] iv) {
                byte[] dx = (byte[])iv.clone();
                for (int i = 0; i < iv.length; ++i) {
                    int n = i;
                    dx[n] = (byte)(dx[n] ^ this.iv[i]);
                }
                return new CBCParam(dx);
            }

            private final Key key() {
                return new SecretKeySpec(this.kx, "SM4");
            }
        }
    }
}

