/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import cpcn.dsp.institution.api.security.Aes256Util;
import cpcn.dsp.institution.api.security.SecurityUtil;
import cpcn.dsp.institution.api.security.Verifier;
import cpcn.dsp.institution.api.util.StringUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;

public class CertificateVerifier
implements Verifier {
    private PublicKey publicKey;
    private String algorithm = "SHA1withRSA";
    static Logger logger = Logger.getLogger((String)"system");
    private X509Certificate x509Certificate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertificateVerifier(String file) {
        FileInputStream fis = null;
        CertificateFactory cf = null;
        try {
            fis = new FileInputStream(file);
            cf = CertificateFactory.getInstance("X.509");
            this.x509Certificate = (X509Certificate)cf.generateCertificate(fis);
            this.publicKey = cf.generateCertificate(fis).getPublicKey();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertificateVerifier(String file, String algorithm) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.x509Certificate = (X509Certificate)cf.generateCertificate(fis);
            this.publicKey = this.x509Certificate.getPublicKey();
            this.algorithm = algorithm;
        }
        finally {
            if (null != fis) {
                fis.close();
            }
        }
    }

    @Override
    public boolean verify(String message, String signature) throws Exception {
        byte[] bytes = StringUtil.hex2bytes(signature);
        Signature sig = Signature.getInstance(this.algorithm);
        sig.initVerify(this.publicKey);
        sig.update(message.getBytes("UTF-8"));
        return sig.verify(bytes);
    }

    @Override
    public boolean verify(byte[] data, byte[] signature) throws Exception {
        Signature sig = Signature.getInstance(this.algorithm);
        sig.initVerify(this.publicKey);
        sig.update(data);
        return sig.verify(signature);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public String symmetricEncrypt(String message, String symmetricCipher) throws Exception {
        return Aes256Util.encode(message, symmetricCipher);
    }

    @Override
    public String getSN() throws Exception {
        return String.valueOf(this.x509Certificate.getSerialNumber());
    }

    @Override
    public String asymmetricEncrypt(byte[] message) throws Exception {
        return SecurityUtil.encryptByRSA(message, this.publicKey);
    }
}

