/*
 * Decompiled with CFR 0.152.
 */
package cfca.trustsign.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class CommonUtil {
    private static final String MASK = "[^ -()]";
    private static final String MASK_CHAR = "*";
    private static final String MASK_CHAR_4 = "****";
    private static final String LIKE_CHAR = "%";

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.trim().length() != 0;
    }

    public static boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static boolean isNotEmpty(byte[] bytes) {
        return bytes != null && bytes.length != 0;
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static boolean isNotEmpty(Object[] objects) {
        return objects != null && objects.length != 0;
    }

    public static <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    public static <T> boolean isNotEmpty(List<T> list) {
        return list != null && !list.isEmpty();
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> boolean isNotEmpty(Map<K, V> map) {
        return map != null && !map.isEmpty();
    }

    public static <K, V> List<V> mapToList(Map<K, V> map) {
        ArrayList<V> list = new ArrayList<V>();
        list.addAll(map.values());
        return list;
    }

    public static int booleanToInt(Boolean bool) {
        return bool == null ? 0 : (bool != false ? 1 : 0);
    }

    public static boolean intToBoolean(Integer i) {
        return i == null ? false : i != 0;
    }

    public static Number nvl(Number obj, Number value) {
        if (obj == null) {
            return value;
        }
        return obj;
    }

    public static String nvl(String str, String value) {
        if (CommonUtil.isEmpty(str)) {
            return value;
        }
        return str;
    }

    public static byte[] getBytes(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static boolean isContainNumbers(String str) {
        if (CommonUtil.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isDigit(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isFullNumbers(String str) {
        if (CommonUtil.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isContainsHtmlChar(String str) {
        if (CommonUtil.isEmpty(str)) {
            return false;
        }
        return str.contains("&lt") || str.contains("&gt") || str.contains("&amp") || str.contains("&quot") || str.contains("&apos");
    }

    public static String toString(String[] strings) {
        if (strings == null) {
            return "";
        }
        int iMax = strings.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(String.valueOf(strings[i]));
            if (i == iMax) {
                return b.toString();
            }
            b.append(";");
            ++i;
        }
    }

    public static boolean isRepeat(String[] strings) {
        if (strings == null) {
            return false;
        }
        HashSet<String> set = new HashSet<String>(Arrays.asList(strings));
        return set.size() < strings.length;
    }

    public static boolean isRepeat(List<String> list) {
        if (CommonUtil.isEmpty(list)) {
            return false;
        }
        return list.size() != new HashSet<String>(list).size();
    }

    public static void timeCostInfo(Logger logger, String string, long end, long start, long alarmTime) {
        long costTime = end - start;
        logger.info("{}: {} ms cost", (Object)string, (Object)costTime);
        if (costTime > alarmTime) {
            logger.error("Alarm, {}: {} ms cost", (Object)string, (Object)costTime);
        }
    }

    public static void timeCostDebug(Logger logger, String string, long end, long start, long alarmTime) {
        long costTime = end - start;
        logger.debug("{}: {} ms cost", (Object)string, (Object)costTime);
        if (costTime > alarmTime) {
            logger.error("Alarm, {}: {} ms cost", (Object)string, (Object)costTime);
        }
    }

    public static String mask(String str, int begin, int end) {
        return str.substring(0, begin) + str.substring(begin, end).replaceAll(MASK, MASK_CHAR) + str.substring(end, str.length());
    }

    public static String getLikeStr(String str) {
        return LIKE_CHAR + str + LIKE_CHAR;
    }

    public static String getRightLikeStr(String str) {
        return str + LIKE_CHAR;
    }

    public static boolean isChinese(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!CommonUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isGesturePassword(String str) {
        if (str.length() < 4 || str.length() > 9) {
            return false;
        }
        boolean[] booleans = new boolean[57];
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            if (booleans[str.charAt(i)]) {
                return false;
            }
            booleans[str.charAt((int)i)] = true;
        }
        return true;
    }

    public static long copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int length = 0;
        while (-1 != (length = is.read(buffer))) {
            os.write(buffer, 0, length);
            count += (long)length;
        }
        return count;
    }

    public static int getLength(byte[] bytes) {
        return CommonUtil.isNotEmpty(bytes) ? bytes.length : 0;
    }

    public static int getLength(String str) {
        return CommonUtil.isNotEmpty(str) ? str.length() : 0;
    }

    public static String getOriginalUserName(String userName, String originalUserName) {
        return CommonUtil.isNotEmpty(originalUserName) ? originalUserName : userName;
    }

    public static Class<?> getTClass(Class<?> klass, int position) {
        ParameterizedType type = (ParameterizedType)klass.getGenericSuperclass();
        return (Class)type.getActualTypeArguments()[position];
    }

    public static String maskEmail(String email) {
        if (email.contains("@")) {
            int suffix = email.indexOf("@");
            int prefix = suffix >= 4 ? 2 : 1;
            return email.substring(0, prefix) + MASK_CHAR_4 + email.substring(suffix - 1);
        }
        return email;
    }

    public static Integer convertStrToInt(String str) {
        return CommonUtil.isNotEmpty(str) ? Integer.valueOf(Integer.parseInt(str)) : null;
    }

    public static float[] unBoxFloat(Float[] arrayFloat) {
        if (CommonUtil.isNotEmpty(arrayFloat)) {
            float[] floats = new float[arrayFloat.length];
            for (int i = 0; i < arrayFloat.length; ++i) {
                floats[i] = arrayFloat[i].floatValue();
            }
            return floats;
        }
        return null;
    }
}

