/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.sm2;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.IExtendSM2;
import cfca.sadk.extend.session.bridge.CryptoConstant;
import cfca.sadk.extend.session.bridge.ICryptoBridgePartSM2;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardConstant;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardDataFormat;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardDummy;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardExternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardHashHelper;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardInternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardInvalidKey;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardKey;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardKeyHelper;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardLoggings;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardPublicKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTKey;
import cfca.sadk.system.logging.LoggerManager;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;

public final class SM2Card
implements IExtendSM2,
SM2CardConstant,
CryptoConstant {
    private ICryptoBridgePartSM2 cryptoAPI;

    public SM2Card(ICryptoBridgePartSM2 cryptoAPI) throws CryptoException {
        if (cryptoAPI == null) {
            throw new CryptoException("CryptoEngine construct failed: cryptoAPI is NULL");
        }
        this.cryptoAPI = cryptoAPI;
    }

    public KeyPair generateKeyPair(boolean isExport, int keyIndex, int keyUsage) throws CryptoException {
        KeyPair keyPair;
        int bitLength = 256;
        try {
            if (isExport) {
                keyPair = this.generateExternalKeyPair(256);
                this.checkKeyPairSignOperation(keyPair);
                this.checkKeyPairDecryptOperation(keyPair);
            } else {
                keyPair = this.generateInternalKeyPair(keyIndex, keyUsage);
                switch (keyUsage) {
                    case 2: {
                        this.checkKeyPairSignOperation(keyPair);
                        break;
                    }
                    case 1: {
                        this.checkKeyPairDecryptOperation(keyPair);
                        break;
                    }
                }
            }
        }
        catch (CryptoException e) {
            SM2CardLoggings.warningGenerateKeyPairFailed(isExport, 256, keyIndex, keyUsage, e);
            throw e;
        }
        catch (Exception e) {
            SM2CardLoggings.warningGenerateKeyPairFailed(isExport, 256, keyIndex, keyUsage, e);
            throw new CryptoException("SM2Card generateKeyPair failure", e);
        }
        catch (Throwable e) {
            SM2CardLoggings.warningGenerateKeyPairFailed(isExport, 256, keyIndex, keyUsage, e);
            throw new CryptoException("SM2Card generateKeyPair failure", e);
        }
        return keyPair;
    }

    public byte[] signByHash(PrivateKey privateKey, byte[] sm3HashValue) throws CryptoException {
        PrivateKey privKey = SM2CardKeyHelper.buildPrivateKey(privateKey);
        SM2CardKey sm2Key = privKey instanceof SM2CardKey ? (SM2CardKey)((Object)privKey) : SM2CardInvalidKey.INSTANCE;
        try {
            byte[] signData = sm2Key instanceof SM2CardInvalidKey ? SM2CardDummy.Dummy.INSTANCE.signByHash(privKey, sm3HashValue) : this.cardPrivateKeySignByHash(sm2Key, sm3HashValue);
            return signData;
        }
        catch (CryptoException e) {
            SM2CardLoggings.warningSignByHashFailed(sm2Key, sm3HashValue, e);
            throw e;
        }
        catch (Exception e) {
            SM2CardLoggings.warningSignByHashFailed(sm2Key, sm3HashValue, e);
            throw new CryptoException("SM2Card signByHash failure", e);
        }
        catch (Throwable e) {
            SM2CardLoggings.warningSignByHashFailed(sm2Key, sm3HashValue, e);
            throw new CryptoException("SM2Card signByHash failure", e);
        }
    }

    public boolean verifyByHash(PublicKey publicKey, byte[] sm3HashValue, byte[] signedData) throws CryptoException {
        int returnResult;
        PublicKey sm2Key = SM2CardKeyHelper.buildPublicKey(publicKey);
        SM2CardKey pubKey = sm2Key instanceof SM2CardKey ? (SM2CardKey)((Object)sm2Key) : SM2CardInvalidKey.INSTANCE;
        try {
            returnResult = this.cardPublicKeyVerifyByHash(pubKey, sm3HashValue, signedData);
            if (returnResult != 0) {
                SM2CardLoggings.warningVerifyByHashFailed(pubKey, sm3HashValue, signedData, returnResult);
            }
        }
        catch (CryptoException e) {
            SM2CardLoggings.warningVerifyByHashFailed(pubKey, sm3HashValue, signedData, e);
            throw e;
        }
        catch (Exception e) {
            SM2CardLoggings.warningVerifyByHashFailed(pubKey, sm3HashValue, signedData, e);
            throw new CryptoException("SM2Card verifyByHash failure", e);
        }
        catch (Throwable e) {
            SM2CardLoggings.warningVerifyByHashFailed(pubKey, sm3HashValue, signedData, e);
            throw new CryptoException("SM2Card verifyByHash failure", e);
        }
        return returnResult == 0;
    }

    public byte[] encrypt(PublicKey publicKey, byte[] sourceData) throws CryptoException {
        PublicKey sm2Key = SM2CardKeyHelper.buildPublicKey(publicKey);
        SM2CardKey pubKey = sm2Key instanceof SM2CardKey ? (SM2CardKey)((Object)sm2Key) : SM2CardInvalidKey.INSTANCE;
        try {
            byte[] dataOutput = this.cardPublicKeyEncrypt(pubKey, sourceData);
            return SM2CardDataFormat.convertToC1C3C2RAWEncryptData(dataOutput);
        }
        catch (CryptoException e) {
            SM2CardLoggings.warningEncryptFailed(pubKey, sourceData, e);
            throw e;
        }
        catch (Exception e) {
            SM2CardLoggings.warningEncryptFailed(pubKey, sourceData, e);
            throw new CryptoException("SM2Card [PublicKeyOperation]encrypt failure", e);
        }
        catch (Throwable e) {
            SM2CardLoggings.warningEncryptFailed(pubKey, sourceData, e);
            throw new CryptoException("SM2Card [PublicKeyOperation]encrypt failure", e);
        }
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] encryptData) throws CryptoException {
        PrivateKey privKey = SM2CardKeyHelper.buildPrivateKey(privateKey);
        SM2CardKey sm2Key = privKey instanceof SM2CardKey ? (SM2CardKey)((Object)privKey) : SM2CardInvalidKey.INSTANCE;
        try {
            byte[] decryptData;
            if (sm2Key instanceof SM2CardInvalidKey) {
                decryptData = SM2CardDummy.Dummy.INSTANCE.decrypt(privateKey, encryptData);
            } else {
                byte[] cardEncryptData = SM2CardDataFormat.convertToCardEncryptData(encryptData);
                decryptData = this.cardPrivateKeyDecrypt(sm2Key, cardEncryptData);
            }
            return decryptData;
        }
        catch (CryptoException e) {
            SM2CardLoggings.warninDecryptFailed(sm2Key, encryptData, e);
            throw e;
        }
        catch (Exception e) {
            SM2CardLoggings.warninDecryptFailed(sm2Key, encryptData, e);
            throw new CryptoException("SM2Card [PrivateKeyOperation]decrypt failure", e);
        }
        catch (Throwable e) {
            SM2CardLoggings.warninDecryptFailed(sm2Key, encryptData, e);
            throw new CryptoException("SM2Card [PrivateKeyOperation]decrypt failure", e);
        }
    }

    public PublicKey exportSM2ProtectKey() throws CryptoException {
        byte[] pubKeyData = new byte[68];
        try {
            int returnValue = this.cryptoAPI.exportProtectSM2Key(pubKeyData);
            if (returnValue != 0) {
                throw new CryptoException(String.format("cryptoAPI.exportProtectPublicKey returnValue=0x%08x", returnValue));
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2Card exportProtectPublicKey failure", (Throwable)e);
            throw new CryptoException("SM2Card exportProtectPublicKey failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2Card exportProtectPublicKey failure", e);
            throw new CryptoException("SM2Card exportProtectPublicKey failure", e);
        }
        return SM2CardPublicKey.buildExternalKey(pubKeyData);
    }

    public boolean importSM2EncryptKeyPair(int keyIndex, byte[] encryptKeyData) throws CryptoException {
        boolean successfully;
        int fixedLength = 192;
        if (encryptKeyData == null || encryptKeyData.length != 192) {
            LoggerManager.exceptionLogger.error("importEncryptKeyPair failed: param encryptKeyData is null/not enough length");
            throw new CryptoException("importEncryptKeyPair failed: param encryptKeyData is null/not enough length");
        }
        try {
            byte[] cardEncryptData = SM2CardDataFormat.convertToCardEncryptData(encryptKeyData);
            int returnValue = this.cryptoAPI.importEncryptedSM2KeyPairs(keyIndex, cardEncryptData);
            boolean bl = successfully = returnValue == 0;
            if (!successfully) {
                throw new CryptoException(String.format("cryptoAPI.importEncryptedSM2KeyPairs returnValue=0x%08x", returnValue));
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2Card importEncryptedSM2KeyPairs failure", (Throwable)e);
            throw new CryptoException("SM2Card importEncryptedSM2KeyPairs failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2Card importEncryptedSM2KeyPairs failure", e);
            throw new CryptoException("SM2Card importEncryptedSM2KeyPairs failure", e);
        }
        return successfully;
    }

    public boolean idleTest() throws CryptoException {
        try {
            return this.cryptoAPI.idleTest();
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2Card idleTest failure", (Throwable)e);
            throw new CryptoException("SM2Card idleTest failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2Card idleTest failure", e);
            throw new CryptoException("SM2Card idleTest failure", e);
        }
    }

    private boolean verifyByHashWithCard(KeyPair keyPair, byte[] hashWithAlgorithm, byte[] signData) throws CryptoException {
        boolean verifyResult = this.verifyByHash(keyPair.getPublic(), hashWithAlgorithm, signData);
        if (!verifyResult) {
            throw new CryptoException("verifyByHashWithCard return False");
        }
        return verifyResult;
    }

    private boolean verifyByHashWithSoft(KeyPair keyPair, byte[] hashWithAlgorithm, byte[] signData) throws CryptoException {
        boolean verifyResult = SM2CardDummy.Dummy.INSTANCE.verifyByHash(keyPair.getPublic(), hashWithAlgorithm, signData);
        if (!verifyResult) {
            throw new CryptoException("verifyByHashWithSoft return False");
        }
        return verifyResult;
    }

    private KeyPair generateExternalKeyPair(int strengthBitsLength) throws CryptoException {
        if (strengthBitsLength != 256) {
            throw new CryptoException("SM2Card cryptoAPI.generateKeyPairSM2 rejected with invalid bitLength=" + strengthBitsLength);
        }
        byte[] pubKeyData = new byte[68];
        byte[] priKeyData = new byte[36];
        try {
            int returnValue = this.cryptoAPI.generateKeyPairSM2(131328, strengthBitsLength, pubKeyData, priKeyData);
            if (returnValue != 0) {
                throw new CryptoException(String.format("cryptoAPI.generateKeyPairSM2 returnValue=0x%08x", returnValue));
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2Card cryptoAPI.generateKeyPairSM2 failure", (Throwable)e);
            throw new CryptoException("SM2Card cryptoAPI.generateKeyPairSM2 failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2Card cryptoAPI.generateKeyPairSM2 failure", e);
            throw new CryptoException("SM2Card cryptoAPI.generateKeyPairSM2 failure", e);
        }
        SM2CardPublicKey publicKey = SM2CardPublicKey.buildExternalKey(pubKeyData);
        SM2CardExternalPrivateKey privateKey = SM2CardExternalPrivateKey.buildExternalSoftKey(priKeyData);
        return new KeyPair(publicKey, privateKey);
    }

    private byte[] cardPrivateKeySignByHash(SM2CardKey sm2Key, byte[] dataInput) throws CryptoException {
        if (sm2Key == null) {
            throw new CryptoParameterException("SM2Card cardPrivateKeySignByHash rejected: sm2Key = null");
        }
        if (dataInput == null || dataInput.length == 0) {
            throw new CryptoParameterException("SM2Card cardPrivateKeySignByHash rejected: dataInput = null ");
        }
        int hashLength = 32;
        if (dataInput.length != 32) {
            throw new CryptoParameterException("SM2Card cardPrivateKeySignByHash rejected:  dataInputLength= " + dataInput.length + ",hashLength=" + 32);
        }
        int signLength = 64;
        byte[] dataOutput = new byte[64];
        try {
            if (sm2Key.isInternalKey()) {
                int keyIndex = this.ensureKeyIndexValid(sm2Key.getKeyIndex());
                int returnValue = this.cryptoAPI.internalSignSM2(keyIndex, dataInput, dataInput.length, dataOutput);
                if (returnValue != 0) {
                    throw new CryptoException(String.format("cryptoAPI.internalSignSM2 returnValue=0x%08x", returnValue));
                }
            } else {
                int returnValue = this.cryptoAPI.externalSignSM2(131328, sm2Key.keyData(), dataInput, dataInput.length, dataOutput);
                if (returnValue != 0) {
                    throw new CryptoException(String.format("cryptoAPI.externalSignSM2 returnValue=0x%08x", returnValue));
                }
            }
        }
        catch (Exception e) {
            String message = SM2CardLoggings.buildPrivateKeySignByHashFailedMessage(sm2Key, dataInput);
            LoggerManager.exceptionLogger.error("SM2Card cardPrivateKeySignByHash failure", (Throwable)e);
            throw new CryptoException(message, e);
        }
        catch (Throwable e) {
            String message = SM2CardLoggings.buildPrivateKeySignByHashFailedMessage(sm2Key, dataInput);
            LoggerManager.exceptionLogger.error("SM2Card cardPrivateKeySignByHash failure", e);
            throw new CryptoException(message, e);
        }
        return dataOutput;
    }

    private int cardPublicKeyVerifyByHash(SM2CardKey sm2Key, byte[] dataInput, byte[] signature) throws CryptoException {
        int returnValue;
        if (sm2Key == null) {
            throw new CryptoParameterException("SM2Card cardPublicKeyVerifyByHash rejected: sm2Key = null");
        }
        if (dataInput == null || dataInput.length == 0) {
            throw new CryptoParameterException("SM2Card cardPublicKeyVerifyByHash rejected: dataInput = null");
        }
        int hashLength = 32;
        if (dataInput.length != 32) {
            throw new CryptoParameterException("SM2Card cardPublicKeyVerifyByHash rejected:  dataInputLength= " + dataInput.length + ",hashLength=" + 32);
        }
        if (signature == null || signature.length == 0) {
            throw new CryptoParameterException("SM2Card cardPublicKeyVerifyByHash rejected: signature = null");
        }
        int signLength = 64;
        if (signature.length != 64) {
            throw new CryptoParameterException("SM2Card cardPublicKeyVerifyByHash rejected:  signatureLength= " + signature.length + ",signLength=" + 64);
        }
        try {
            if (sm2Key.isInternalKey()) {
                int keyIndex = this.ensureKeyIndexValid(sm2Key.getKeyIndex());
                returnValue = this.cryptoAPI.internalVerifySM2(keyIndex, dataInput, dataInput.length, signature);
                if (returnValue != 0) {
                    LoggerManager.exceptionLogger.error(String.format("cryptoAPI.internalVerifySM2 returnValue=0x%08x", returnValue));
                }
            } else {
                returnValue = this.cryptoAPI.externalVerifySM2(131328, sm2Key.keyData(), dataInput, dataInput.length, signature);
                if (returnValue != 0) {
                    LoggerManager.exceptionLogger.error(String.format("cryptoAPI.externalVerifySM2 returnValue=0x%08x", returnValue));
                }
            }
        }
        catch (Exception e) {
            String message = SM2CardLoggings.buildPublicKeyVerifyByHashFailedMessage(sm2Key, dataInput);
            LoggerManager.exceptionLogger.error("SM2Card cardPublicKeyVerifyByHash failure", (Throwable)e);
            throw new CryptoException(message, e);
        }
        catch (Throwable e) {
            String message = SM2CardLoggings.buildPublicKeyVerifyByHashFailedMessage(sm2Key, dataInput);
            LoggerManager.exceptionLogger.error("SM2Card cardPublicKeyVerifyByHash failure", e);
            throw new CryptoException(message, e);
        }
        return returnValue;
    }

    private byte[] cardPublicKeyEncrypt(SM2CardKey sm2Key, byte[] dataInput) throws CryptoException {
        if (sm2Key == null) {
            throw new CryptoParameterException("SM2Card cardPublicKeyEncrypt rejected: sm2Key = null");
        }
        if (dataInput == null || dataInput.length == 0) {
            throw new CryptoParameterException("SM2Card cardPublicKeyEncrypt rejected: dataInput = null");
        }
        int minLength = 100;
        byte[] dataOutput = new byte[100 + dataInput.length];
        try {
            if (sm2Key.isInternalKey() && sm2Key.getKeyUsage() == 1) {
                int keyIndex = this.ensureKeyIndexValid(sm2Key.getKeyIndex());
                int returnValue = this.cryptoAPI.internalEncryptSM2(keyIndex, 131328, dataInput, dataInput.length, dataOutput);
                if (returnValue != 0) {
                    throw new CryptoException(String.format("cryptoAPI.internalEncryptSM2 returnValue=0x%08x", returnValue));
                }
            } else {
                int returnValue = this.cryptoAPI.externalEncryptSM2(131328, sm2Key.keyData(), dataInput, dataInput.length, dataOutput);
                if (returnValue != 0) {
                    throw new CryptoException(String.format("cryptoAPI.externalEncryptSM2 returnValue=0x%08x", returnValue));
                }
            }
        }
        catch (Exception e) {
            String message = SM2CardLoggings.buildPublicKeyVerifyByHashFailedMessage(sm2Key, dataInput);
            LoggerManager.exceptionLogger.error("SM2Card cardPublicKeyEncrypt failure", (Throwable)e);
            throw new CryptoException(message, e);
        }
        catch (Throwable e) {
            String message = SM2CardLoggings.buildPublicKeyVerifyByHashFailedMessage(sm2Key, dataInput);
            LoggerManager.exceptionLogger.error("SM2Card cardPublicKeyEncrypt failure", e);
            throw new CryptoException(message, e);
        }
        return dataOutput;
    }

    private byte[] cardPrivateKeyDecrypt(SM2CardKey sm2Key, byte[] dataInput) throws CryptoException {
        if (sm2Key == null) {
            throw new CryptoParameterException("SM2Card cardPrivateKeyDecrypt rejected: sm2Key = null");
        }
        int minLength = 100;
        if (dataInput == null || dataInput.length < 100) {
            throw new CryptoParameterException("SM2Card cardPrivateKeyDecrypt rejected: dataInput = null ");
        }
        byte[] dataOutput = new byte[dataInput.length - 100];
        int[] dataOutputSize = new int[]{0};
        try {
            if (sm2Key.isInternalKey()) {
                int algID;
                int keyIndex = this.ensureKeyIndexValid(sm2Key.getKeyIndex());
                int returnValue = this.cryptoAPI.internalDecryptSM2(keyIndex, algID = sm2Key.getKeyUsage() == 2 ? 131584 : 131328, dataInput, dataOutput, dataOutputSize);
                if (returnValue != 0) {
                    throw new CryptoException(String.format("cryptoAPI.internalDecryptSM2 returnValue=0x%08x", returnValue));
                }
            } else {
                int returnValue = this.cryptoAPI.externalDecryptSM2(131328, sm2Key.keyData(), dataInput, dataOutput, dataOutputSize);
                if (returnValue != 0) {
                    throw new CryptoException(String.format("cryptoAPI.externalDecryptSM2 returnValue=0x%08x", returnValue));
                }
            }
        }
        catch (Exception e) {
            String message = SM2CardLoggings.buildPrivateKeySignByHashFailedMessage(sm2Key, dataInput);
            LoggerManager.exceptionLogger.error("SM2Card cardPrivateKeyDecrypt failure", (Throwable)e);
            throw new CryptoException(message, e);
        }
        catch (Throwable e) {
            String message = SM2CardLoggings.buildPrivateKeySignByHashFailedMessage(sm2Key, dataInput);
            LoggerManager.exceptionLogger.error("SM2Card cardPrivateKeyDecrypt failure", e);
            throw new CryptoException(message, e);
        }
        if (dataOutputSize[0] != dataOutput.length) {
            throw new CryptoException("SM2Card cardPrivateKeyDecrypt failure with dataOutputSize!=modulusBitsLength");
        }
        return dataOutput;
    }

    private KeyPair generateInternalKeyPair(int keyIndex, int keyUsage) throws CryptoException {
        this.ensureKeyIndexValid(keyIndex);
        if (keyUsage != 2 && keyUsage != 1) {
            throw new CryptoException("SM2Card cryptoAPI.exportPublicKeySM2 rejected with keyUsage=" + keyUsage);
        }
        byte[] pubKeyData = new byte[68];
        try {
            int returnValue = this.cryptoAPI.exportPublicKeySM2(keyIndex, keyUsage, pubKeyData);
            if (returnValue != 0) {
                throw new CryptoException(String.format("cryptoAPI.exportPublicKeySM2 returnValue=0x%08x", returnValue));
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2Card cryptoAPI.generateKeyPairSM2Ex failure", (Throwable)e);
            throw new CryptoException("SM2Card cryptoAPI.exportPublicKeySM2 failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2Card cryptoAPI.generateKeyPairSM2Ex failure", e);
            throw new CryptoException("SM2Card cryptoAPI.exportPublicKeySM2 failure", e);
        }
        SM2CardPublicKey publicKey = SM2CardPublicKey.buildInternalKey(keyIndex, keyUsage, pubKeyData);
        SM2CardInternalPrivateKey privateKey = new SM2CardInternalPrivateKey(keyIndex, keyUsage, pubKeyData);
        return new KeyPair(publicKey, privateKey);
    }

    private boolean checkKeyPairSignOperation(KeyPair keyPair) throws CryptoException {
        boolean checkPassed = false;
        byte[] sm3HashValue = DataHelper.decodeHexString("45f70cf58f607e6d891c93f594f1826ffb3a0ddea7d2a0753b0c110836d6aecb");
        byte[] sm2SignValue = this.signByHash(keyPair.getPrivate(), sm3HashValue);
        try {
            this.verifyByHashWithCard(keyPair, sm3HashValue, sm2SignValue);
            this.verifyByHashWithSoft(keyPair, sm3HashValue, sm2SignValue);
            checkPassed = true;
        }
        catch (Exception e) {
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                StringBuilder builder = new StringBuilder(2048);
                builder.append("\nSM2Card checkKeyPairSignOperation: check keypair failure: ");
                SM2CardLoggings.buildKeyPairCheckFailed(builder, keyPair);
                builder.append("\nsm3HashValue: ").append(DataHelper.dump4KPartData(sm3HashValue));
                builder.append("\nsm2SignValue: ").append(DataHelper.dump4KPartData(sm2SignValue));
                LoggerManager.exceptionLogger.error(builder.toString(), (Throwable)e);
            }
            throw new CryptoException("SM2Card checkKeyPairSignOperation: check keypair failure", e);
        }
        return checkPassed;
    }

    private boolean checkKeyPairDecryptOperation(KeyPair keyPair) throws CryptoException {
        boolean checkPassed = false;
        byte[] sourceData = DataHelper.decodeHexString("45f70cf58f607e6d891c93f594f1826ffb3a0ddea7d2a0753b0c110836d6aecb");
        byte[] encryptData = null;
        byte[] decryptData = null;
        String encryptType = null;
        try {
            encryptType = "encryptByHard";
            encryptData = this.encrypt(keyPair.getPublic(), sourceData);
            decryptData = this.decrypt(keyPair.getPrivate(), encryptData);
            checkPassed = Arrays.equals(sourceData, decryptData);
            if (!checkPassed) {
                throw new CryptoException("SM2Card generateKeyPair: check keypair failure[encryptByHard]");
            }
            encryptType = "encryptBySoft";
            encryptData = SM2CardDummy.Dummy.INSTANCE.encrypt(keyPair.getPublic(), sourceData);
            decryptData = this.decrypt(keyPair.getPrivate(), encryptData);
            checkPassed = Arrays.equals(sourceData, decryptData);
            if (!checkPassed) {
                throw new CryptoException("SM2Card generateKeyPair: check keypair failure[encryptBySoft]");
            }
        }
        catch (CryptoException e) {
            String warning = "SM2Card generateKeyPair: check keypair failure[" + encryptType + "]";
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                StringBuilder builder = new StringBuilder(2048);
                builder.append("\n").append(warning);
                SM2CardLoggings.buildKeyPairCheckFailed(builder, keyPair);
                builder.append("\nsourceData: ").append(DataHelper.dump4KPartData(sourceData));
                builder.append("\nencryptData: ").append(DataHelper.dump4KPartData(encryptData));
                LoggerManager.exceptionLogger.error(builder.toString(), (Throwable)e);
            }
            throw new CryptoException(warning, e);
        }
        return checkPassed;
    }

    public int ensureKeyIndexValid(int keyIndex) throws CryptoException {
        return keyIndex;
    }

    public byte[] sm3(GMTKey cardKey, byte[] sourceData) throws CryptoException {
        return SM2CardHashHelper.sm3(cardKey, sourceData);
    }

    public byte[] sm3(GMTKey cardKey, InputStream sourceStream) throws CryptoException {
        return SM2CardHashHelper.sm3(cardKey, sourceStream);
    }
}

