/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;

public final class ECCCardSignValue {
    private ECCCardSignValue() {
    }

    public static byte[] encodeToStdAsn1(ECCCurveId curveId, byte[] encoding) throws CryptoException {
        if (curveId == null) {
            throw new CryptoException("missing curveId");
        }
        if (encoding == null) {
            throw new CryptoException("missing signature encoding");
        }
        if (encoding.length != 132) {
            throw new CryptoException("invalid signature encodingLength");
        }
        byte[] rBytes = new byte[encoding.length >> 1];
        byte[] sBytes = new byte[encoding.length >> 1];
        System.arraycopy(encoding, 0, rBytes, 0, rBytes.length);
        System.arraycopy(encoding, sBytes.length, sBytes, 0, sBytes.length);
        BigInteger rInt = new BigInteger(1, rBytes);
        BigInteger sInt = new BigInteger(1, sBytes);
        int bitLegnth = curveId.getCurveBitLength();
        if (rInt.bitLength() > bitLegnth) {
            throw new CryptoException("invalid signature rBitLegnth>" + bitLegnth);
        }
        if (sInt.bitLength() > bitLegnth) {
            throw new CryptoException("invalid signature sBitLegnth>" + bitLegnth);
        }
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new ASN1Integer(rInt));
            v.add(new ASN1Integer(sInt));
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            throw new CryptoException("signature encoding failed", e);
        }
    }

    public static byte[] decodeFromStdAsn1(ECCCurveId curveId, byte[] encoding) throws CryptoException {
        BigInteger sInt;
        BigInteger rInt;
        if (curveId == null) {
            throw new CryptoException("missing curveId");
        }
        if (encoding == null) {
            throw new CryptoException("missing signature encoding");
        }
        try {
            ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray(encoding);
            rInt = ((ASN1Integer)seq.getObjectAt(0)).getPositiveValue();
            sInt = ((ASN1Integer)seq.getObjectAt(1)).getPositiveValue();
        }
        catch (IOException e) {
            throw new CryptoException("invalid signature encoding", e);
        }
        int bitLegnth = curveId.getCurveBitLength();
        if (rInt.bitLength() > bitLegnth) {
            throw new CryptoException("invalid signature rBitLegnth>" + bitLegnth);
        }
        if (sInt.bitLength() > bitLegnth) {
            throw new CryptoException("invalid signature sBitLegnth>" + bitLegnth);
        }
        byte[] signData = new byte[132];
        int length = signData.length >> 1;
        System.arraycopy(BigIntegers.asUnsignedByteArray(length, rInt), 0, signData, 0, length);
        System.arraycopy(BigIntegers.asUnsignedByteArray(length, sInt), 0, signData, length, length);
        return signData;
    }
}

