/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.net;

import cpcn.dsp.institution.api.net.IgnoreHostnameVerifier;
import cpcn.dsp.institution.api.security.SecurityUtil;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public final class SecurityContext {
    public static SSLContext sslContext;
    public static SSLSocketFactory sslSocketFactory;

    private SecurityContext() {
    }

    public static synchronized void initSSLSocketFactory(String protocol, String keyStore, String keyStoreType, String keyStorePassword, String trustKeyStore, String trustKeyStoreType, String trustKeyStorePassword) throws Exception {
        KeyManager[] kms = SecurityUtil.getKeyManagers(keyStore, keyStoreType, keyStorePassword);
        TrustManager[] tms = SecurityUtil.getTrustManagers(trustKeyStore, trustKeyStoreType, trustKeyStorePassword);
        sslContext = SSLContext.getInstance(protocol);
        sslContext.init(kms, tms, null);
        sslSocketFactory = sslContext.getSocketFactory();
    }

    public static synchronized void initSSLSocketFactory(String trustKeyStore, String trustKeyStorePassword) throws Exception {
        TrustManager[] tms = SecurityUtil.getTrustManagers(trustKeyStore, "JKS", trustKeyStorePassword);
        sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tms, null);
        sslSocketFactory = sslContext.getSocketFactory();
    }

    public static synchronized void initSSLSocketFactory(String protocol) throws Exception {
        sslContext = SSLContext.getInstance(protocol);
        sslContext.init(null, null, null);
        sslSocketFactory = sslContext.getSocketFactory();
    }

    public static void setIgnoreHostname(boolean ignoreHostname) {
        if (ignoreHostname) {
            HttpsURLConnection.setDefaultHostnameVerifier(new IgnoreHostnameVerifier());
        }
    }
}

