/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.crypto.ExtendedDigest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA384Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import cfca.sadk.org.bouncycastle.operator.bc.BcDigestProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class TSADigestProviderHelper {
    static final Map<ASN1ObjectIdentifier, BcDigestProvider> lookupDigestTable = TSADigestProviderHelper.createDigestTable();
    static final Map<ASN1ObjectIdentifier, Mechanism> lookupMechanismTable = TSADigestProviderHelper.createMechanismTable();
    static final TSADigestProviderHelper INSTANCE = new TSADigestProviderHelper();

    private TSADigestProviderHelper() {
    }

    static Map<ASN1ObjectIdentifier, BcDigestProvider> createDigestTable() {
        HashMap<ASN1ObjectIdentifier, Object> table = new HashMap<ASN1ObjectIdentifier, Object>();
        BcDigestProvider sha1DigestProvider = new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA1Digest();
            }
        };
        table.put(OIWObjectIdentifiers.idSHA1, sha1DigestProvider);
        table.put(OIWObjectIdentifiers.sha1WithRSA, sha1DigestProvider);
        table.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, sha1DigestProvider);
        BcDigestProvider sha256DigestProvider = new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA256Digest();
            }
        };
        table.put(NISTObjectIdentifiers.id_sha256, sha256DigestProvider);
        table.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, sha256DigestProvider);
        BcDigestProvider sha384DigestProvider = new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA384Digest();
            }
        };
        table.put(NISTObjectIdentifiers.id_sha384, sha384DigestProvider);
        table.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, sha384DigestProvider);
        BcDigestProvider sha512DigestProvider = new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA512Digest();
            }
        };
        table.put(NISTObjectIdentifiers.id_sha512, sha512DigestProvider);
        table.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, sha512DigestProvider);
        BcDigestProvider sm3DigestProvider = new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SM3Digest();
            }
        };
        table.put(GMObjectIdentifiers.sm3, sm3DigestProvider);
        table.put(GMObjectIdentifiers.sm3WithSM2Encryption, sm3DigestProvider);
        return Collections.unmodifiableMap(table);
    }

    static Map<ASN1ObjectIdentifier, Mechanism> createMechanismTable() {
        HashMap<ASN1ObjectIdentifier, Mechanism> table = new HashMap<ASN1ObjectIdentifier, Mechanism>();
        table.put(OIWObjectIdentifiers.sha1WithRSA, new Mechanism("sha1WithRSAEncryption"));
        table.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, new Mechanism("sha1WithRSAEncryption"));
        table.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, new Mechanism("sha256WithRSAEncryption"));
        table.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, new Mechanism("sha384WithRSAEncryption"));
        table.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, new Mechanism("sha512WithRSAEncryption"));
        table.put(GMObjectIdentifiers.sm3WithSM2Encryption, new Mechanism("sm3WithSM2Encryption"));
        return Collections.unmodifiableMap(table);
    }

    static final ExtendedDigest lookup(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        ExtendedDigest engine = null;
        if (algorithmIdentifier != null) {
            BcDigestProvider extProv = lookupDigestTable.get(algorithmIdentifier.getAlgorithm());
            if (extProv == null) {
                String oid = algorithmIdentifier != null && algorithmIdentifier.getAlgorithm() != null ? algorithmIdentifier.getAlgorithm().getId() : "missing algorithmIdentifier";
                throw new OperatorCreationException("cannot recognise algorithmIdentifier: " + oid);
            }
            engine = extProv.get(algorithmIdentifier);
        }
        return engine;
    }

    static final Mechanism lookupMechanism(AlgorithmIdentifier signatureAlgorithmIdentifier) throws OperatorCreationException {
        Mechanism mechanism = null;
        if (signatureAlgorithmIdentifier != null) {
            mechanism = lookupMechanismTable.get(signatureAlgorithmIdentifier.getAlgorithm());
        }
        if (mechanism == null) {
            String oid = signatureAlgorithmIdentifier != null && signatureAlgorithmIdentifier.getAlgorithm() != null ? signatureAlgorithmIdentifier.getAlgorithm().getId() : "missing signatureAlgorithmIdentifier";
            throw new OperatorCreationException("cannot recognise signatureAlgorithmIdentifier: " + oid);
        }
        return mechanism;
    }
}

