/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.timestamp.client.SSLContext;
import cfca.sadk.timestamp.client.api.TimestampConfig;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.tls.sun.security.ssl.JSSEProvider;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

class SSLContextManager {
    static final Logger logger = LoggerFactory.getLogger(SSLContextManager.class);
    public static final String GMSSL = "GMTLSv1.1";
    final SSLContext context = new SSLContext();
    private final String keystoreType;
    private final String algorithmType;
    private static boolean isAddProvider = false;

    SSLContextManager(boolean isGMSSL) {
        if (isGMSSL) {
            this.keystoreType = "BKS";
            this.algorithmType = "GMTX509";
            if (!isAddProvider) {
                Security.addProvider((Provider)new BouncyCastleProvider());
                Security.addProvider((Provider)new JSSEProvider());
                isAddProvider = true;
            }
        } else {
            this.keystoreType = "JKS";
            this.algorithmType = "SunX509";
        }
    }

    final void initSSLKeyManager(String jksKeyFilePath, String jksKeyStoreFilePassword) throws TSAException {
        logger.debug("TLSContextManager@initSSLKeyManager running {}", (Object)jksKeyFilePath);
        if (jksKeyFilePath == null) {
            throw new TSAException(TSAErrorCode.httpsSSLKeyManagerFilePathMissing, "jksKeyFilePath must not be null!");
        }
        if (jksKeyStoreFilePassword == null) {
            throw new TSAException(TSAErrorCode.httpsSSLKeyManagerFilePasswordMissing, "jksFilePassword must not be null!");
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(jksKeyFilePath);
            KeyStore keyStore = KeyStore.getInstance(this.keystoreType);
            keyStore.load(fis, jksKeyStoreFilePassword.toCharArray());
            KeyManagerFactory factory = KeyManagerFactory.getInstance(this.algorithmType);
            factory.init(keyStore, jksKeyStoreFilePassword.toCharArray());
            this.context.setKeyManager(factory);
            logger.debug("TLSContextManager@initSSLKeyManager successulluy");
        }
        catch (UnrecoverableKeyException e) {
            throw new TSAException(TSAErrorCode.httpsSSLKeyManagerFilePasswordInvalid, "jksFilePassword invalid: " + jksKeyStoreFilePassword, (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new TSAException(TSAErrorCode.httpsSSLKeyManagerFilePathNotFound, "jksKeyFilePath not found: " + jksKeyFilePath, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TSAException(TSAErrorCode.httpsSSLKeyManagerAlgorithmInvalid, jksKeyFilePath + ": " + e.getMessage(), (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new TSAException(TSAErrorCode.httpsSSLKeyManagerKeyStoreInvalid, jksKeyFilePath + ": " + e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            throw new TSAException(TSAErrorCode.httpsSSLKeyManagerCertificateInvalid, jksKeyFilePath + ": " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TSAException(TSAErrorCode.httpsSSLKeyManagerIOError, jksKeyFilePath + ": " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.httpsSSLKeyManagerUnknownError, jksKeyFilePath + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.warn(jksKeyFilePath + " is not closed successfully!");
                }
            }
            logger.debug("TLSContextManager@initSSLKeyManager finished");
        }
    }

    final void initSSLTrustManager(String jksTrustFilePath, String jksTruestFilePassword) throws TSAException {
        logger.debug("TLSContextManager@initSSLTrustManager running {}", (Object)jksTrustFilePath);
        if (jksTrustFilePath == null) {
            throw new TSAException(TSAErrorCode.httpsSSLKeyManagerFilePathMissing, "jksTrustFilePath must not be null!");
        }
        if (jksTruestFilePassword == null) {
            throw new TSAException(TSAErrorCode.httpsSSLKeyManagerFilePasswordMissing, "jksTruestFilePassword must not be null!");
        }
        FileInputStream fis = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(this.keystoreType);
            fis = new FileInputStream(jksTrustFilePath);
            keyStore.load(fis, jksTruestFilePassword.toCharArray());
            TrustManagerFactory factory = TrustManagerFactory.getInstance(this.algorithmType);
            factory.init(keyStore);
            this.context.setTrustManager(factory);
            logger.debug("TLSContextManager@initSSLKeyManager successfully");
        }
        catch (FileNotFoundException e) {
            throw new TSAException(TSAErrorCode.httpsSSLTrustManagerFilePathNotFound, "jksTrustFilePath not found: " + jksTrustFilePath, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TSAException(TSAErrorCode.httpsSSLTrustManagerAlgorithmInvalid, jksTrustFilePath + ": " + e.getMessage(), (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new TSAException(TSAErrorCode.httpsSSLTrustManagerKeyStoreInvalid, jksTrustFilePath + ": " + e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            throw new TSAException(TSAErrorCode.httpsSSLTrustManagerCertificateInvalid, jksTrustFilePath + ": " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TSAException(TSAErrorCode.httpsSSLTrustManagerIOError, jksTrustFilePath + ": " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.httpsSSLTrustManagerUnknownError, jksTrustFilePath + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.warn(jksTrustFilePath + " is not closed successfully!");
                }
            }
            logger.debug("TLSContextManager@initSSLTrustManager finished");
        }
    }

    final void initSSLContext(String protocol) throws TSAException {
        this.context.initContext(protocol);
    }

    static final SSLContextManager buildTLSContextManager(TimestampConfig config) throws TSAException {
        URL serverUrl;
        if (config == null) {
            throw new TSAException(TSAErrorCode.httpsSSLContextManagerBuildFailureMissingConfig, "missing TimestampConfig");
        }
        if (SSLContextManager.isEmpty(config.getHttpURL())) {
            throw new TSAException(TSAErrorCode.httpsSSLContextManagerBuildFailureMissingHttpURL, "missing httpURL");
        }
        try {
            serverUrl = new URL(config.getHttpURL());
        }
        catch (MalformedURLException e) {
            throw new TSAException(TSAErrorCode.httpsSSLContextManagerBuildFailureInvalidHttpURL, "invalid httpURL other than start with http or https: " + config.getHttpURL(), (Throwable)e);
        }
        String protocol = serverUrl.getProtocol();
        if (!protocol.startsWith("http")) {
            throw new TSAException(TSAErrorCode.httpsSSLContextManagerBuildFailureNotSupportProtocol, "do not support other than http or https: " + serverUrl);
        }
        SSLContextManager sslManager = null;
        if (protocol.startsWith("https")) {
            boolean isGMSSL = GMSSL.equalsIgnoreCase(config.getSslProtocol());
            sslManager = new SSLContextManager(isGMSSL);
            if (SSLContextManager.isEmpty(config.getJksTrustFilePath())) {
                throw new TSAException(TSAErrorCode.httpsSSLContextManagerBuildFailureRequiredTrustFile, "required JksTrustFilePath: " + config.getJksTrustFilePath());
            }
            sslManager.initSSLTrustManager(config.getJksTrustFilePath(), config.getJksTruestFilePassword());
            if (!SSLContextManager.isEmpty(config.getJksKeyStoreFilePath())) {
                sslManager.initSSLKeyManager(config.getJksKeyStoreFilePath(), config.getJksKeyStoreFilePassword());
            }
            sslManager.initSSLContext(config.getSslProtocol());
        } else {
            sslManager = new SSLContextManager(false);
        }
        return sslManager;
    }

    static final boolean isEmpty(String value) {
        return value == null || value.isEmpty() || value.trim().length() == 0;
    }
}

