/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.common.X9ObjectIdentifiers;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.security.PublicKey;

public final class TSACertHolder
extends X509CertificateHolder {
    public static final int CERT_TYPE_SM2CERT = 1;
    public static final int CERT_TYPE_RSACERT = 2;
    private byte[] encoding = null;
    private PublicKey publicKey;
    private int certType = -1;

    public TSACertHolder(byte[] certEncoding) throws IOException {
        super(certEncoding);
        this.encoding = certEncoding == null ? null : (byte[])certEncoding.clone();
    }

    public TSACertHolder(Certificate x509Certificate) {
        super(x509Certificate);
    }

    public static TSACertHolder from(X509CertificateHolder x509Cert) {
        if (x509Cert == null) {
            throw new IllegalArgumentException("missing x509Cert");
        }
        return new TSACertHolder(x509Cert.toASN1Structure());
    }

    public static TSACertHolder from(X509Cert x509Cert) {
        if (x509Cert == null) {
            throw new IllegalArgumentException("missing x509Cert");
        }
        TSACertHolder holder = new TSACertHolder(x509Cert.getCertStructure());
        holder.encoding = x509Cert.getEncoding();
        return holder;
    }

    public byte[] getEncoded() throws IOException {
        if (this.encoding == null) {
            this.encoding = super.getEncoded();
        }
        return this.encoding;
    }

    public PublicKey getPublicKey() throws PKIException {
        if (this.publicKey == null) {
            PublicKey publicKey;
            this.publicKey = publicKey = this.buildPublicKey(this.toASN1Structure());
        }
        return this.publicKey;
    }

    public boolean isSM2Cert() {
        this.buildCertType();
        return this.certType == 1;
    }

    public boolean isRSACert() {
        this.buildCertType();
        return this.certType == 2;
    }

    private final PublicKey buildPublicKey(Certificate cert) throws PKIException {
        this.buildCertType();
        BCRSAPublicKey publicKey = null;
        switch (this.certType) {
            case 1: {
                SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
                byte[] pubData = subjectPublicKeyInfo.getPublicKeyData().getBytes();
                if (pubData == null || pubData.length != 64 && pubData.length != 65) {
                    throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES);
                }
                int starter = pubData.length == 65 ? 1 : 0;
                byte[] pubX = new byte[32];
                byte[] pubY = new byte[32];
                System.arraycopy(pubData, starter, pubX, 0, 32);
                System.arraycopy(pubData, starter + 32, pubY, 0, 32);
                publicKey = new SM2PublicKey(pubX, pubY);
                break;
            }
            case 2: {
                try {
                    SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
                    RSAPublicKey pubKey = RSAPublicKey.getInstance((Object)subjectPublicKeyInfo.parsePublicKey());
                    RSAKeyParameters param = new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
                    publicKey = new BCRSAPublicKey(param);
                    break;
                }
                catch (Exception e) {
                    throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES, (Throwable)e);
                }
            }
            default: {
                throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES);
            }
        }
        return publicKey;
    }

    private final void buildCertType() {
        if (this.certType == -1) {
            int certType = 0;
            Certificate cert = this.toASN1Structure();
            if (cert != null) {
                SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
                AlgorithmIdentifier algorithm = subjectPublicKeyInfo.getAlgorithm();
                String keyTypeAlgorithmId = algorithm.getAlgorithm().getId();
                if (keyTypeAlgorithmId.equals(PKCSObjectIdentifiers.rsaEncryption.getId())) {
                    certType = 2;
                } else if (keyTypeAlgorithmId.equals(GMObjectIdentifiers.ecPubKey.getId())) {
                    ASN1Encodable parameters = algorithm.getParameters();
                    if (parameters != null && parameters instanceof ASN1ObjectIdentifier) {
                        ASN1ObjectIdentifier param = (ASN1ObjectIdentifier)parameters;
                        if (param.equals((Object)GMObjectIdentifiers.sm2_old)) {
                            certType = 1;
                        } else if (param.equals((Object)GMObjectIdentifiers.sm2PubKey)) {
                            certType = 1;
                        }
                    }
                    if (certType != 1) {
                        String signAlgorithmId = cert.getSignatureAlgorithm().getAlgorithm().getId();
                        if (signAlgorithmId.equals(X9ObjectIdentifiers.sm3WithSM2Encryption.getId())) {
                            certType = 1;
                        } else if (signAlgorithmId.equals(X9ObjectIdentifiers.sm3WithSM2Encryption_OLD.getId())) {
                            certType = 1;
                        }
                    }
                }
                this.certType = certType;
            }
        }
    }

    public X509Cert getX509Cert() {
        return new X509Cert(this.toASN1Structure());
    }
}

