/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

final class SSLContext {
    private javax.net.ssl.SSLContext context;
    private KeyManagerFactory keyManager;
    private TrustManagerFactory trustManager;

    final void setKeyManager(KeyManagerFactory keyManager) {
        this.keyManager = keyManager;
    }

    final void setTrustManager(TrustManagerFactory trustManager) {
        this.trustManager = trustManager;
    }

    final void initContext(String protocol) throws TSAException {
        javax.net.ssl.SSLContext context;
        if (this.trustManager == null) {
            throw new TSAException(TSAErrorCode.httpsMissingTrustManager, "trustManager required not be null!!!");
        }
        try {
            context = javax.net.ssl.SSLContext.getInstance(protocol);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TSAException(TSAErrorCode.httpsSSLContentInstanceFailure, "SSLProtocol algorithm not supported: " + protocol, (Throwable)e);
        }
        try {
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            if (this.keyManager != null) {
                keyManagers = this.keyManager.getKeyManagers();
            }
            trustManagers = this.trustManager.getTrustManagers();
            context.init(keyManagers, trustManagers, null);
        }
        catch (KeyManagementException e) {
            throw new TSAException(TSAErrorCode.httpsSSLContentInitFailure, "KeyManagement invalid", (Throwable)e);
        }
        this.context = context;
    }

    final javax.net.ssl.SSLContext getContext() {
        return this.context;
    }
}

