/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.net;

import cpcn.dsp.institution.api.io.IoUtil;
import cpcn.dsp.institution.api.net.HttpData;
import cpcn.dsp.institution.api.net.HttpsConnection;
import cpcn.dsp.institution.api.net.NameValuePair;
import cpcn.dsp.institution.api.net.SecurityContext;
import cpcn.dsp.institution.api.system.CodeException;
import cpcn.dsp.institution.api.util.Base64;
import cpcn.dsp.institution.api.util.GUID;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;

public class HttpsConnectionByHttpClient
extends HttpsConnection {
    private String uri;
    private String hostname;
    private int port;
    private String userName;
    private String password;

    public HttpsConnectionByHttpClient(String uri) {
        this.uri = uri;
    }

    public HttpsConnectionByHttpClient(String uri, String hostname, int port, String userName, String password) {
        this.uri = uri;
        this.hostname = hostname;
        this.port = port;
        this.userName = userName;
        this.password = password;
    }

    @Override
    public String send(List<NameValuePair> list) throws IOException {
        HttpData httpData = new HttpData(list, this.outputCharset);
        String request = httpData.getData();
        return this.send(request);
    }

    @Override
    public String send(String request) throws IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        if (this.useHttpProxy) {
            HttpHost httpProxy = new HttpHost(this.hostname, this.port);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.hostname, this.port), (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)httpProxy);
            httpClient.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        X509HostnameVerifier x509HostnameVerifier = this.ignoreHostname ? SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER : SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
        if (!this.useDefaultSSLSocketFactory) {
            SSLSocketFactory sslSocketFactory = new SSLSocketFactory(SecurityContext.sslContext, x509HostnameVerifier);
            URL url = new URL(this.uri);
            int urlPort = url.getPort();
            if (urlPort == -1) {
                urlPort = 443;
            }
            Scheme scheme = new Scheme("https", urlPort, (SchemeSocketFactory)sslSocketFactory);
            httpClient.getConnectionManager().getSchemeRegistry().register(scheme);
        }
        httpClient.getParams().setParameter("http.connection.timeout", (Object)this.connectionTimeout);
        httpClient.getParams().setParameter("http.socket.timeout", (Object)this.readTimeout);
        HttpPost httpPost = new HttpPost(this.uri);
        BasicHeader header = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
        httpPost.addHeader((Header)header);
        StringEntity stringEntity = new StringEntity(request, "application/x-www-form-urlencoded", this.outputCharset);
        httpPost.setEntity((HttpEntity)stringEntity);
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity httpEntity = httpResponse.getEntity();
        InputStream inputStream = httpEntity.getContent();
        String response = new String(IoUtil.read(inputStream, 1024), this.inputCharset).trim();
        inputStream.close();
        return response;
    }

    @Override
    public String sendWithAttachment(Map<String, String> paramMap, Map<String, String> fileMap) throws IOException, CodeException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        if (this.useHttpProxy) {
            HttpHost httpProxy = new HttpHost(this.hostname, this.port);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.hostname, this.port), (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)httpProxy);
            httpClient.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        X509HostnameVerifier x509HostnameVerifier = this.ignoreHostname ? SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER : SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
        if (!this.useDefaultSSLSocketFactory) {
            SSLSocketFactory sslSocketFactory = new SSLSocketFactory(SecurityContext.sslContext, x509HostnameVerifier);
            URL url = new URL(this.uri);
            int urlPort = url.getPort();
            if (urlPort == -1) {
                urlPort = 443;
            }
            Scheme scheme = new Scheme("https", urlPort, (SchemeSocketFactory)sslSocketFactory);
            httpClient.getConnectionManager().getSchemeRegistry().register(scheme);
        }
        HttpPost httpPost = new HttpPost(this.uri);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setCharset(Charset.forName("UTF-8"));
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        this.addParamToMultipartEntityBuilder(multipartEntityBuilder, paramMap, fileMap);
        HttpEntity reqEntity = multipartEntityBuilder.build();
        httpPost.setEntity(reqEntity);
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity httpEntity = httpResponse.getEntity();
        InputStream inputStream = httpEntity.getContent();
        String response = new String(IoUtil.read(inputStream, 1024), this.inputCharset).trim();
        inputStream.close();
        return response;
    }

    private List<String> addParamToMultipartEntityBuilder(MultipartEntityBuilder multipartEntityBuilder, Map<String, String> paramMap, Map<String, String> fileMap) throws CodeException {
        ArrayList<String> fileNameTmp = new ArrayList<String>();
        try {
            String tmpPath = "/CPCN/DSP/DSPInstitutionSimulator/fileTrans/";
            File tempDir = new File(tmpPath);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            String perfix = null;
            for (Map.Entry<String, String> entry : fileMap.entrySet()) {
                perfix = GUID.genTxNo(16);
                String tempFileName = perfix + entry.getKey();
                fileNameTmp.add(tempFileName);
                File file = new File(tmpPath + tempFileName);
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(Base64.encode(entry.getValue().getBytes("UTF-8")));
                fos.flush();
                fos.close();
                FileBody fileBody = new FileBody(file);
                multipartEntityBuilder.addPart("file", (ContentBody)fileBody);
            }
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                StringBody comment = new StringBody(URLEncoder.encode(entry.getValue(), "UTF-8"), ContentType.TEXT_PLAIN);
                multipartEntityBuilder.addPart(entry.getKey(), (ContentBody)comment);
            }
        }
        catch (CodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeException("", "", e);
        }
        return fileNameTmp;
    }

    public static void main(String[] args) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        System.out.println(httpClient.getParams().getParameter("http.connection.timeout"));
        System.out.println(httpClient.getParams().getParameter("http.socket.timeout"));
    }
}

