/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.rsa;

import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.BERSequence;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SafeBag;

public class SafeContents
implements ASN1Encodable {
    private SafeBag[] safeBag;

    public static SafeContents getInstance(Object o) {
        SafeContents output = null;
        if (o == null) {
            output = null;
        } else if (o instanceof SafeContents) {
            output = (SafeContents)o;
        } else if (o instanceof ASN1Sequence) {
            output = new SafeContents((ASN1Sequence)o);
        } else {
            throw new IllegalArgumentException("unknown object in factory " + o.getClass().getName());
        }
        return output;
    }

    public SafeContents(SafeBag[] _safeBag) {
        this.safeBag = _safeBag;
    }

    public SafeContents(ASN1Sequence seq) {
        this.safeBag = new SafeBag[seq.size()];
        for (int i = 0; i < this.safeBag.length; ++i) {
            this.safeBag[i] = SafeBag.getInstance(seq.getObjectAt(i));
        }
    }

    public SafeBag[] getSafeBag() {
        return this.safeBag;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < this.safeBag.length; ++i) {
            v.add(this.safeBag[i]);
        }
        return new BERSequence(v);
    }
}

