/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.sm2;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.sm2.SM2Result;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.lib.crypto.bcsoft.BCSoftSM2;
import cfca.sadk.lib.crypto.jni.JNISM2;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.Key;

public class SM2PackageUtil {
    public static byte[] encryptByBC(byte[] digestData, Key privateKey) throws Exception {
        byte[] sign = new byte[64];
        if (digestData == null || digestData.length != 32) {
            throw new Exception("the digest data is null or not 32 bytes!");
        }
        SM2PrivateKey key = null;
        if (!(privateKey instanceof SM2PrivateKey)) {
            throw new PKIException("The private key type is not sm2 type!");
        }
        key = (SM2PrivateKey)privateKey;
        BCSoftSM2 bcSoftSM2 = new BCSoftSM2();
        SM2Result sm2Ret = new SM2Result();
        bcSoftSM2.sign(digestData, key.getDByInt(), sm2Ret);
        System.arraycopy(BigIntegerUtil.asUnsigned32ByteArray(sm2Ret.r), 0, sign, 0, 32);
        System.arraycopy(BigIntegerUtil.asUnsigned32ByteArray(sm2Ret.s), 0, sign, 32, 32);
        return sign;
    }

    public static boolean verifyByBC(byte[] digestData, byte[] signValue, Key publicKey) throws Exception {
        if (digestData == null || digestData.length != 32) {
            throw new Exception("the digest data is null or not 32 bytes!");
        }
        SM2Result sm2Ret = null;
        if (signValue != null && signValue.length == 64) {
            sm2Ret = new SM2Result();
            sm2Ret.r = new BigInteger(1, Arrays.copyOfRange(signValue, 0, 32));
            sm2Ret.s = new BigInteger(1, Arrays.copyOfRange(signValue, 32, 64));
        } else if (ASN1SM2Signature.isASN1SignType(signValue)) {
            ASN1SM2Signature signature = new ASN1SM2Signature(signValue);
            sm2Ret = new SM2Result();
            sm2Ret.r = signature.getR().getPositiveValue();
            sm2Ret.s = signature.getS().getPositiveValue();
        } else {
            throw new Exception("the signature data is null or not 64 bytes!");
        }
        SM2PublicKey sm2PubKey = null;
        sm2PubKey = publicKey instanceof SM2PublicKey ? (SM2PublicKey)publicKey : new SM2PublicKey(publicKey.getEncoded());
        BCSoftSM2 sm2 = new BCSoftSM2();
        return sm2.verify(digestData, sm2PubKey.getQ(), sm2Ret);
    }

    public static final byte[] encryptByJNI(byte[] digestData, BigInteger da) throws Exception {
        byte[] sign = new byte[64];
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        if (digestData == null || digestData.length != 32) {
            throw new Exception("the digest data is null or not 32 bytes!");
        }
        JNISM2.sign(digestData, BigIntegerUtil.asUnsigned32ByteArray(da), r, s);
        System.arraycopy(r, 0, sign, 0, 32);
        System.arraycopy(s, 0, sign, 32, 32);
        return sign;
    }

    public static boolean verifyByJNI(byte[] digestData, byte[] signValue, byte[] pubX, byte[] pubY) throws Exception {
        if (digestData == null || digestData.length != 32) {
            throw new Exception("the digest data is null or not 32 bytes!");
        }
        byte[] r = null;
        byte[] s = null;
        if (signValue != null && signValue.length == 64) {
            r = new byte[32];
            s = new byte[32];
            System.arraycopy(signValue, 0, r, 0, 32);
            System.arraycopy(signValue, 32, s, 0, 32);
        } else if (ASN1SM2Signature.isASN1SignType(signValue)) {
            ASN1SM2Signature signature = new ASN1SM2Signature(signValue);
            r = BigIntegers.asUnsignedByteArray(32, signature.getR().getPositiveValue());
            s = BigIntegers.asUnsignedByteArray(32, signature.getS().getPositiveValue());
        } else {
            throw new Exception("the signature data is null or not 64 bytes!");
        }
        return JNISM2.verify(r, s, pubX, pubY, digestData);
    }
}

