/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.extend.session.IExtendECC;
import cfca.sadk.extend.session.bridge.CryptoConstant;
import cfca.sadk.extend.session.bridge.ICryptoBridgePartECC;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardConstant;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardDummy;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardExternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardHashHelper;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardInternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardInvalidKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKeyHelper;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardLoggings;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardPublicKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardSignValue;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;

public final class ECCCard
implements IExtendECC,
ECCCardConstant,
CryptoConstant {
    private final ICryptoBridgePartECC cryptoAPI;

    public ECCCard(ICryptoBridgePartECC cryptoAPI) throws CryptoException {
        if (cryptoAPI == null) {
            throw new CryptoException("CryptoEngine construct failed: cryptoAPI is NULL");
        }
        this.cryptoAPI = cryptoAPI;
    }

    public KeyPair generateKeyPair(boolean isExport, int keyIndex, int keyUsage, int curveId) throws CryptoException {
        KeyPair keyPair;
        boolean bitLength = false;
        try {
            if (isExport) {
                keyPair = this.generateExternalKeyPair(curveId);
                this.checkKeyPairSignOperation(keyPair);
                this.checkKeyPairDecryptOperation(keyPair);
            } else {
                keyPair = this.generateInternalKeyPair(keyIndex, keyUsage);
                switch (keyUsage) {
                    case 2: {
                        this.checkKeyPairSignOperation(keyPair);
                        break;
                    }
                    case 1: {
                        throw new UnsupportedOperationException("ECCCard#generateKeyPair->ENCRYPTION_KEY");
                    }
                }
            }
        }
        catch (CryptoException e) {
            ECCCardLoggings.warningGenerateKeyPairFailed(isExport, 0, keyIndex, keyUsage, e);
            throw e;
        }
        catch (Exception e) {
            ECCCardLoggings.warningGenerateKeyPairFailed(isExport, 0, keyIndex, keyUsage, e);
            throw new CryptoException("ECCCard generateKeyPair failure", e);
        }
        catch (Throwable e) {
            ECCCardLoggings.warningGenerateKeyPairFailed(isExport, 0, keyIndex, keyUsage, e);
            throw new CryptoException("ECCCard generateKeyPair failure", e);
        }
        return keyPair;
    }

    public byte[] signByHash(PrivateKey privateKey, byte[] hashValue) throws CryptoException {
        ECCCardKey eccKey = (ECCCardKey)((Object)ECCCardKeyHelper.buildPrivateKey(privateKey));
        try {
            byte[] hashData = ECCCardHashHelper.formatHashData(eccKey, hashValue, true);
            byte[] signData = this.cardPrivateKeySignByHash(eccKey, hashData);
            return signData;
        }
        catch (CryptoException e) {
            ECCCardLoggings.warningSignByHashFailed(eccKey, hashValue, e);
            throw e;
        }
        catch (Exception e) {
            ECCCardLoggings.warningSignByHashFailed(eccKey, hashValue, e);
            throw new CryptoException("ECCCard signByHash failure", e);
        }
        catch (Throwable e) {
            ECCCardLoggings.warningSignByHashFailed(eccKey, hashValue, e);
            throw new CryptoException("ECCCard signByHash failure", e);
        }
    }

    public boolean verifyByHash(PublicKey publicKey, byte[] hashValue, byte[] signValue) throws CryptoException {
        int returnResult;
        PublicKey eccKey = ECCCardKeyHelper.buildPublicKey(publicKey);
        ECCCardKey pubKey = eccKey instanceof ECCCardKey ? (ECCCardKey)((Object)eccKey) : ECCCardInvalidKey.INSTANCE;
        try {
            byte[] hashData = ECCCardHashHelper.formatHashData(pubKey, hashValue, true);
            returnResult = this.cardPublicKeyVerifyByHash(pubKey, hashData, signValue);
            if (returnResult != 0) {
                ECCCardLoggings.warningVerifyByHashFailed(pubKey, hashData, signValue, returnResult);
            }
        }
        catch (CryptoException e) {
            ECCCardLoggings.warningVerifyByHashFailed(pubKey, hashValue, signValue, e);
            throw e;
        }
        catch (Exception e) {
            ECCCardLoggings.warningVerifyByHashFailed(pubKey, hashValue, signValue, e);
            throw new CryptoException("ECCCard verifyByHash failure", e);
        }
        catch (Throwable e) {
            ECCCardLoggings.warningVerifyByHashFailed(pubKey, hashValue, signValue, e);
            throw new CryptoException("ECCCard verifyByHash failure", e);
        }
        return returnResult == 0;
    }

    public byte[] encrypt(PublicKey publicKey, byte[] sourceData, AlgorithmParameterSpec params) throws CryptoException {
        throw new UnsupportedOperationException("ECCCard#encrypt");
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] encryptData, AlgorithmParameterSpec params) throws CryptoException {
        throw new UnsupportedOperationException("ECCCard#decrypt");
    }

    public boolean idleTest() throws CryptoException {
        try {
            return this.cryptoAPI.idleTest();
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("ECCCard idleTest failure", (Throwable)e);
            throw new CryptoException("ECCCard idleTest failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("ECCCard idleTest failure", e);
            throw new CryptoException("ECCCard idleTest failure", e);
        }
    }

    public int ensureKeyIndexValid(int keyIndex) throws CryptoException {
        return keyIndex;
    }

    public ICryptoBridgePartECC getCryptoAPI() {
        return this.cryptoAPI;
    }

    public byte[] hash(Mechanism mechanism, byte[] sourceData) throws CryptoException {
        return ECCCardHashHelper.hash(mechanism, sourceData);
    }

    public byte[] hash(Mechanism mechanism, InputStream sourceStream) throws CryptoException {
        return ECCCardHashHelper.hash(mechanism, sourceStream);
    }

    private KeyPair generateInternalKeyPair(int keyIndex, int keyUsage) throws CryptoException {
        ECCCardPublicKey publicKey;
        this.ensureKeyIndexValid(keyIndex);
        if (keyUsage != 2 && keyUsage != 1) {
            throw new CryptoException("ECCCard cryptoAPI.exportPublicKeyECC rejected with keyUsage=" + keyUsage);
        }
        byte[] pubKeyData = new byte[140];
        try {
            int returnValue = this.cryptoAPI.exportPublicKeyECC(keyIndex, keyUsage, pubKeyData);
            if (returnValue != 0) {
                throw new CryptoException(String.format("cryptoAPI.exportPublicKeyECC returnValue=0x%08x", returnValue));
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("ECCCard cryptoAPI.generateKeyPairECCEx failure", (Throwable)e);
            throw new CryptoException("ECCCard cryptoAPI.exportPublicKeyECC failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("ECCCard cryptoAPI.generateKeyPairECCEx failure", e);
            throw new CryptoException("ECCCard cryptoAPI.exportPublicKeyECC failure", e);
        }
        try {
            publicKey = ECCCardPublicKey.buildInternalKey(keyIndex, keyUsage, pubKeyData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("ECCCard buildInternalPublicKey failure: " + SADKDebugger.dump(pubKeyData), (Throwable)e);
            throw new CryptoException("ECCCard buildInternalPublicKey failure", e);
        }
        ECCCardInternalPrivateKey privateKey = new ECCCardInternalPrivateKey(keyIndex, keyUsage, publicKey);
        return new KeyPair(publicKey, privateKey);
    }

    private KeyPair generateExternalKeyPair(int curveId) throws CryptoException {
        PublicKey publicKey;
        ECCCurveId curve = ECCCurveId.findECCCurveId(curveId);
        if (curve == null) {
            throw new CryptoException("ECCCard cryptoAPI.generateKeyPairECC rejected with invalid curveId=" + curveId);
        }
        if (!ECCCurveId.isCardSupport(curve)) {
            throw new CryptoException("ECCCard cryptoAPI.generateKeyPairECC rejected with unsupport curveId=" + curveId);
        }
        byte[] pubKeyData = new byte[140];
        byte[] priKeyData = new byte[74];
        int bitLength = curve.getCurveBitLength();
        try {
            int returnValue = this.cryptoAPI.generateKeyPairECC(curveId, bitLength, pubKeyData, priKeyData);
            if (returnValue != 0) {
                throw new CryptoException(String.format("cryptoAPI.generateKeyPairECC returnValue=0x%08x", returnValue));
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("ECCCard cryptoAPI.generateKeyPairECC failure", (Throwable)e);
            throw new CryptoException("ECCCard cryptoAPI.generateKeyPairECC failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("ECCCard cryptoAPI.generateKeyPairECC failure", e);
            throw new CryptoException("ECCCard cryptoAPI.generateKeyPairECC failure", e);
        }
        try {
            publicKey = ECCCardPublicKey.buildExternalKey(pubKeyData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("ECCCard buildExternalPublicKey failure: " + SADKDebugger.dump(pubKeyData), (Throwable)e);
            throw new CryptoException("ECCCard buildExternalPublicKey failure", e);
        }
        PrivateKey privateKey = ECCCardExternalPrivateKey.buildExternalSoftKey(priKeyData);
        return new KeyPair(publicKey, privateKey);
    }

    private byte[] cardPrivateKeySignByHash(ECCCardKey eccKey, byte[] dataInput) throws CryptoException {
        if (eccKey == null) {
            throw new CryptoParameterException("ECCCard cardPrivateKeySignByHash rejected: eccKey = null");
        }
        if (dataInput == null || dataInput.length == 0) {
            throw new CryptoParameterException("ECCCard cardPrivateKeySignByHash rejected: dataInput = null ");
        }
        if (dataInput.length != eccKey.getCurveByteLength()) {
            throw new CryptoParameterException("ECCCard cardPrivateKeySignByHash rejected:  dataInputLength= " + dataInput.length + ",requiredHashLength=" + eccKey.getCurveByteLength());
        }
        byte[] dataOutput = new byte[132];
        try {
            if (eccKey.isInternalKey()) {
                int keyIndex = this.ensureKeyIndexValid(eccKey.getKeyIndex());
                int returnValue = this.cryptoAPI.internalSignECC(keyIndex, dataInput, dataInput.length, dataOutput);
                if (returnValue != 0) {
                    throw new CryptoException(String.format("cryptoAPI.internalSignECC returnValue=0x%08x", returnValue));
                }
            } else {
                int returnValue = this.cryptoAPI.externalSignECC(262144, eccKey.keyData(), dataInput, dataInput.length, dataOutput);
                if (returnValue != 0) {
                    throw new CryptoException(String.format("cryptoAPI.externalSignECC returnValue=0x%08x", returnValue));
                }
            }
            return ECCCardSignValue.encodeToStdAsn1(eccKey.getCurveId(), dataOutput);
        }
        catch (Exception e) {
            String message = ECCCardLoggings.buildPrivateKeySignByHashFailedMessage(eccKey, dataInput);
            LoggerManager.exceptionLogger.error("ECCCard cardPrivateKeySignByHash failure", (Throwable)e);
            throw new CryptoException(message, e);
        }
        catch (Throwable e) {
            String message = ECCCardLoggings.buildPrivateKeySignByHashFailedMessage(eccKey, dataInput);
            LoggerManager.exceptionLogger.error("ECCCard cardPrivateKeySignByHash failure", e);
            throw new CryptoException(message, e);
        }
    }

    private int cardPublicKeyVerifyByHash(ECCCardKey eccKey, byte[] dataInput, byte[] signature) throws CryptoException {
        int returnValue;
        if (eccKey == null) {
            throw new CryptoParameterException("ECCCard cardPublicKeyVerifyByHash rejected: eccKey = null");
        }
        if (dataInput == null || dataInput.length == 0) {
            throw new CryptoParameterException("ECCCard cardPublicKeyVerifyByHash rejected: dataInput = null");
        }
        if (dataInput.length != eccKey.getCurveByteLength()) {
            throw new CryptoParameterException("ECCCard cardPublicKeyVerifyByHash rejected:  dataInputLength= " + dataInput.length + ",requiredHashLength=" + eccKey.getCurveByteLength());
        }
        if (signature == null || signature.length == 0) {
            throw new CryptoParameterException("ECCCard cardPublicKeyVerifyByHash rejected: signature = null");
        }
        try {
            byte[] signData = ECCCardSignValue.decodeFromStdAsn1(eccKey.getCurveId(), signature);
            if (signData.length != 132) {
                throw new CryptoParameterException("ECCCard cardPublicKeyVerifyByHash rejected:  signatureLength= " + signature.length + ",requiredLength=" + 132);
            }
            if (eccKey.isInternalKey()) {
                int keyIndex = this.ensureKeyIndexValid(eccKey.getKeyIndex());
                returnValue = this.cryptoAPI.internalVerifyECC(keyIndex, dataInput, dataInput.length, signData);
                if (returnValue != 0) {
                    LoggerManager.exceptionLogger.error(String.format("cryptoAPI.internalVerifyECC returnValue=0x%08x", returnValue));
                }
            } else {
                returnValue = this.cryptoAPI.externalVerifyECC(262144, eccKey.keyData(), dataInput, dataInput.length, signData);
                if (returnValue != 0) {
                    LoggerManager.exceptionLogger.error(String.format("cryptoAPI.externalVerifyECC returnValue=0x%08x", returnValue));
                }
            }
        }
        catch (Exception e) {
            String message = ECCCardLoggings.buildPublicKeyVerifyByHashFailedMessage(eccKey, dataInput, signature);
            LoggerManager.exceptionLogger.error("ECCCard cardPublicKeyVerifyByHash failure", (Throwable)e);
            throw new CryptoException(message, e);
        }
        catch (Throwable e) {
            String message = ECCCardLoggings.buildPublicKeyVerifyByHashFailedMessage(eccKey, dataInput, signature);
            LoggerManager.exceptionLogger.error("ECCCard cardPublicKeyVerifyByHash failure", e);
            throw new CryptoException(message, e);
        }
        return returnValue;
    }

    private boolean checkKeyPairSignOperation(KeyPair keyPair) throws CryptoException {
        boolean checkPassed = false;
        byte[] hashValue = DataHelper.decodeHexString("45f70cf58f607e6d891c93f594f1826ffb3a0dde");
        byte[] signValue = this.signByHash(keyPair.getPrivate(), hashValue);
        try {
            this.verifyByHashWithCard(keyPair, hashValue, signValue);
            this.verifyByHashWithSoft(keyPair, hashValue, signValue);
            checkPassed = true;
        }
        catch (Exception e) {
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                StringBuilder builder = new StringBuilder(2048);
                builder.append("\nECCCard checkKeyPairSignOperation: check keypair failure: ");
                ECCCardLoggings.buildKeyPairCheckFailed(builder, keyPair);
                builder.append("\nhashValue: ").append(DataHelper.dump4KPartData(hashValue));
                builder.append("\nsignValue: ").append(DataHelper.dump4KPartData(signValue));
                LoggerManager.exceptionLogger.error(builder.toString(), (Throwable)e);
            }
            throw new CryptoException("ECCCard checkKeyPairSignOperation: check keypair failure", e);
        }
        return checkPassed;
    }

    private void checkKeyPairDecryptOperation(KeyPair keyPair) throws CryptoException {
    }

    private boolean verifyByHashWithCard(KeyPair keyPair, byte[] hashData, byte[] signData) throws CryptoException {
        boolean verifyResult = this.verifyByHash(keyPair.getPublic(), hashData, signData);
        if (!verifyResult) {
            throw new CryptoException("verifyByHashWithCard return False");
        }
        return verifyResult;
    }

    private boolean verifyByHashWithSoft(KeyPair keyPair, byte[] hashData, byte[] signData) throws CryptoException {
        boolean verifyResult = ECCCardDummy.Dummy.INSTANCE.verifyByHash(keyPair.getPublic(), hashData, signData);
        if (!verifyResult) {
            throw new CryptoException("verifyByHashWithSoft return False");
        }
        return verifyResult;
    }
}

