/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.asn1.pkcs;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.MechanismKit;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.pkcs.CSRPublicKeyHelper;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.pkcs.CertificationRequest;
import cfca.sadk.org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import cfca.sadk.util.Base64;
import java.io.IOException;
import java.security.PublicKey;

abstract class CSREncoder {
    CSREncoder() {
    }

    static final byte[] buildCertificationRequestData(Mechanism mechanism, X500Name subject, ASN1Set attributes, PublicKey publicKey, byte[] signature) throws PKIException {
        CertificationRequest certRequest = CSREncoder.buildCertificationRequest(mechanism, subject, attributes, publicKey, signature);
        return CSREncoder.buildCertificationRequestData(certRequest);
    }

    static final byte[] buildCertificationRequestData(Mechanism mechanism, CertificationRequestInfo certRequestInfo, byte[] signature) throws PKIException {
        CertificationRequest certRequest = CSREncoder.buildCertificationRequest(mechanism, certRequestInfo, signature);
        return CSREncoder.buildCertificationRequestData(certRequest);
    }

    static final byte[] buildCertificationRequestData(CertificationRequest certRequest) throws PKIException {
        byte[] encoding;
        if (certRequest == null) {
            throw new PKIException("buildCertificationRequestData  failed: certRequest==null");
        }
        PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(certRequest);
        try {
            encoding = p10.getEncoded();
        }
        catch (IOException e) {
            throw new PKIException("buildCertificationRequestData encoding asn1 failure", e);
        }
        byte[] base64P10Bytes = null;
        try {
            base64P10Bytes = Base64.encode(encoding);
        }
        catch (Exception e) {
            throw new PKIException("buildCertificationRequestData encoding base64 failure", e);
        }
        return base64P10Bytes;
    }

    static final CertificationRequest buildCertificationRequest(Mechanism mechanism, X500Name subject, ASN1Set attributes, PublicKey publicKey, byte[] signature) throws PKIException {
        CertificationRequestInfo certRequestInfo = CSREncoder.buildCertificationRequestInfo(subject, attributes, publicKey);
        return CSREncoder.buildCertificationRequest(mechanism, certRequestInfo, signature);
    }

    static final CertificationRequest buildCertificationRequest(Mechanism mechanism, CertificationRequestInfo certRequestInfo, byte[] signature) throws PKIException {
        if (mechanism == null) {
            throw new PKIException("buildCertificationRequest  failed: mechanism==null");
        }
        if (certRequestInfo == null) {
            throw new PKIException("buildCertificationRequest  failed: certRequestInfo==null");
        }
        if (signature == null) {
            throw new PKIException("buildCertificationRequest  failed: signature==null");
        }
        ASN1ObjectIdentifier algorithm = MechanismKit.ALGOIDMap.get(mechanism.getMechanismType());
        if (algorithm == null) {
            throw new PKIException("buildCertificationRequest  failed: mechanism inalid->" + mechanism.getMechanismType());
        }
        AlgorithmIdentifier signAlgID = new AlgorithmIdentifier(algorithm, DERNull.INSTANCE);
        return new CertificationRequest(certRequestInfo, signAlgID, new DERBitString(signature));
    }

    static final byte[] buildCertificationRequestInfoData(CertificationRequestInfo certRequestInfo) throws PKIException {
        if (certRequestInfo == null) {
            throw new PKIException("buildCertificationRequestInfoData  failed: certRequestInfo==null");
        }
        byte[] asn1P10Bytes = null;
        try {
            asn1P10Bytes = certRequestInfo.getEncoded("DER");
        }
        catch (Exception e) {
            throw new PKIException("buildCertificationRequestInfoData encoding asn1 failure", e);
        }
        return asn1P10Bytes;
    }

    static final CertificationRequestInfo buildCertificationRequestInfo(X500Name subject, ASN1Set attributes, PublicKey publicKey) throws PKIException {
        SubjectPublicKeyInfo pubInfo;
        if (subject == null) {
            throw new PKIException("buildCertificationRequestInfo  failed: subject==null");
        }
        if (publicKey == null) {
            throw new PKIException("buildCertificationRequestInfo  failed: publicKey==null");
        }
        try {
            pubInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
        }
        catch (Exception e) {
            throw new PKIException("buildCertificationRequestInfo  failed when convert publicKey to SubjectPublicKeyInfo", e);
        }
        return new CertificationRequestInfo(subject, pubInfo, attributes);
    }

    static final CertificationRequestInfo buildCertificationRequestInfo(X500Name subject, PublicKey publicKey, PublicKey tempPublicKey, String challengePassword, String keyType) throws PKIException {
        if (subject == null) {
            throw new PKIException("buildCertificationRequestInfo parameter invalid: subject=null");
        }
        if (publicKey == null) {
            throw new PKIException("buildCertificationRequestInfo parameter invalid: publicKey=null");
        }
        SubjectPublicKeyInfo publicKeyInfo = CSRPublicKeyHelper.buildSubjectPublicKeyInfoFrom(publicKey);
        DERSet attributes = null;
        if (tempPublicKey != null) {
            attributes = CSRPublicKeyHelper.buildTemporaryPublicKeyP10Attributes(tempPublicKey, challengePassword, keyType);
        }
        return new CertificationRequestInfo(subject, publicKeyInfo, (ASN1Set)attributes);
    }

    static final AlgorithmIdentifier buildCertificationRequestSignatureAlgorithm(Mechanism mechanism) throws PKIException {
        if (mechanism == null) {
            throw new PKIException("buildCertificationRequestSignatureAlgorithm parameter invalid: mechanism=null");
        }
        String signAlgName = mechanism.getMechanismType();
        ASN1ObjectIdentifier signatureAlgorithmOID = MechanismKit.ALGOIDMap.get(signAlgName);
        if (signatureAlgorithmOID == null) {
            throw new PKIException("buildCertificationRequestSignatureAlgorithm parameter invalid: mechanism not support->" + mechanism.getMechanismType());
        }
        return new AlgorithmIdentifier(signatureAlgorithmOID, DERNull.INSTANCE);
    }
}

