/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.sm2;

import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.sm2.TLV;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Enumeration;

public final class ASN1SM2Cipher
extends ASN1Object {
    private ASN1Integer xCoordinate;
    private ASN1Integer yCoordinate;
    private ASN1OctetString hashValue;
    private ASN1OctetString cipherText;

    public static ASN1SM2Cipher getInstance(Object o) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException("ASN1SM2Cipher missing object for getInstance");
        }
        ASN1SM2Cipher data = o instanceof ASN1SM2Cipher ? (ASN1SM2Cipher)o : new ASN1SM2Cipher(ASN1Sequence.getInstance(o));
        return data;
    }

    public ASN1SM2Cipher(ASN1Integer tempPubX, ASN1Integer tempPubY, ASN1OctetString hashValue, ASN1OctetString cipherText) {
        if (tempPubX == null) {
            throw new IllegalArgumentException("ASN1SM2Cipher missing X:tempPubX");
        }
        if (tempPubY == null) {
            throw new IllegalArgumentException("ASN1SM2Cipher missing Y:tempPubY");
        }
        if (hashValue == null) {
            throw new IllegalArgumentException("ASN1SM2Cipher missing H:hashValue");
        }
        if (cipherText == null) {
            throw new IllegalArgumentException("ASN1SM2Cipher missing C:cipherText");
        }
        this.xCoordinate = BigIntegers.formatXYRS(tempPubX);
        this.yCoordinate = BigIntegers.formatXYRS(tempPubY);
        this.hashValue = hashValue;
        this.cipherText = cipherText;
    }

    public ASN1SM2Cipher(BigInteger x, BigInteger y, byte[] hashValue, byte[] cipherText) {
        if (x == null) {
            throw new IllegalArgumentException("ASN1SM2Cipher missing X:tempPubX");
        }
        if (y == null) {
            throw new IllegalArgumentException("ASN1SM2Cipher missing Y:tempPubY");
        }
        if (hashValue == null) {
            throw new IllegalArgumentException("ASN1SM2Cipher missing H:hashValue");
        }
        if (cipherText == null) {
            throw new IllegalArgumentException("ASN1SM2Cipher missing C:cipherText");
        }
        this.xCoordinate = BigIntegers.formatXYRS(new ASN1Integer(x));
        this.yCoordinate = BigIntegers.formatXYRS(new ASN1Integer(y));
        this.hashValue = new DEROctetString(hashValue);
        this.cipherText = new DEROctetString(cipherText);
    }

    public ASN1SM2Cipher(byte[] encryptedBytes, int encryptedType) throws SecurityException {
        if (encryptedBytes == null) {
            throw new SecurityException("ASN1SM2Cipher encryptedBytes missing");
        }
        if (encryptedBytes.length < 88) {
            throw new SecurityException("ASN1SM2Cipher encryptedBytes required length>=90");
        }
        if (encryptedType == 1) {
            this.deocded(encryptedBytes);
            return;
        }
        int offset = 0;
        switch (encryptedType) {
            case 2: {
                ++offset;
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                ++offset;
                break;
            }
            case 16: {
                break;
            }
            default: {
                throw new SecurityException("ASN1SM2Cipher Unknown SM2EncryptedType =" + encryptedType);
            }
        }
        if (offset != 0) {
            if (encryptedBytes[0] != 4) {
                throw new SecurityException("ASN1SM2Cipher Unknown encryptedBytes[0]");
            }
            if (encryptedBytes.length < 97) {
                throw new SecurityException("ASN1SM2Cipher Unknown encryptedBytes[Length]");
            }
        }
        byte[] Xbyte = new byte[32];
        byte[] Ybyte = new byte[32];
        byte[] C3byte = new byte[32];
        byte[] C2byte = new byte[encryptedBytes.length - 96 - offset];
        System.arraycopy(encryptedBytes, offset, Xbyte, 0, Xbyte.length);
        System.arraycopy(encryptedBytes, offset += Xbyte.length, Ybyte, 0, Ybyte.length);
        offset += Ybyte.length;
        if (encryptedType == 2 || encryptedType == 4) {
            System.arraycopy(encryptedBytes, offset, C3byte, 0, C3byte.length);
            System.arraycopy(encryptedBytes, offset += C3byte.length, C2byte, 0, C2byte.length);
            offset += C2byte.length;
        } else {
            System.arraycopy(encryptedBytes, offset, C2byte, 0, C2byte.length);
            System.arraycopy(encryptedBytes, offset += C2byte.length, C3byte, 0, C3byte.length);
            offset += C3byte.length;
        }
        this.xCoordinate = BigIntegers.formatXYRS(new ASN1Integer(new BigInteger(1, Xbyte)));
        this.yCoordinate = BigIntegers.formatXYRS(new ASN1Integer(new BigInteger(1, Ybyte)));
        this.hashValue = new DEROctetString(C3byte);
        this.cipherText = new DEROctetString(C2byte);
    }

    private ASN1SM2Cipher(ASN1Sequence seq) throws IllegalArgumentException {
        this.deocded(seq);
    }

    private final void deocded(ASN1Sequence seq) throws IllegalArgumentException {
        if (seq == null) {
            throw new IllegalArgumentException("ASN1SM2Cipher: sequence argument missing");
        }
        if (seq.size() != 4) {
            throw new IllegalArgumentException("ASN1SM2Cipher: sequence wrong size for object [X,Y,H,C]");
        }
        Enumeration e = seq.getObjects();
        this.xCoordinate = BigIntegers.formatXYRS(ASN1Integer.getInstance(e.nextElement()));
        this.yCoordinate = BigIntegers.formatXYRS(ASN1Integer.getInstance(e.nextElement()));
        this.hashValue = DEROctetString.getInstance(e.nextElement());
        this.cipherText = DEROctetString.getInstance(e.nextElement());
    }

    private final void deocded(byte[] encoded) throws IllegalArgumentException {
        if (encoded == null) {
            throw new IllegalArgumentException("ASN1SM2Cipher: encoded argument missing");
        }
        if (encoded.length < 76) {
            throw new IllegalArgumentException("ASN1SM2Cipher: encoded required more than 76");
        }
        ASN1Sequence seq = null;
        ASN1InputStream asn1Is = null;
        try {
            asn1Is = new ASN1InputStream(encoded);
            seq = (ASN1Sequence)asn1Is.readObject();
        }
        catch (Exception e) {
            throw new SecurityException("ASN1SM2Cipher: Unknown encryptedBytes: " + e.getMessage());
        }
        finally {
            if (asn1Is != null) {
                try {
                    asn1Is.close();
                }
                catch (Exception e) {}
            }
        }
        this.deocded(seq);
    }

    public ASN1Integer getXCoordinate() {
        return this.xCoordinate;
    }

    public ASN1Integer getYCoordinate() {
        return this.yCoordinate;
    }

    public ASN1OctetString getHashValue() {
        return this.hashValue;
    }

    public ASN1OctetString getCipherText() {
        return this.cipherText;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.xCoordinate.formatToPositive(32));
        v.add(this.yCoordinate.formatToPositive(32));
        v.add(this.hashValue);
        v.add(this.cipherText);
        return new DERSequence(v);
    }

    public byte[] getEncryptedBytes(int encryptedType) throws SecurityException {
        if (this.xCoordinate == null) {
            throw new SecurityException("ASN1SM2Cipher getEncryptedBytes xCoordinate missing");
        }
        if (this.yCoordinate == null) {
            throw new SecurityException("ASN1SM2Cipher getEncryptedBytes yCoordinate missing");
        }
        if (this.cipherText == null) {
            throw new SecurityException("ASN1SM2Cipher getEncryptedBytes cipherText missing");
        }
        if (this.hashValue == null) {
            throw new SecurityException("ASN1SM2Cipher getEncryptedBytes hashValue missing");
        }
        switch (encryptedType) {
            case 0: {
                encryptedType = 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
            default: {
                throw new SecurityException("ASN1SM2Cipher Unknown SM2EncryptedType =" + encryptedType);
            }
        }
        byte[] resultBytes = null;
        try {
            byte[] Xbytes = BigIntegers.asUnsignedByteArray(32, this.xCoordinate.getValue());
            byte[] Ybytes = BigIntegers.asUnsignedByteArray(32, this.yCoordinate.getValue());
            byte[] C2Bytes = this.cipherText.getOctets();
            byte[] C3Bytes = this.hashValue.getOctets();
            if (encryptedType == 1) {
                resultBytes = this.getEncoded();
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (encryptedType == 2 || encryptedType == 8) {
                    baos.write(4);
                }
                baos.write(Xbytes);
                baos.write(Ybytes);
                if (encryptedType == 2 || encryptedType == 4) {
                    baos.write(C3Bytes);
                    baos.write(C2Bytes);
                } else {
                    baos.write(C2Bytes);
                    baos.write(C3Bytes);
                }
                Xbytes = null;
                Ybytes = null;
                C2Bytes = null;
                C3Bytes = null;
                resultBytes = baos.toByteArray();
            }
        }
        catch (Exception e) {
            throw new SecurityException("ASN1SM2Cipher getEncryptedBytes Failure: " + e.getMessage());
        }
        if (resultBytes == null) {
            throw new SecurityException("ASN1SM2Cipher getEncryptedBytes Failure: unknown SM2EncryptedType =" + encryptedType);
        }
        return resultBytes;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("SM2Cipher [xCoordinate=");
        builder.append(this.xCoordinate);
        builder.append(", yCoordinate=");
        builder.append(this.yCoordinate);
        builder.append(", hashValue=");
        builder.append(this.hashValue);
        builder.append(", cipherText=");
        builder.append(this.cipherText);
        builder.append("]");
        return builder.toString();
    }

    public static final boolean isASN1EncryptType(byte[] encryptData) {
        if (encryptData == null) {
            return false;
        }
        if (encryptData.length < 88) {
            return false;
        }
        int offset = 0;
        TLV tlv = new TLV(encryptData, offset);
        if (tlv.failure || tlv.type != 48 || tlv.vLength < 86) {
            return false;
        }
        int maxLength = (offset += tlv.hLength) + tlv.vLength;
        if (encryptData.length != maxLength) {
            return false;
        }
        int num = 0;
        while (offset < maxLength) {
            tlv = new TLV(encryptData, offset);
            if (tlv.failure) {
                return false;
            }
            if (num < 2 && (tlv.type != 2 || tlv.vLength < 26)) {
                return false;
            }
            if (num == 2 && (tlv.type != 4 || tlv.vLength != 32)) {
                return false;
            }
            if (num == 3 && tlv.type != 4) {
                return false;
            }
            offset += tlv.hLength;
            offset += tlv.vLength;
            if (++num != 4) continue;
        }
        return num == 4 && offset == maxLength;
    }

    public static interface SM2EncryptedType {
        public static final int DEFAULT_C1_C3_C2_WITH_ASN1 = 0;
        public static final int C1_C3_C2_WITH_ASN1 = 1;
        public static final int C1_C3_C2_WITH_0x04 = 2;
        public static final int C1_C3_C2_WITHOUT_0x04 = 4;
        public static final int C1_C2_C3_WITH_0x04 = 8;
        public static final int C1_C2_C3_WITHOUT_0x04 = 16;
    }
}

