/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.util;

import cpcn.dsp.institution.api.util.Base64Encoder;
import cpcn.dsp.institution.api.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Base64 {
    private static final Base64Encoder ENCODER = new Base64Encoder();

    private Base64() {
        throw new IllegalStateException("Utility class");
    }

    public static byte[] encode(byte[] data) {
        int len = (data.length + 2) / 3 * 4;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(len);
        try {
            ENCODER.encode(data, 0, data.length, outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("exception encoding base64 string: " + e);
        }
        return outputStream.toByteArray();
    }

    public static int encode(byte[] data, OutputStream out) throws IOException {
        return ENCODER.encode(data, 0, data.length, out);
    }

    public static String encode(String data, String charSet) throws UnsupportedEncodingException {
        if (StringUtil.isEmpty(data)) {
            return "";
        }
        return new String(Base64.encode(data.getBytes(charSet)), charSet);
    }

    public static int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        return ENCODER.encode(data, off, length, out);
    }

    public static byte[] decode(byte[] data) {
        int len = data.length / 4 * 3;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
        try {
            ENCODER.decode(data, 0, data.length, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("exception decoding base64 string: " + e);
        }
        return bOut.toByteArray();
    }

    public static byte[] decode(String data) {
        int len = data.length() / 4 * 3;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
        try {
            ENCODER.decode(data, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("exception decoding base64 string: " + e);
        }
        return bOut.toByteArray();
    }

    public static int decode(String data, OutputStream out) throws IOException {
        return ENCODER.decode(data, out);
    }

    public static String decode(String data, String charSet) throws UnsupportedEncodingException {
        if (StringUtil.isEmpty(data)) {
            return "";
        }
        return new String(Base64.decode(data.getBytes(charSet)), charSet);
    }

    public static boolean matchBase64(String plaintext) {
        String regex = "[A-Za-z0-9,/,=,+]+";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(plaintext);
        return m.matches();
    }
}

