/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import cpcn.dsp.institution.api.security.Signer;
import cpcn.dsp.institution.api.security.Verifier;
import java.util.HashMap;

public final class SignatureFactory {
    private static HashMap<String, Signer> signerMap = new HashMap();
    private static HashMap<String, Verifier> verifierMap = new HashMap();
    private static String defaultSigner;
    private static String defaultVerifier;

    private SignatureFactory() {
    }

    public static synchronized void addSigner(String signerID, Signer signer) {
        signerMap.put(signerID, signer);
        defaultSigner = signerID;
    }

    public static synchronized void addVerifier(String verifierID, Verifier verifier) {
        verifierMap.put(verifierID, verifier);
        defaultVerifier = verifierID;
    }

    public static Signer getSigner() {
        return signerMap.get(defaultSigner);
    }

    public static Signer getSigner(String signerID) {
        return signerMap.get(signerID);
    }

    public static Verifier getVerifier() {
        return verifierMap.get(defaultVerifier);
    }

    public static Verifier getVerifier(String verifierID) {
        return verifierMap.get(verifierID);
    }

    public static void clearVerifier() {
        verifierMap.clear();
    }
}

