/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.bean;

import cfca.sadk.timestamp.client.bean.PKIFailureInfo;
import cfca.sadk.timestamp.client.bean.PKIFreeText;
import cfca.sadk.timestamp.client.bean.PKIStatus;

public final class PKIStatusInfo {
    public final PKIStatus status;
    public final PKIFreeText freeText;
    public final int failInfo;

    public PKIStatusInfo() {
        this.status = PKIStatus.granted;
        this.freeText = null;
        this.failInfo = 0;
    }

    public PKIStatusInfo(int status, String[] freeText, int failInfo) {
        this.status = PKIStatus.find(status);
        this.freeText = freeText == null ? null : new PKIFreeText(freeText);
        this.failInfo = failInfo;
    }

    public PKIStatusInfo(PKIStatus status, PKIFreeText freeText, int failInfo) {
        this.status = status;
        this.freeText = freeText;
        this.failInfo = failInfo;
    }

    public PKIStatus getStatus() {
        return this.status;
    }

    public PKIFreeText getFreeText() {
        return this.freeText;
    }

    public int getFailInfo() {
        return this.failInfo;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PKIStatusInfo [");
        builder.append("\n\t freeText=");
        builder.append((Object)this.status);
        builder.append("\n\t freeText=");
        if (this.freeText != null && this.freeText.getFreeTexts() != null) {
            String[] freeTexts;
            for (String string : freeTexts = this.freeText.getFreeTexts()) {
                for (int i = 0; i < freeTexts.length; ++i) {
                    builder.append("\n\t\t ").append(string);
                }
            }
        }
        builder.append("\n\t failInfo=");
        if (this.failInfo != 0) {
            PKIFailureInfo[] values;
            for (PKIFailureInfo pKIFailureInfo : values = PKIFailureInfo.values()) {
                if ((pKIFailureInfo.value & this.failInfo) != pKIFailureInfo.value) continue;
                builder.append("\n\t\t ").append((Object)pKIFailureInfo);
            }
        }
        builder.append(this.failInfo);
        builder.append("]");
        return builder.toString();
    }
}

