/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.bean;

import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.timestamp.client.bean.MessageImprint;
import cfca.sadk.timestamp.client.bean.TSTAccuracy;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class TSTInfo {
    private int version;
    private String policyId;
    private MessageImprint messageImprint;
    private BigInteger serialNumber;
    private String genTimeText;
    private Date genTime;
    private TSTAccuracy accuracy;
    private boolean ordering = false;
    private BigInteger nonce;
    private String tsaName;
    private byte[] extensions;

    public TSTInfo(int version, String policyId, MessageImprint messageImprint, BigInteger serialNumber, Date genTime, TSTAccuracy accuracy, boolean ordering, BigInteger nonce, String tsaName, byte[] extensions) throws TSAException {
        String genTimeText;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            genTimeText = dateFormat.format(genTime);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timeStampTokenInfoGenTimeFormatFailure, "genTime format failure", (Throwable)e);
        }
        this.genTimeText = genTimeText;
        this.version = version;
        this.policyId = policyId;
        this.messageImprint = messageImprint;
        this.serialNumber = serialNumber;
        this.genTime = genTime;
        this.accuracy = accuracy;
        this.ordering = ordering;
        this.nonce = nonce;
        this.tsaName = tsaName;
        this.extensions = extensions;
    }

    public final int getVersion() {
        return this.version;
    }

    public final String getPolicyId() {
        return this.policyId;
    }

    public final MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public final BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public final String getTimestampText() {
        return this.genTimeText;
    }

    public final Date getTimestampTime() {
        return this.genTime;
    }

    public final TSTAccuracy getAccuracy() {
        return this.accuracy;
    }

    public final boolean isOrdering() {
        return this.ordering;
    }

    public final BigInteger getNonce() {
        return this.nonce;
    }

    public final String getTsaName() {
        return this.tsaName;
    }

    public final byte[] getExtensions() {
        return this.extensions == null ? null : (byte[])this.extensions.clone();
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n\t TSTInfo [");
        builder.append("\n\t\t version=");
        builder.append(this.version);
        builder.append("\n\t\t policyId=");
        builder.append(this.policyId);
        builder.append("\n\t\t messageImprint=");
        builder.append(this.messageImprint);
        builder.append("\n\t\t serialNumber=");
        builder.append(this.serialNumber);
        builder.append("\n\t\t genTimeText=");
        builder.append(this.genTimeText);
        builder.append("\n\t\t genTime=");
        builder.append(this.genTime);
        builder.append("\n\t\t accuracy=");
        builder.append(this.accuracy);
        builder.append("\n\t\t ordering=");
        builder.append(this.ordering);
        builder.append("\n\t\t nonce=");
        builder.append(this.nonce);
        builder.append("\n\t\t tsaName=");
        builder.append(this.tsaName);
        builder.append("\n\t\t extensions=");
        if (this.extensions != null) {
            builder.append("0x");
            builder.append(Hex.toHexString((byte[])this.extensions));
        }
        builder.append("]");
        return builder.toString();
    }
}

