/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.timestamp.client.BusinessTrustCerts;
import cfca.sadk.timestamp.client.TSASignedData;
import cfca.sadk.timestamp.client.api.Timestamp;
import cfca.sadk.timestamp.client.api.TimestampConfig;
import cfca.sadk.timestamp.client.api.TimestampHelper;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;

final class StandardTimestampHelper
implements TimestampHelper {
    static final Logger logger = LoggerFactory.getLogger(StandardTimestampHelper.class);
    private final BusinessTrustCerts trustCerts;
    private X509Cert signCert = null;
    private Session session;

    public StandardTimestampHelper(TimestampConfig config) throws TSAException {
        logger.info("StandardTimestampHelper instance running...");
        if (config == null) {
            logger.error("StandardTimestampHelper missing parameter@timestampConfig");
            throw new TSAException(TSAErrorCode.timestampHelperMissingTimestampConfig, "required parameter timestampConfig");
        }
        if (logger.isInfoEnabled()) {
            logger.info(config.toString(true));
        }
        try {
            this.trustCerts = new BusinessTrustCerts(config.getBusinessTrustCertPath(), config.getBusinessTrustCRLPath());
        }
        catch (TSAException e) {
            logger.error("StandardTimestampHelper@BusinessTrustCerts failure: {}", (Object)config, (Object)e);
            throw e;
        }
        this.session = BCSoftLib.INSTANCE();
        logger.info("StandardTimestampHelper instance finished");
    }

    @Override
    public void setSession(Session session) {
        this.session = session == null ? BCSoftLib.INSTANCE() : session;
    }

    @Override
    public BusinessTrustCerts currentBusinessTrustCerts() throws TSAException {
        return this.trustCerts;
    }

    @Override
    public void setSignCert(X509Cert signCert) {
        this.signCert = signCert;
    }

    @Override
    public boolean verifyTimestamp(byte[] responseData) throws TSAException {
        boolean verifiedResult;
        TSASignedData signedData;
        try {
            signedData = new TSASignedData(null, responseData, false, this.signCert);
        }
        catch (TSAException e) {
            logger.error("StandardTimestampHelper@decodeTimestamp invalid response: 0x{}", (Object)Base64.toBase64String((byte[])responseData), (Object)e);
            throw e;
        }
        try {
            verifiedResult = signedData.verifySignedData(this.trustCerts, this.session);
        }
        catch (TSAException e) {
            logger.error("StandardTimestampHelper@verifyTimestamp check signedData/signedCert failure", (Throwable)e);
            throw e;
        }
        return verifiedResult;
    }

    @Override
    public Timestamp getTimestamp(byte[] responseData) throws TSAException {
        TSASignedData signedData;
        try {
            signedData = new TSASignedData(null, responseData, false, this.signCert);
        }
        catch (TSAException e) {
            logger.error("StandardTimestampHelper@decodeTimestamp invalid response: 0x{}", (Object)Base64.toBase64String((byte[])responseData), (Object)e);
            throw e;
        }
        Timestamp timestamp = signedData.getTimeStamp();
        return timestamp;
    }
}

