/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.net;

import cpcn.dsp.institution.api.io.IoUtil;
import cpcn.dsp.institution.api.net.HttpData;
import cpcn.dsp.institution.api.net.NameValuePair;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class HttpConnection {
    private String method = "POST";
    private int connectTimeoutLimit = 25000;
    private int readTimeoutLimit = 25000;
    private String outputCharset = "UTF-8";
    private String inputCharset = "UTF-8";
    private String contentType = "application/x-www-form-urlencoded";
    private HttpURLConnection httpURLConnection;

    public HttpConnection(String spec) throws IOException {
        URL url = new URL(spec);
        this.httpURLConnection = (HttpURLConnection)url.openConnection();
    }

    public String send(List<NameValuePair> list) throws IOException {
        HttpData httpData = new HttpData(list, this.outputCharset);
        String request = httpData.getData();
        return this.send(request);
    }

    public String send(String request) throws IOException {
        this.httpURLConnection.setRequestProperty("Content-Type", this.contentType);
        this.httpURLConnection.setDoOutput(true);
        this.httpURLConnection.setDoInput(true);
        this.httpURLConnection.setRequestMethod(this.method);
        this.httpURLConnection.setUseCaches(false);
        this.httpURLConnection.setConnectTimeout(this.connectTimeoutLimit);
        this.httpURLConnection.setReadTimeout(this.readTimeoutLimit);
        OutputStream outputStream = this.httpURLConnection.getOutputStream();
        outputStream.write(request.getBytes(this.outputCharset));
        outputStream.flush();
        outputStream.close();
        InputStream inputStream = this.httpURLConnection.getInputStream();
        byte[] bytes = IoUtil.read(inputStream, 1024);
        inputStream.close();
        return new String(bytes, this.inputCharset).trim();
    }

    public String sendWithAttachment(Map<String, String> params, Map<String, String> files) throws IOException {
        int MAX_BUFFER_SIZE = 16384;
        String BOUNDARY = UUID.randomUUID().toString();
        String PREFIX = "--";
        String LINEND = "\r\n";
        String MULTIPART_FROM_DATA = "multipart/form-data";
        String CHARSET = "UTF-8";
        this.httpURLConnection.setReadTimeout(this.readTimeoutLimit);
        this.httpURLConnection.setConnectTimeout(this.connectTimeoutLimit);
        this.httpURLConnection.setDoInput(true);
        this.httpURLConnection.setDoOutput(true);
        this.httpURLConnection.setUseCaches(false);
        this.httpURLConnection.setRequestMethod("POST");
        this.httpURLConnection.setRequestProperty("connection", "keep-alive");
        this.httpURLConnection.setRequestProperty("Charsert", this.inputCharset);
        this.httpURLConnection.setRequestProperty("Content-Type", MULTIPART_FROM_DATA + ";boundary=" + BOUNDARY);
        this.httpURLConnection.setChunkedStreamingMode(16384);
        this.httpURLConnection.setRequestProperty("Transfer-Encoding", "chunked");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(PREFIX);
            sb.append(BOUNDARY);
            sb.append(LINEND);
            sb.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"" + LINEND);
            sb.append("Content-Type: text/plain; charset=" + CHARSET + LINEND);
            sb.append("Content-Transfer-Encoding: 8bit" + LINEND);
            sb.append(LINEND);
            sb.append(entry.getValue());
            sb.append(LINEND);
        }
        DataOutputStream outStream = new DataOutputStream(this.httpURLConnection.getOutputStream());
        outStream.write(sb.toString().getBytes(this.inputCharset));
        if (files != null) {
            for (Map.Entry<String, String> entry : files.entrySet()) {
                StringBuilder sb1 = new StringBuilder();
                sb1.append(PREFIX);
                sb1.append(BOUNDARY);
                sb1.append(LINEND);
                sb1.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + entry.getKey() + "\"" + LINEND);
                sb1.append("Content-Type: application/octet-stream; charset=" + CHARSET + LINEND);
                sb1.append(LINEND);
                outStream.write(sb1.toString().getBytes(this.inputCharset));
                outStream.write(Base64.getDecoder().decode(entry.getValue().getBytes(this.inputCharset)));
                outStream.write(LINEND.getBytes(this.inputCharset));
            }
        }
        byte[] byArray = (PREFIX + BOUNDARY + PREFIX + LINEND).getBytes(this.inputCharset);
        outStream.write(byArray);
        outStream.flush();
        outStream.close();
        InputStream inputStream = this.httpURLConnection.getInputStream();
        byte[] bytes = IoUtil.read(inputStream, 1024);
        inputStream.close();
        return new String(bytes, this.inputCharset).trim();
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int getConnectTimeoutLimit() {
        return this.connectTimeoutLimit;
    }

    public void setConnectTimeoutLimit(int connectTimeoutLimit) {
        this.connectTimeoutLimit = connectTimeoutLimit;
    }

    public int getReadTimeoutLimit() {
        return this.readTimeoutLimit;
    }

    public void setReadTimeoutLimit(int readTimeoutLimit) {
        this.readTimeoutLimit = readTimeoutLimit;
    }

    public String getOutputCharset() {
        return this.outputCharset;
    }

    public void setOutputCharset(String outputCharset) {
        this.outputCharset = outputCharset;
    }

    public String getInputCharset() {
        return this.inputCharset;
    }

    public void setInputCharset(String inputCharset) {
        this.inputCharset = inputCharset;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

