/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.timestamp.client.PreferredCipherSuiteSSLSocketFactory;
import cfca.sadk.timestamp.client.SSLContextManager;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.timestamp.exception.TSAHttpStatusInfoException;
import cfca.sadk.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

final class HTTPRequester {
    private static final String TS_QUERY_MIME_TYPE = "application/timestamp-query";
    private static final String TS_REPLY_MIME_TYPE = "application/timestamp-reply";
    private static final int maxPacketLength = 8192;
    private static final int minPacketLength = 5;
    private final URL serverUrl;
    private final SSLContext sslContext;
    private String username;
    private String password;

    HTTPRequester(String serverUrl, SSLContext sslContext) throws TSAException {
        try {
            this.serverUrl = new URL(serverUrl);
        }
        catch (MalformedURLException e) {
            throw new TSAException(TSAErrorCode.serverUrlInvalidMalformedURL, "invalid serverUrl other than start with http or https: " + serverUrl, (Throwable)e);
        }
        String protocol = this.serverUrl.getProtocol();
        if (!protocol.startsWith("http")) {
            throw new TSAException(TSAErrorCode.serverUrlNotSupportProtocol, "do not support other than http or https: " + serverUrl);
        }
        if ("https".equals(protocol) && sslContext == null) {
            throw new TSAException(TSAErrorCode.serverUrlHTTPSRequireSSLContext, "SSLContext missing: " + serverUrl);
        }
        this.sslContext = sslContext;
    }

    static final HTTPRequester getHttpInstance(String serverUrl) throws TSAException {
        return new HTTPRequester(serverUrl, null);
    }

    static final HTTPRequester getHttpsInstance(String serverUrl, SSLContext sslContext) throws TSAException {
        return new HTTPRequester(serverUrl, sslContext);
    }

    final byte[] sendRequest(byte[] timestampRequestBytes, int timeout, boolean hostnameChecker) throws TSAHttpStatusInfoException, TSAException {
        int thisTimeout = timeout < 500 ? 500 : timeout;
        HttpURLConnection connection = null;
        byte[] response = null;
        try {
            connection = (HttpURLConnection)this.serverUrl.openConnection();
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Content-type", TS_QUERY_MIME_TYPE);
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(thisTimeout);
            connection.setReadTimeout(thisTimeout);
            this.addBasicAuthToHTTPHeader(connection, this.username, this.password);
            this.setHttpsURLConnection(connection, this.serverUrl, hostnameChecker);
            this.sendMessage(connection, timestampRequestBytes);
            int resCode = connection.getResponseCode();
            if (resCode != 200) {
                throw new TSAHttpStatusInfoException(resCode);
            }
            response = this.recvMessage(connection);
        }
        catch (ProtocolException e) {
            throw new TSAException(TSAErrorCode.serverUrlSendHTTPRequestFailure, "throws ProtocolException: " + this.serverUrl, (Throwable)e);
        }
        catch (IOException e) {
            throw new TSAException(TSAErrorCode.serverUrlSendHTTPRequestFailure, "throws IOException: " + this.serverUrl, (Throwable)e);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.serverUrlSendHTTPRequestFailure, "throws Exception: " + this.serverUrl, (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (response == null || response.length < 5) {
            throw new TSAException(TSAErrorCode.serverUrlRecvShortagePacket, "serverUrl: " + this.serverUrl);
        }
        return response;
    }

    private final void addBasicAuthToHTTPHeader(HttpURLConnection connection, String username, String password) throws TSAException {
        if (!SSLContextManager.isEmpty(username) && !SSLContextManager.isEmpty(password)) {
            try {
                String userInfo = username + ":" + password;
                String headerValue = "Basic " + Base64.toBase64String((byte[])userInfo.getBytes("UTF-8"));
                connection.setRequestProperty("Authorization", headerValue);
            }
            catch (UnsupportedEncodingException e) {
                throw new TSAException(TSAErrorCode.serverUrlHTTPAddBasicAuthFailure, (Throwable)e);
            }
        }
    }

    private final void setHttpsURLConnection(HttpURLConnection connection, URL serverUrl, boolean hostnameChecker) throws TSAException {
        if ("https".equals(serverUrl.getProtocol())) {
            if (this.sslContext == null) {
                throw new TSAException(TSAErrorCode.serverUrlHTTPSRequireSSLContext, "SSLContext missing: " + serverUrl);
            }
            if (!hostnameChecker) {
                ((HttpsURLConnection)connection).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            boolean isGMSSL = "GMTLSv1.1".equalsIgnoreCase(this.sslContext.getProtocol());
            SSLSocketFactory sslSocketFactory = this.sslContext.getSocketFactory();
            if (isGMSSL) {
                sslSocketFactory = new PreferredCipherSuiteSSLSocketFactory(sslSocketFactory);
            }
            ((HttpsURLConnection)connection).setSSLSocketFactory(sslSocketFactory);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private final void sendMessage(HttpURLConnection connection, byte[] timestampRequestBytes) throws TSAException {
        if (timestampRequestBytes == null || timestampRequestBytes.length < 5) {
            throw new TSAException(TSAErrorCode.serverUrlSendShortagePacket, "serverUrl: " + this.serverUrl);
        }
        OutputStream out = null;
        try {
            out = connection.getOutputStream();
            out.write(timestampRequestBytes);
            out.flush();
        }
        catch (IOException e) {
            throw new TSAException(TSAErrorCode.serverUrlSendHTTPFailure, "write stream failure: " + this.serverUrl, (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new TSAException(TSAErrorCode.serverUrlSendHTTPFailure, "close stream failure: " + this.serverUrl, (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] recvMessage(HttpURLConnection connection) throws TSAException {
        InputStream in = null;
        try {
            byte[] tsaBytes;
            String contentType = connection.getContentType();
            if (!TS_REPLY_MIME_TYPE.equalsIgnoreCase(contentType)) {
                throw new TSAException(TSAErrorCode.serverUrlRecvInvalidPacket, "MIME Content-Type is not application/timestamp-reply");
            }
            int contentLength = connection.getContentLength();
            if (contentLength < 0) {
                throw new TSAException(TSAErrorCode.serverUrlRecvInvalidPacket, "MIME Content-Length is less than 0");
            }
            if (contentLength == 0) {
                tsaBytes = new byte[]{};
                return tsaBytes;
            }
            if (contentLength > 8192) {
                throw new TSAException(TSAErrorCode.serverUrlRecvInvalidPacket, "MIME Content-Length is more than 8192");
            }
            tsaBytes = new byte[contentLength];
            in = connection.getInputStream();
            int recvLength = 0;
            int length = 0;
            while ((length = in.read(tsaBytes, recvLength, contentLength - recvLength)) > 0 && (recvLength += length) < contentLength) {
            }
            if (recvLength == contentLength) return tsaBytes;
            throw new TSAException(TSAErrorCode.serverUrlRecvInvalidPacket, "MIME Content-Stream length not equals with contentLength=" + contentLength);
        }
        catch (TSAException e) {
            throw e;
        }
        catch (IOException e) {
            throw new TSAException(TSAErrorCode.serverUrlRecvHTTPFailure, "read stream failure: " + this.serverUrl, (Throwable)e);
        }
        finally {
            try {
                if (in == null) {
                    // empty if block
                }
            }
            catch (Exception e) {
                throw new TSAException(TSAErrorCode.serverUrlRecvHTTPFailure, "write stream failure: " + this.serverUrl, (Throwable)e);
            }
        }
    }
}

