/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.util;

import cpcn.dsp.institution.api.util.StringUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class TimeUtil {
    private static Logger logger = Logger.getLogger((String)"system");
    public static final String PATTERN_DATE8 = "yyyyMMdd";
    public static final String PATTERN_DATE8_2 = "yyyy-MM-dd";
    public static final String PATTERN_TIME6 = "HHmmss";
    public static final String PATTERN_TIME14 = "yyyyMMddHHmmss";
    public static final String PATTERN_TIME14_2 = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_TIME17 = "yyyyMMddHHmmssSSS";

    protected TimeUtil() {
    }

    public static String getFormattedDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATE8_2);
        return sdf.format(date);
    }

    public static String getFormattedDate(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static String getFormattedTime(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_TIME14_2);
        return sdf.format(date);
    }

    public static String getFormattedTime2(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_TIME14);
        return sdf.format(date);
    }

    public static String getTimeStamp() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_TIME14);
        return sdf.format(date);
    }

    public static String getDateStamp() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATE8);
        return sdf.format(date);
    }

    public static String getDateStamp(int time) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 0 - time);
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATE8);
        return sdf.format(date);
    }

    public static String getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATE8_2);
        return sdf.format(date);
    }

    public static String getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_TIME14_2);
        return sdf.format(date);
    }

    public static String getMonthStamp() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        return sdf.format(date);
    }

    public static int getDays(int year, int month) {
        int days = 30;
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                days = 31;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                days = 30;
                break;
            }
            case 2: {
                days = TimeUtil.getFebruaryDays(year);
                break;
            }
        }
        return days;
    }

    private static int getFebruaryDays(int year) {
        int days = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 29 : 28;
        return days;
    }

    public static boolean isValidDate(String dateString, String dateFormatPattern) {
        if (StringUtil.isEmpty(dateString) || StringUtil.isEmpty(dateFormatPattern)) {
            return false;
        }
        if (dateString.length() != dateFormatPattern.length()) {
            return false;
        }
        Date validDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormatPattern);
            sdf.setLenient(false);
            validDate = sdf.parse(dateString);
        }
        catch (ParseException e) {
            return validDate != null;
        }
        return validDate != null;
    }

    public static Date string2Date(String date, String format) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        try {
            return simpleDateFormat.parse(date);
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static String date2String(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Date getNowTime() {
        return Calendar.getInstance().getTime();
    }

    public static long getNowTimeInMillis() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public static String getTimeMillisecondStamp() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_TIME17);
        return sdf.format(date);
    }

    public static String getTimeMillisecondStamp(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, days);
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_TIME14);
        return sdf.format(date);
    }

    public static String transformTime(String date, String sourceFormat, String destFormat) throws ParseException {
        SimpleDateFormat sdfSource = new SimpleDateFormat(sourceFormat);
        Date dateSource = sdfSource.parse(date);
        SimpleDateFormat sdfDest = new SimpleDateFormat(destFormat);
        return sdfDest.format(dateSource);
    }

    public static Timestamp stringToTimestamp(String datetime) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(PATTERN_TIME14);
        return new Timestamp(formatter.parse(datetime).getTime());
    }

    public static String addDays(int days) {
        String fromTime = "";
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, days);
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATE8);
        fromTime = sdf.format(date);
        return fromTime;
    }

    public static Date addDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static String addDays(String dateStr, int days) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATE8);
        sdf.setLenient(false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sdf.parse(dateStr));
        calendar.add(5, days);
        return sdf.format(calendar.getTime());
    }

    public static String addHours(String timeStr, int hours) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_TIME14);
        sdf.setLenient(false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sdf.parse(timeStr));
        calendar.add(10, hours);
        return sdf.format(calendar.getTime());
    }

    public static boolean isAfter(String time1, String time2, String pattern) throws ParseException {
        long tim2;
        Date date1 = TimeUtil.string2Date(time1, pattern);
        Date date2 = TimeUtil.string2Date(time2, pattern);
        long tim1 = date1.getTime();
        return tim1 > (tim2 = date2.getTime());
    }

    public static long nextHourDelay(int offset) {
        Calendar calendar = Calendar.getInstance();
        long currTime = calendar.getTimeInMillis();
        int hour = calendar.get(11);
        calendar.set(11, hour + offset);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long nextHourTime = calendar.getTimeInMillis();
        return nextHourTime - currTime;
    }
}

