/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.tx.ocr;

import com.alibaba.fastjson.JSONObject;
import cpcn.dsp.institution.api.system.DSPInstitutionEnvironment;
import cpcn.dsp.institution.api.tx.TxBaseResponse;
import cpcn.dsp.institution.api.util.ClientDecryptionUtil;

public class Tx4010Response
extends TxBaseResponse {
    private String institutionID;
    private String txSN;
    private String traceNo;
    private String responseCode;
    private String responseMessage;
    private String name;
    private String gender;
    private String birthday;
    private String identificationNumber;
    private String nationality;
    private String address;
    private String image;
    private String issueAuthority;
    private String validPeriod;

    public Tx4010Response(String responseMessage, String responseSignature) throws Exception {
        super(responseMessage, responseSignature);
    }

    public Tx4010Response(String responseMessage, String responseSignature, String responseDgtlEnvlp, String responseSignSN, String responseEncryptSN) throws Exception {
        super(responseMessage, responseSignature, responseDgtlEnvlp, responseSignSN, responseEncryptSN);
    }

    @Override
    protected void process(String document) throws Exception {
        if ("2000".equals(this.code)) {
            JSONObject json = JSONObject.parseObject((String)document);
            this.institutionID = json.getString("InstitutionID");
            this.txSN = json.getString("TxSN");
            this.traceNo = json.getString("TraceNo");
            this.responseCode = json.getString("ResponseCode");
            this.responseMessage = json.getString("ResponseMessage");
            this.name = json.getString("Name");
            this.gender = json.getString("Gender");
            this.birthday = json.getString("Birthday");
            if ("10".equals(DSPInstitutionEnvironment.msgEncryptType)) {
                this.identificationNumber = ClientDecryptionUtil.decrypt(json.getString("IdentificationNumber"));
            } else if ("20".equals(DSPInstitutionEnvironment.msgEncryptType) || "30".equals(DSPInstitutionEnvironment.msgEncryptType)) {
                this.identificationNumber = json.getString("IdentificationNumber");
            }
            this.nationality = json.getString("Nationality");
            this.address = json.getString("Address");
            this.image = json.getString("Image");
            this.issueAuthority = json.getString("IssueAuthority");
            this.validPeriod = json.getString("ValidPeriod");
        }
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getTxSN() {
        return this.txSN;
    }

    public String getTraceNo() {
        return this.traceNo;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getName() {
        return this.name;
    }

    public String getGender() {
        return this.gender;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public String getNationality() {
        return this.nationality;
    }

    public String getAddress() {
        return this.address;
    }

    public String getImage() {
        return this.image;
    }

    public String getIssueAuthority() {
        return this.issueAuthority;
    }

    public String getValidPeriod() {
        return this.validPeriod;
    }
}

