/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.core.rolling;

import cfca.ch.qos.logback.core.rolling.AsyncArchivingFixedWindowCompressor;
import cfca.ch.qos.logback.core.rolling.RollingPolicyBase;
import cfca.ch.qos.logback.core.rolling.RolloverFailure;
import cfca.ch.qos.logback.core.rolling.helper.CompressionMode;
import cfca.ch.qos.logback.core.rolling.helper.DateTokenConverter;
import cfca.ch.qos.logback.core.rolling.helper.FileFilterUtil;
import cfca.ch.qos.logback.core.rolling.helper.FileNamePattern;
import cfca.ch.qos.logback.core.rolling.helper.RenameUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AsyncArchivingFixedWindowRollingPolicy
extends RollingPolicyBase {
    private static final String FNP_NOT_SET = "The \"FileNamePattern\" property must be set before using AsyncArchivingFixedWindowRollingPolicy. ";
    private static final String PRUDENT_MODE_UNSUPPORTED = "See also http://logback.qos.ch/codes.html#tbr_fnp_prudent_unsupported";
    private static final String SEE_PARENT_FN_NOT_SET = "Please refer to http://logback.qos.ch/codes.html#fwrp_parentFileName_not_set";
    private final RenameUtil renameUtil = new RenameUtil();
    private AsyncArchivingFixedWindowCompressor compressor;
    private FileNamePattern fileNamePatternWithoutCompSuffix;
    private final Map<String, CompressingTask> nameAndFutureMap = new ConcurrentHashMap<String, CompressingTask>(MAX_WINDOW_SIZE);
    private static int MAX_WINDOW_SIZE = 2000;
    private static final int DEFAULT_WINDOW_SIZE = 20;
    private int maxHistory = 20;
    private final AtomicLong fileIndex = new AtomicLong(0L);
    private String fileNamePathPrefix;
    private String fileNamePathSuffix;
    private Pattern datePattern;

    @Override
    public void start() {
        DateTokenConverter<Object> itc;
        int maxWindowSize;
        this.renameUtil.setContext(this.context);
        if (this.fileNamePatternStr == null) {
            this.addError(FNP_NOT_SET);
            this.addError("See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
            throw new IllegalStateException("The \"FileNamePattern\" property must be set before using AsyncArchivingFixedWindowRollingPolicy. See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
        }
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr, this.context);
        this.determineCompressionMode();
        if (this.isParentPrudent()) {
            this.addError("Prudent mode is not supported with AsyncArchivingFixedWindowRollingPolicy.");
            this.addError(PRUDENT_MODE_UNSUPPORTED);
            throw new IllegalStateException("Prudent mode is not supported.");
        }
        if (this.getParentsRawFileProperty() == null) {
            this.addError("The File name property must be set before using this rolling policy.");
            this.addError(SEE_PARENT_FN_NOT_SET);
            throw new IllegalStateException("The \"File\" option must be set.");
        }
        if (this.maxHistory <= 0) {
            this.addWarn("MaxHistory (" + this.maxHistory + ") cannot be set to negative , setting 'maxHistory' with value [" + 20 + "] instead.");
            this.maxHistory = 20;
        }
        if (this.maxHistory > (maxWindowSize = this.getMaxWindowSize())) {
            this.addWarn("Large history sizes are not allowed.");
            this.maxHistory = maxWindowSize;
            this.addWarn("MaxHistory reduced to " + maxWindowSize);
        }
        if ((itc = this.fileNamePattern.getPrimaryDateTokenConverter()) == null) {
            throw new IllegalStateException("FileNamePattern [" + this.fileNamePattern.getPattern() + "] does not contain a valid DateToken");
        }
        if (this.compressionMode == CompressionMode.ZIP) {
            String zipEntryFileNamePatternStr = this.transformFileNamePatternWithDate();
            this.zipEntryFileNamePattern = new FileNamePattern(zipEntryFileNamePatternStr, this.context);
        }
        this.compressor = new AsyncArchivingFixedWindowCompressor(this.compressionMode);
        this.compressor.setContext(this.context);
        this.fileNamePatternWithoutCompSuffix = new FileNamePattern(AsyncArchivingFixedWindowCompressor.computeFileNameStrWithoutCompSuffix(this.fileNamePatternStr, this.compressionMode), this.context);
        this.addInfo("Will use the pattern 'index'+" + this.fileNamePatternWithoutCompSuffix + " for the active file");
        this.buildPrefixAndSuffixOfRollbackFilePath();
        this.initializeFileIndex();
        super.start();
    }

    private void buildPrefixAndSuffixOfRollbackFilePath() {
        this.buildPrefixOfRollbackFilePath();
        this.datePattern = this.extractDatePattern();
        this.buildSuffixOfRollbackFilePath();
    }

    private void buildPrefixOfRollbackFilePath() {
        int endPos = this.fileNamePatternStr.indexOf(".%d");
        if (-1 == endPos) {
            endPos = this.fileNamePatternStr.indexOf("%d");
        }
        if (-1 == endPos) {
            this.addError("fileNamePatternStr [" + this.fileNamePatternStr + "] does not contain '%d' token");
            throw new IllegalStateException("fileNamePatternStr [" + this.fileNamePatternStr + "] does not contain '%d' token");
        }
        this.fileNamePathPrefix = this.fileNamePatternStr.substring(0, endPos);
    }

    private Pattern extractDatePattern() {
        int startPos = this.fileNamePatternStr.indexOf("%d");
        if (-1 == startPos) {
            this.addError("fileNamePatternStr [" + this.fileNamePatternStr + "] does not contain '%d' token");
            throw new IllegalStateException("fileNamePatternStr [" + this.fileNamePatternStr + "] does not contain '%d' token");
        }
        String sregex = this.fileNamePatternWithoutCompSuffix.toRegex();
        int end = sregex.lastIndexOf(125);
        if (-1 == end) {
            this.addError("Regex of fileNamePattern [" + sregex + "] does not end with '}' token");
            throw new IllegalStateException("Regex of fileNamePattern [" + sregex + "] does not end with '}' token");
        }
        String sDatePattern = sregex.substring(startPos, end + 1);
        return Pattern.compile(sDatePattern);
    }

    private void buildSuffixOfRollbackFilePath() {
        if (this.datePattern == null) {
            this.addError("Null datePattern forbidden");
            throw new IllegalArgumentException("Null datePattern forbidden");
        }
        String fileNameWithoutCompSuffix = this.fileNamePatternWithoutCompSuffix.convert(new Date());
        Matcher matcher = this.datePattern.matcher(fileNameWithoutCompSuffix);
        if (!matcher.find()) {
            this.addError("fileNamePatternStr [" + this.fileNamePatternStr + "] does not match [" + this.datePattern + "] pattern");
            throw new IllegalStateException("fileNamePatternStr [" + this.fileNamePatternStr + "] does not match pattern[" + this.datePattern + "] in config file");
        }
        int suffixStart = matcher.start() + matcher.group().length();
        this.fileNamePathSuffix = fileNameWithoutCompSuffix.substring(suffixStart + 1);
    }

    private void initializeFileIndex() {
        File parentDir = new File(this.fileNamePatternStr).getParentFile();
        File[] matchingFileArray = this.filesInFolderMatchingCompressionMode(parentDir, this.compressionMode);
        this.fileIndex.set(this.findHighestIndex(matchingFileArray));
    }

    protected int getMaxWindowSize() {
        return MAX_WINDOW_SIZE;
    }

    private String transformFileNamePatternWithDate() {
        String slashified = FileFilterUtil.slashify(this.fileNamePatternStr);
        return FileFilterUtil.afterLastSlash(slashified);
    }

    @Override
    public void rollover() throws RolloverFailure {
        File parentDir = new File(this.fileNamePatternStr).getParentFile();
        File[] matchingFileArray = this.filesInFolderMatchingCompressionMode(parentDir, this.compressionMode);
        this.ascendingSortByTailIndex(matchingFileArray);
        int overflow = matchingFileArray.length - this.maxHistory + 1;
        for (File smallestFile : matchingFileArray) {
            if (overflow <= 0) continue;
            this.deleteMaybeCompressingFile(smallestFile);
            --overflow;
        }
        Date now = new Date();
        long highest = this.increaseFileIndex();
        this.deleteFileByIndex(highest, matchingFileArray);
        String timeBasedFileAppendIndex = this.buildFileNameWithIndex(now, highest);
        switch (this.compressionMode) {
            case NONE: {
                this.renameUtil.rename(this.getActiveFileName(), this.buildFileNameWithIndex(now, highest));
                break;
            }
            case GZ: {
                this.renameRawAndAsyncCompress(timeBasedFileAppendIndex, null);
                break;
            }
            case ZIP: {
                this.renameRawAndAsyncCompress(timeBasedFileAppendIndex, this.zipEntryFileNamePattern.convert(now));
                break;
            }
            default: {
                this.addError("CompressionMode only support 'zip', 'gz', 'none', but now '" + (Object)((Object)this.compressionMode) + "'");
                throw new IllegalArgumentException("CompressionMode only support 'zip', 'gz', 'none', but now '" + (Object)((Object)this.compressionMode) + "'");
            }
        }
    }

    private long increaseFileIndex() {
        return this.fileIndex.incrementAndGet();
    }

    String buildFileNameWithIndex(Date now, long index) {
        if (this.datePattern == null) {
            this.addError("Null datePattern forbidden");
            throw new IllegalArgumentException("Null datePattern forbidden");
        }
        String fileNameWithoutCompSuffix = this.fileNamePatternWithoutCompSuffix.convert(now);
        Matcher datePatternMatcher = this.datePattern.matcher(fileNameWithoutCompSuffix);
        if (!datePatternMatcher.find()) {
            this.addError("fileNameWithoutCompSuffix [" + this.fileNamePatternStr + "] can not match '" + datePatternMatcher);
            throw new IllegalStateException("fileNameWithoutCompSuffix [" + this.fileNamePatternStr + "] can not match '" + datePatternMatcher);
        }
        String result = String.format("%s.%019d.%s.%s", this.fileNamePathPrefix, index, datePatternMatcher.group(), this.fileNamePathSuffix);
        return result;
    }

    private void deleteFileByIndex(long index, File ... matchingFileArray) {
        for (File file : matchingFileArray) {
            long tailIndex = this.extractFileIndex(file);
            if (index != tailIndex) continue;
            this.deleteMaybeCompressingFile(file);
            break;
        }
    }

    private long findHighestIndex(File ... matchingFileArray) {
        long max = Long.MIN_VALUE;
        for (File file : matchingFileArray) {
            long fileIndex = this.extractFileIndex(file);
            if (max >= fileIndex) continue;
            max = fileIndex;
        }
        if (max == Long.MIN_VALUE || max == Long.MAX_VALUE) {
            max = 0L;
        }
        return max;
    }

    private long extractFileIndex(File file) {
        String fileNamePrefix;
        if (file == null) {
            this.addError("Null file forbidden");
            throw new IllegalArgumentException("Null file forbidden");
        }
        long index = 0L;
        String fileName = file.getName();
        int fileNamePrefixStartPos = fileName.indexOf(fileNamePrefix = FileFilterUtil.afterLastSlash(this.fileNamePathPrefix));
        if (-1 == fileNamePrefixStartPos) {
            this.addError("Can not find preifx[" + fileNamePrefix + "] in '" + fileName + "'.");
        } else {
            int beginIndex = fileName.indexOf(".", fileNamePrefixStartPos + fileNamePrefix.length());
            int endIndex = fileName.indexOf(".", beginIndex + 1);
            String sFileIndex = "";
            try {
                sFileIndex = fileName.substring(beginIndex + 1, endIndex);
                index = Long.parseLong(sFileIndex, 10);
            }
            catch (NumberFormatException e) {
                this.addError("Cannot parse '" + sFileIndex + "' as type Long.");
            }
            catch (StringIndexOutOfBoundsException e) {
                this.addError("Cannot extract file index from '" + fileName + "'.");
            }
        }
        return index;
    }

    File[] filesInFolderMatchingCompressionMode(File file, final CompressionMode compressionMode) {
        File[] matchingFileArray = file == null || !file.exists() || !file.isDirectory() ? new File[]{} : file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean accepted;
                switch (compressionMode) {
                    case NONE: {
                        accepted = new File(dir, name).isFile();
                        break;
                    }
                    case ZIP: {
                        accepted = new File(dir, name).isFile() && name.endsWith(".zip");
                        break;
                    }
                    case GZ: {
                        accepted = new File(dir, name).isFile() && name.endsWith(".gz");
                        break;
                    }
                    default: {
                        AsyncArchivingFixedWindowRollingPolicy.this.addError("CompressionMode only support 'zip', 'gz', 'none', but now '" + (Object)((Object)compressionMode) + "'");
                        throw new IllegalArgumentException("CompressionMode only support 'zip', 'gz', 'none', but now '" + (Object)((Object)compressionMode) + "'");
                    }
                }
                return accepted;
            }
        });
        return matchingFileArray;
    }

    private void deleteMaybeCompressingFile(File maybeCompressingFile) {
        if (maybeCompressingFile != null) {
            String indexFileName = maybeCompressingFile.getName();
            this.deleteTemporaryFile(indexFileName);
            this.deleteFile(maybeCompressingFile);
        } else {
            this.addWarn("Failed to delete file maybe compressing due to null 'indexFile'.");
        }
    }

    private void deleteFile(File file) {
        if (file != null) {
            if (!file.isFile()) {
                this.addInfo("Skipping delete file for directory rather than file [" + file + "].");
            } else if (!file.exists()) {
                this.addInfo("Skipping delete file for inexistent file [" + file + "].");
            } else if (!file.delete()) {
                this.addWarn("Could not delete [" + file + "].");
            }
        } else {
            this.addWarn("Could not delete file due to null 'indexFile'.");
        }
    }

    private void deleteTemporaryFile(String compressedFileName) {
        if (compressedFileName == null) {
            this.addWarn("Could not delete temporary file due to null 'compressedFileName'.");
        } else {
            CompressingTask compressingTask;
            Future<?> future;
            String fileNameWithoutSuffix = AsyncArchivingFixedWindowCompressor.computeFileNameStrWithoutCompSuffix(compressedFileName, this.compressionMode);
            if (this.nameAndFutureMap.containsKey(fileNameWithoutSuffix) && (future = (compressingTask = this.nameAndFutureMap.get(fileNameWithoutSuffix)).getFuture()) != null) {
                boolean cancelled = this.cancelCompressingTask(future);
                if (!cancelled) {
                    this.addWarn("Could not cancel compressing [" + fileNameWithoutSuffix + "] task");
                } else {
                    this.addInfo("Cancelled compressing [" + fileNameWithoutSuffix + "] task");
                }
                String temporaryFileName = compressingTask.getTemporaryFileName();
                File temporaryFile = new File(temporaryFileName);
                if (temporaryFile.exists()) {
                    if (!temporaryFile.delete()) {
                        this.addWarn("Could not delete temporary file[" + temporaryFileName + "].");
                    } else {
                        this.nameAndFutureMap.remove(fileNameWithoutSuffix);
                    }
                } else {
                    this.nameAndFutureMap.remove(fileNameWithoutSuffix);
                }
            }
        }
    }

    private boolean cancelCompressingTask(Future<?> future) {
        boolean cancelled;
        if (!future.isDone() && !future.isCancelled()) {
            cancelled = future.cancel(true);
        } else {
            this.addInfo("Skip to cancel inexistent file task");
            cancelled = true;
        }
        return cancelled;
    }

    private Future<?> renameRawAndAsyncCompress(String nameOfCompressedFile, String innerEntryName) throws RolloverFailure {
        String parentsRawFile = this.getParentsRawFileProperty();
        String tmpTarget = nameOfCompressedFile + "-" + System.nanoTime() + ".tmp";
        this.renameUtil.rename(parentsRawFile, tmpTarget);
        Future<?> future = this.compressor.asyncCompress(tmpTarget, nameOfCompressedFile, innerEntryName);
        this.nameAndFutureMap.put(FileFilterUtil.afterLastSlash(nameOfCompressedFile), new CompressingTask(tmpTarget, future));
        return future;
    }

    public void ascendingSortByTailIndex(File ... matchingFileArray) {
        Arrays.sort(matchingFileArray, new Comparator<File>(){

            @Override
            public int compare(File thisFile, File thatFile) {
                long thatIndex;
                long thisIndex = AsyncArchivingFixedWindowRollingPolicy.this.extractFileIndex(thisFile);
                int result = thisIndex == (thatIndex = AsyncArchivingFixedWindowRollingPolicy.this.extractFileIndex(thatFile)) ? 0 : (thatIndex < thisIndex ? 1 : -1);
                return result;
            }
        });
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.waitForAsynchronousJobsToStop();
        super.stop();
    }

    private void waitForAsynchronousJobsToStop() {
        if (this.nameAndFutureMap.isEmpty()) {
            return;
        }
        for (CompressingTask compressingTask : this.nameAndFutureMap.values()) {
            Future<?> aFuture = compressingTask.getFuture();
            if (aFuture == null) continue;
            try {
                aFuture.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                this.addError("Timeout while waiting for compression [" + compressingTask.getTemporaryFileName() + " job to finish.", e);
            }
            catch (Exception e) {
                this.addError("Unexpected exception while waiting for compression [" + compressingTask.getTemporaryFileName() + "] job to finish.", e);
            }
        }
        this.nameAndFutureMap.clear();
    }

    @Override
    public String getActiveFileName() {
        return this.getParentsRawFileProperty();
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
    }

    public String toString() {
        return "c.q.l.core.rolling.AsyncArchivingFixedWindowRollingPolicy@" + this.hashCode();
    }

    private static class CompressingTask {
        private final String temporaryFileName;
        private final Future<?> future;

        public CompressingTask(String temporaryFileName, Future<?> future) {
            this.temporaryFileName = temporaryFileName;
            this.future = future;
        }

        public String getTemporaryFileName() {
            return this.temporaryFileName;
        }

        public Future<?> getFuture() {
            return this.future;
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (o == null || this.getClass() != o.getClass()) {
                result = false;
            } else {
                CompressingTask that = (CompressingTask)o;
                result = this.temporaryFileName == that.temporaryFileName || this.temporaryFileName != null && this.temporaryFileName.equals(that.temporaryFileName);
            }
            return result;
        }

        public int hashCode() {
            return Arrays.hashCode(new String[]{this.temporaryFileName});
        }
    }
}

