/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm;

import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.CompatibleContext;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class Crypto {
    private SM3Digest keySM3Engine;
    private SM3Digest datSM3Engine;
    private BigInteger userD;
    private BigInteger C1XCoord = null;
    private BigInteger C1YCoord = null;
    private byte[] P2XBytes = null;
    private byte[] P2YBytes = null;
    private byte[] key = new byte[32];
    private byte keyOff = 0;
    private int ct = 1;

    private void reset() {
        this.keySM3Engine = new SM3Digest();
        this.datSM3Engine = new SM3Digest();
        this.keySM3Engine.update(this.P2XBytes, 0, this.P2XBytes.length);
        this.keySM3Engine.update(this.P2YBytes, 0, this.P2YBytes.length);
        this.datSM3Engine.update(this.P2XBytes, 0, this.P2XBytes.length);
        this.ct = 1;
        this.nextKey();
    }

    private void nextKey() {
        SM3Digest sm3keycur = new SM3Digest(this.keySM3Engine);
        sm3keycur.update((byte)(this.ct >> 24 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 16 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 8 & 0xFF));
        sm3keycur.update((byte)(this.ct & 0xFF));
        sm3keycur.doFinal(this.key, 0);
        this.keyOff = 0;
        ++this.ct;
    }

    public void initEncrypt(ECPoint userKey) {
        if (userKey == null) {
            throw new SecurityException("null/length not allowed for userKey");
        }
        AsymmetricCipherKeyPair key = SM2Params.generators.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger k = ecpriv.getD();
        ECPoint C1 = ecpub.getQ().normalize();
        this.C1XCoord = C1.getXCoord().toBigInteger();
        this.C1YCoord = C1.getYCoord().toBigInteger();
        ECPoint P2 = userKey.multiply(k).normalize();
        this.P2XBytes = BigIntegers.asUnsignedByteArray(32, P2.getXCoord().toBigInteger());
        this.P2YBytes = BigIntegers.asUnsignedByteArray(32, P2.getYCoord().toBigInteger());
        this.reset();
    }

    public void initDecrypt(BigInteger userD) {
        if (userD == null) {
            throw new SecurityException("null/length not allowed for userD");
        }
        this.userD = userD;
    }

    public byte[] encrypt(byte[] sourceData) {
        if (sourceData == null) {
            throw new SecurityException("null/length not allowed for sourceData");
        }
        try {
            byte[] data = (byte[])sourceData.clone();
            this.datSM3Engine.update(data, 0, data.length);
            int i = 0;
            while (i < data.length) {
                if (this.keyOff == this.key.length) {
                    this.nextKey();
                }
                int n = i++;
                byte by = this.keyOff;
                this.keyOff = (byte)(by + 1);
                data[n] = (byte)(data[n] ^ this.key[by]);
            }
            byte[] hashValue = new byte[32];
            this.dofinal(hashValue);
            ASN1SM2Cipher asn1 = new ASN1SM2Cipher(this.C1XCoord, this.C1YCoord, hashValue, data);
            return asn1.getEncryptedBytes(CompatibleContext.getSM2OutputFormat());
        }
        catch (Exception e) {
            throw new RuntimeException("encrypt failure", e);
        }
    }

    public byte[] decrypt(byte[] encryptData) throws Exception {
        if (encryptData == null || encryptData.length < 96) {
            throw new SecurityException("null/length not allowed for SM2EncryptData");
        }
        BigInteger x = null;
        BigInteger y = null;
        byte[] encryptedBytes = null;
        byte[] hash = null;
        if (ASN1SM2Cipher.isASN1EncryptType(encryptData)) {
            ASN1SM2Cipher encoding = new ASN1SM2Cipher(encryptData, 1);
            x = encoding.getXCoordinate().getValue();
            byte[] c2DecryptedBytes = this.decrypt(x, y = encoding.getYCoordinate().getValue(), encryptedBytes = encoding.getCipherText().getOctets(), hash = encoding.getHashValue().getOctets());
            if (c2DecryptedBytes == null) {
                throw new IOException("[C3 hash no match] can not decrypt, Check SM2Key is match or the encrypt block is right");
            }
            return c2DecryptedBytes;
        }
        byte[] c1Xbyte = new byte[32];
        byte[] c1Ybyte = new byte[32];
        System.arraycopy(encryptData, 0, c1Xbyte, 0, 32);
        System.arraycopy(encryptData, 32, c1Ybyte, 0, 32);
        x = new BigInteger(1, c1Xbyte);
        y = new BigInteger(1, c1Ybyte);
        encryptedBytes = new byte[encryptData.length - 96];
        hash = new byte[32];
        System.arraycopy(encryptData, 64, hash, 0, 32);
        System.arraycopy(encryptData, 96, encryptedBytes, 0, encryptedBytes.length);
        byte[] c2DecryptedBytes = this.decrypt(x, y, encryptedBytes, hash);
        if (c2DecryptedBytes == null) {
            System.arraycopy(encryptData, 64, encryptedBytes, 0, encryptedBytes.length);
            System.arraycopy(encryptData, 64 + encryptedBytes.length, hash, 0, 32);
            c2DecryptedBytes = this.decrypt(x, y, encryptedBytes, hash);
        }
        if (c2DecryptedBytes == null) {
            throw new IOException("[C3 hash no match] can not decrypt, Check SM2Key is match or if the encrypt block is right");
        }
        return c2DecryptedBytes;
    }

    private final byte[] decrypt(BigInteger x, BigInteger y, byte[] encryptedBytes, byte[] hash) throws IOException {
        ECPoint c1 = SM2Params.sm2ParameterSpec.getCurve().createPoint(x, y);
        ECPoint P2 = c1.multiply(this.userD).normalize();
        this.P2XBytes = BigIntegers.asUnsignedByteArray(32, P2.getXCoord().toBigInteger());
        this.P2YBytes = BigIntegers.asUnsignedByteArray(32, P2.getYCoord().toBigInteger());
        this.reset();
        byte[] decrypted = (byte[])encryptedBytes.clone();
        int i = 0;
        while (i < decrypted.length) {
            if (this.keyOff == this.key.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            decrypted[n] = (byte)(decrypted[n] ^ this.key[by]);
        }
        this.datSM3Engine.update(decrypted, 0, decrypted.length);
        byte[] C3Hash = new byte[32];
        this.dofinal(C3Hash);
        if (Arrays.equals(C3Hash, hash)) {
            return decrypted;
        }
        return null;
    }

    private void dofinal(byte[] C2Hash) {
        this.datSM3Engine.update(this.P2YBytes, 0, this.P2YBytes.length);
        this.datSM3Engine.doFinal(C2Hash, 0);
        this.reset();
    }
}

