/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public abstract class AlgorithmParametersSPI
extends AlgorithmParametersSpi {
    protected boolean isASN1FormatString(String format) {
        return format == null || format.equals("ASN.1");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == null) {
            throw new NullPointerException("argument to getParameterSpec must not be null");
        }
        return this.localEngineGetParameterSpec(paramSpec);
    }

    protected abstract AlgorithmParameterSpec localEngineGetParameterSpec(Class var1) throws InvalidParameterSpecException;

    public static class SM2
    extends AlgorithmParametersSPI {
        AlgorithmParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            return null;
        }

        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format) || format.equalsIgnoreCase("X.509")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (!format.equalsIgnoreCase("X.509") && !format.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown parameter format " + format);
            }
            this.engineInit(params);
        }

        protected String engineToString() {
            return "SM2 Parameters";
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            return null;
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        }

        protected void engineInit(byte[] params) throws IOException {
        }
    }
}

