/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardBigIntegers;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import java.math.BigInteger;

final class RSACardRefPublicKeyParams {
    final byte[] keyData;
    final int bitLength;
    final RSAKeyParameters params;

    RSACardRefPublicKeyParams(byte[] keyData) throws CryptoException {
        int bitLength = RSACardBigIntegers.parseBitLength(keyData);
        if (keyData.length < 1028) {
            throw new CryptoParameterException("RSACardRefPublicKeyParams failure with invalid param#keyData");
        }
        int eMaxBitLength = 32;
        int maxLength = 512;
        int offset = 4;
        BigInteger modulus = RSACardBigIntegers.parseBigInteger(keyData, offset, 512, bitLength);
        BigInteger exponent = RSACardBigIntegers.parseBigInteger(keyData, offset += 512, 512, 32);
        this.keyData = keyData;
        this.bitLength = bitLength;
        this.params = new RSAKeyParameters(false, modulus, exponent);
    }

    RSACardRefPublicKeyParams(RSAKeyParameters params) throws CryptoException {
        if (params == null) {
            throw new CryptoParameterException("RSACardRefPublicKeyParams failure with invalid param#params");
        }
        BigInteger modulus = params.getModulus();
        int bitLength = RSACardBigIntegers.parseModulusBitLength(modulus);
        byte[] keyData = this.buildKeyData(bitLength, params);
        this.params = params;
        this.bitLength = bitLength;
        this.keyData = keyData;
    }

    private byte[] buildKeyData(int bitLength, RSAKeyParameters params) throws CryptoException {
        byte[] keyData = new byte[1028];
        int offset = RSACardBigIntegers.copyBitLength(bitLength, keyData, 0);
        int maxLength = 512;
        RSACardBigIntegers.copyBigInteger("params#modulus", params.getModulus(), 512, keyData, offset);
        RSACardBigIntegers.copyBigInteger("params#exponent", params.getExponent(), 512, keyData, offset += 512);
        if ((offset += 512) != keyData.length) {
            throw new CryptoParameterException("RSACardRefPrivateKeyParams buildKeyData failure with invalid offset");
        }
        return keyData;
    }
}

