/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardExternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardInternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardPublicKey;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardRefPrivateKeyParams;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardRefPublicKeyParams;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import cfca.sadk.system.logging.LoggerManager;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public final class RSACardKeyHelper {
    private RSACardKeyHelper() {
    }

    public static RSAPublicKey buildPublicKey(PublicKey publicKey) throws CryptoException {
        RSACardPublicKey pubKey;
        if (publicKey == null) {
            throw new CryptoParameterException("RSACard buildExternalPublicKey failure with null publicKey");
        }
        if (publicKey instanceof RSACardPublicKey) {
            pubKey = (RSACardPublicKey)publicKey;
        } else if (publicKey instanceof RSAPublicKey) {
            byte[] keyData = RSACardKeyHelper.buildExternalKeyData((RSAPublicKey)publicKey);
            pubKey = RSACardPublicKey.buildExternalSoftKey(keyData);
        } else {
            throw new CryptoException("RSACard buildExternalPublicKey failure with not support key: " + publicKey.getClass());
        }
        return pubKey;
    }

    public static RSAPublicKey buildExternalPublicKey(byte[] pubKeyData) throws CryptoException {
        if (pubKeyData == null) {
            throw new CryptoParameterException("RSACard buildExternalPublicKey failure with null pubKeyData");
        }
        try {
            return RSACardPublicKey.buildExternalSoftKey(pubKeyData);
        }
        catch (Exception e) {
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                LoggerManager.exceptionLogger.error("RSACard buildExternalPublicKey failure with invalid pubKeyData: {}", (Object)DataHelper.dump4KPartData(pubKeyData), (Object)e);
            }
            throw new CryptoException("RSACard buildExternalPublicKey failure with invalid pubKeyData", e);
        }
    }

    public static RSAPublicKey buildInternalPublicKey(int keyIndex, int keyUsage, byte[] pubKeyData) throws CryptoException {
        if (keyIndex <= 0) {
            throw new CryptoParameterException("RSACard buildInternalPublicKey failure with keyIndex=" + keyIndex);
        }
        if (pubKeyData == null) {
            throw new CryptoParameterException("RSACard buildInternalPublicKey failure with null pubKeyData");
        }
        try {
            return RSACardPublicKey.buildInternalHardKey(keyIndex, keyUsage, pubKeyData);
        }
        catch (Exception e) {
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                LoggerManager.exceptionLogger.error("RSACard buildInternalPublicKey failure with invalid pubKeyData: {}, keyIndex={}", new Object[]{DataHelper.dump4KPartData(pubKeyData), keyIndex, e});
            }
            throw new CryptoException("RSACard buildInternalPublicKey failure with invalid pubKeyData", e);
        }
    }

    public static RSAPrivateKey buildPrivateKey(PrivateKey privateKey) throws CryptoException {
        RSAPrivateKey privKey;
        if (privateKey == null) {
            throw new CryptoParameterException("RSACard buildExternalPrivateKey failure with null privateKey");
        }
        if (privateKey instanceof RSACardExternalPrivateKey) {
            privKey = (RSACardExternalPrivateKey)privateKey;
        } else if (privateKey instanceof RSACardInternalPrivateKey) {
            privKey = (RSACardInternalPrivateKey)privateKey;
        } else if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey crtKey = (RSAPrivateCrtKey)privateKey;
            boolean valid = RSACardKeyHelper.isValidRSAPrivateCrtKey(crtKey);
            if (valid) {
                byte[] keyData = RSACardKeyHelper.buildExternalKeyData(crtKey);
                privKey = new RSACardExternalPrivateKey(keyData);
            } else {
                privKey = (RSAPrivateKey)privateKey;
            }
        } else if (privateKey instanceof RSAPrivateKey) {
            privKey = (RSAPrivateKey)privateKey;
        } else {
            throw new CryptoParameterException("RSACard buildExternalPrivateKey failure with not RSAPrivateKey");
        }
        return privKey;
    }

    public static RSAPrivateKey buildExternalPrivateKey(byte[] priKeyData) throws CryptoException {
        if (priKeyData == null) {
            throw new CryptoParameterException("RSACard buildExternalPrivateKey failure with null priKeyData");
        }
        try {
            return new RSACardExternalPrivateKey(priKeyData);
        }
        catch (Exception e) {
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                LoggerManager.exceptionLogger.error("RSACard buildExternalPrivateKey failure with invalid priKeyData: {}", (Object)DataHelper.dump4KPartData(priKeyData), (Object)e);
            }
            throw new CryptoException("RSACard buildExternalPrivateKey failure with invalid priKeyData", e);
        }
    }

    public static RSAPrivateKey buildInternalPrivateKey(int keyIndex, int keyUsage, byte[] pubKeyData) throws CryptoException {
        if (keyIndex <= 0) {
            throw new CryptoParameterException("RSACard buildInternalPrivateKey failure with keyIndex=" + keyIndex);
        }
        if (pubKeyData == null) {
            throw new CryptoParameterException("RSACard buildInternalPrivateKey failure with null pubKeyData");
        }
        try {
            return new RSACardInternalPrivateKey(keyIndex, keyUsage, pubKeyData);
        }
        catch (Exception e) {
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                LoggerManager.exceptionLogger.error("RSACard buildInternalPrivateKey failure with invalid pubKeyData: {}, keyIndex={}", new Object[]{DataHelper.dump4KPartData(pubKeyData), keyIndex, e});
            }
            throw new CryptoException("RSACard buildInternalPrivateKey failure with invalid pubKeyData", e);
        }
    }

    private static byte[] buildExternalKeyData(RSAPublicKey publicKey) throws CryptoException {
        if (publicKey == null) {
            throw new CryptoParameterException("RSACard buildExternalKeyData failure: missing publicKey");
        }
        RSAKeyParameters params = new RSAKeyParameters(false, publicKey.getModulus(), publicKey.getPublicExponent());
        RSACardRefPublicKeyParams keyParameters = new RSACardRefPublicKeyParams(params);
        return (byte[])keyParameters.keyData.clone();
    }

    private static byte[] buildExternalKeyData(RSAPrivateCrtKey privateKey) throws CryptoException {
        if (privateKey == null) {
            throw new CryptoParameterException("RSACard buildExternalKeyData failure: missing privateKey");
        }
        RSAPrivateCrtKeyParameters params = new RSAPrivateCrtKeyParameters(privateKey.getModulus(), privateKey.getPublicExponent(), privateKey.getPrivateExponent(), privateKey.getPrimeP(), privateKey.getPrimeQ(), privateKey.getPrimeExponentP(), privateKey.getPrimeExponentQ(), privateKey.getCrtCoefficient());
        RSACardRefPrivateKeyParams keyParameters = new RSACardRefPrivateKeyParams(params);
        return (byte[])keyParameters.keyData.clone();
    }

    private static boolean isValidRSAPrivateCrtKey(RSAPrivateCrtKey crtKey) {
        boolean isValidRSAPrivateCrtKey;
        if (crtKey == null) {
            isValidRSAPrivateCrtKey = false;
        } else {
            int modulusBitsLengthLimited = 4096;
            int exponentBitsLengthLimited = 32;
            BigInteger n = crtKey.getModulus();
            BigInteger e = crtKey.getPublicExponent();
            int modulusBitsLength = 7 + n.bitLength() >> 3 << 3;
            int othersBitsLength = modulusBitsLength >> 1;
            BigInteger d = crtKey.getPrivateExponent();
            isValidRSAPrivateCrtKey = RSACardKeyHelper.checkBitLength(n, 4096) && RSACardKeyHelper.checkBitLength(e, 32) && RSACardKeyHelper.checkBitLength(d, 4096) && RSACardKeyHelper.checkBitLength(crtKey.getPrimeP(), othersBitsLength) && RSACardKeyHelper.checkBitLength(crtKey.getPrimeQ(), othersBitsLength) && RSACardKeyHelper.checkBitLength(crtKey.getPrimeExponentP(), othersBitsLength) && RSACardKeyHelper.checkBitLength(crtKey.getPrimeExponentQ(), othersBitsLength) && RSACardKeyHelper.checkBitLength(crtKey.getCrtCoefficient(), othersBitsLength);
        }
        return isValidRSAPrivateCrtKey;
    }

    private static boolean checkBitLength(BigInteger x, int bitLengthLimited) {
        int bitLength;
        boolean isValidParameter = x == null ? false : (bitLength = x.bitLength()) > 0 && bitLength <= bitLengthLimited;
        return isValidParameter;
    }
}

