/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.net;

import cpcn.dsp.institution.api.io.IoUtil;
import cpcn.dsp.institution.api.net.SecurityContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SocketConnection {
    private String host;
    private int port;
    private boolean ssl;
    private int bufferSize = 1024;
    private int connectTimeout = 25000;
    private int soTimeout = 25000;

    public SocketConnection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] send(byte[] request) throws Exception {
        byte[] response;
        if (this.ssl) {
            Socket socket = SecurityContext.sslSocketFactory.createSocket(this.host, this.port);
            try {
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(request);
                outputStream.flush();
                InputStream inputStream = socket.getInputStream();
                response = IoUtil.read(inputStream, this.bufferSize);
                outputStream.close();
                inputStream.close();
            }
            finally {
                socket.close();
            }
        }
        Socket socket = new Socket();
        try {
            InetAddress inetAddress = InetAddress.getByName(this.host);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.port);
            socket.connect(inetSocketAddress, this.connectTimeout);
            socket.setSoTimeout(this.soTimeout);
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(request);
            outputStream.flush();
            socket.shutdownOutput();
            InputStream inputStream = socket.getInputStream();
            response = IoUtil.read(inputStream, this.bufferSize);
            outputStream.close();
            inputStream.close();
        }
        finally {
            socket.close();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sendLengthValue(byte[] request) throws Exception {
        byte[] response;
        Socket socket = new Socket();
        try {
            InetAddress inetAddress = InetAddress.getByName(this.host);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.port);
            socket.connect(inetSocketAddress, this.connectTimeout);
            socket.setSoTimeout(this.soTimeout);
            OutputStream outputStream = socket.getOutputStream();
            IoUtil.sendLengthValue(outputStream, request);
            socket.shutdownOutput();
            InputStream inputStream = socket.getInputStream();
            response = IoUtil.readLengthValue(inputStream);
            outputStream.close();
            inputStream.close();
        }
        finally {
            socket.close();
        }
        return response;
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public void setSSL(boolean sslParam) {
        this.ssl = sslParam;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

