/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.tx.personalinfo;

import com.alibaba.fastjson.JSONObject;
import cpcn.dsp.institution.api.tx.TxBaseResponse;
import cpcn.dsp.institution.api.util.JSONUtil;
import cpcn.dsp.institution.api.vo.AdmPenalInfo;
import cpcn.dsp.institution.api.vo.BreakFaithExecutorInfo;
import cpcn.dsp.institution.api.vo.JudicialExecutorInfo;
import cpcn.dsp.institution.api.vo.OrgExecutiveInfo;
import cpcn.dsp.institution.api.vo.OrgLrInfo;
import cpcn.dsp.institution.api.vo.OrgShareholderInfo;
import java.lang.reflect.Method;
import java.util.List;

public class Tx2211Response
extends TxBaseResponse {
    private String institutionID;
    private String txSN;
    private String traceNo;
    private String responseCode;
    private String responseMessage;
    private List<OrgLrInfo> orgLrInfoList;
    private List<OrgShareholderInfo> orgShareInfoList;
    private List<OrgExecutiveInfo> orgExecutiveInfoList;
    private List<BreakFaithExecutorInfo> breakFaithExecutorInfoList;
    private List<JudicialExecutorInfo> judicialExecutorInfoList;
    private List<AdmPenalInfo> admPenalInfoList;

    public Tx2211Response(String responseMessage, String responseSignature) throws Exception {
        super(responseMessage, responseSignature);
    }

    public Tx2211Response(String responseMessage, String responseSignature, String responseDgtlEnvlp, String responseSignSN, String responseEncryptSN) throws Exception {
        super(responseMessage, responseSignature, responseDgtlEnvlp, responseSignSN, responseEncryptSN);
    }

    @Override
    protected void process(String document) throws Exception {
        if ("2000".equals(this.code)) {
            JSONObject jsonObject = JSONObject.parseObject((String)document);
            this.institutionID = jsonObject.getString("InstitutionID");
            this.txSN = jsonObject.getString("TxSN");
            this.traceNo = jsonObject.getString("TraceNo");
            this.responseCode = jsonObject.getString("ResponseCode");
            this.responseMessage = jsonObject.getString("ResponseMessage");
            String[] infoList = new String[]{"OrgLrInfoList", "OrgShareInfoList", "OrgExecutiveInfoList", "BreakFaithExecutorInfoList", "JudicialExecutorInfoList", "AdmPenalInfoList"};
            Class<?> responseClass = this.getClass();
            for (String info : infoList) {
                String json = jsonObject.getString(info);
                Class<?> clazz = null;
                Method method = null;
                if ("OrgShareInfoList".equals(info)) {
                    clazz = Class.forName("cpcn.dsp.institution.api.vo.OrgShareholderInfo");
                    method = responseClass.getDeclaredMethod("setOrgShareInfoList", List.class);
                } else {
                    clazz = Class.forName("cpcn.dsp.institution.api.vo." + info.substring(0, info.length() - 4));
                    method = responseClass.getDeclaredMethod("set" + info, List.class);
                }
                method.invoke((Object)this, this.getList(json, clazz));
            }
        }
    }

    private <T> List<T> getList(String json, Class<T> beanClass) {
        return JSONUtil.toList(json, beanClass);
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public void setInstitutionID(String institutionID) {
        this.institutionID = institutionID;
    }

    public String getTxSN() {
        return this.txSN;
    }

    public void setTxSN(String txSN) {
        this.txSN = txSN;
    }

    public String getTraceNo() {
        return this.traceNo;
    }

    public void setTraceNo(String traceNo) {
        this.traceNo = traceNo;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public List<OrgLrInfo> getOrgLrInfoList() {
        return this.orgLrInfoList;
    }

    public void setOrgLrInfoList(List<OrgLrInfo> orgLrInfoList) {
        this.orgLrInfoList = orgLrInfoList;
    }

    public List<OrgExecutiveInfo> getOrgExecutiveInfoList() {
        return this.orgExecutiveInfoList;
    }

    public void setOrgExecutiveInfoList(List<OrgExecutiveInfo> orgExecutiveInfoList) {
        this.orgExecutiveInfoList = orgExecutiveInfoList;
    }

    public List<BreakFaithExecutorInfo> getBreakFaithExecutorInfoList() {
        return this.breakFaithExecutorInfoList;
    }

    public void setBreakFaithExecutorInfoList(List<BreakFaithExecutorInfo> breakFaithExecutorInfoList) {
        this.breakFaithExecutorInfoList = breakFaithExecutorInfoList;
    }

    public List<JudicialExecutorInfo> getJudicialExecutorInfoList() {
        return this.judicialExecutorInfoList;
    }

    public void setJudicialExecutorInfoList(List<JudicialExecutorInfo> judicialExecutorInfoList) {
        this.judicialExecutorInfoList = judicialExecutorInfoList;
    }

    public List<AdmPenalInfo> getAdmPenalInfoList() {
        return this.admPenalInfoList;
    }

    public void setAdmPenalInfoList(List<AdmPenalInfo> admPenalInfoList) {
        this.admPenalInfoList = admPenalInfoList;
    }

    public List<OrgShareholderInfo> getOrgShareInfoList() {
        return this.orgShareInfoList;
    }

    public void setOrgShareInfoList(List<OrgShareholderInfo> orgShareInfoList) {
        this.orgShareInfoList = orgShareInfoList;
    }
}

