/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.EncryptUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import cpcn.dsp.institution.api.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Random;

public class EncryptAndDecryptSM2 {
    private static EncryptAndDecryptSM2 encryptAndDecryptSM2;
    public static final String aes_algorithm = "AES/ECB/PKCS7Padding";
    public static final String rsa_algorithm = "RSA/ECB/PKCS1Padding";
    private PrivateKey privateKey;
    private X509Cert x509Cert;
    private String serviceID;
    private boolean flag = false;
    private static final String deviceName = "JSOFT_LIB";
    private static Session session;
    private static final String signAlg = "sm3WithSM2Encryption";
    public String requestSignSN;
    private PublicKey publicKey;
    private X509Cert x509Cert2;
    public String requestEncryptSN;
    private static Session session2;
    private static final Mechanism mechanism;

    public static EncryptAndDecryptSM2 getEncryptAndDecrypt() {
        if (encryptAndDecryptSM2 == null) {
            throw new RuntimeException("\u8bc1\u4e66\u672a\u521d\u59cb\u5316");
        }
        return encryptAndDecryptSM2;
    }

    private EncryptAndDecryptSM2(String myKeystoreFilepath, String myKeystorePassword, String certificateFilepath) throws Exception {
        this.initPfxSingner(myKeystoreFilepath, myKeystorePassword, null);
        this.initPublicKey(certificateFilepath);
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static synchronized void init(String myKeystoreFilepath, String myKeystorePassword, String certificateFilepath) throws Exception {
        if (encryptAndDecryptSM2 == null) {
            encryptAndDecryptSM2 = new EncryptAndDecryptSM2(myKeystoreFilepath, myKeystorePassword, certificateFilepath);
        }
    }

    private void initPfxSingner(String filename, String password, String serviceID) throws Exception {
        this.x509Cert = CertUtil.getCertFromSM2((String)filename);
        this.privateKey = KeyUtil.getPrivateKeyFromSM2((String)filename, (String)password);
        JCrypto.getInstance().initialize(deviceName, null);
        session = JCrypto.getInstance().openSession(deviceName);
        if (null == serviceID) {
            this.serviceID = serviceID;
            this.flag = true;
        }
        this.requestSignSN = this.x509Cert.getSerialNumber().toString();
    }

    private void initPublicKey(String certificateFilepath) throws Exception {
        X509Cert x509Cert;
        this.x509Cert2 = x509Cert = new X509Cert(certificateFilepath);
        JCrypto.getInstance().initialize(deviceName, null);
        session2 = JCrypto.getInstance().openSession(deviceName);
        this.requestEncryptSN = String.valueOf(x509Cert.getSerialNumber());
    }

    public static String randomHexString(int len) {
        StringBuffer result = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < len; ++i) {
            result.append(Integer.toHexString(random.nextInt(16)));
        }
        return result.toString().toUpperCase();
    }

    public String encryptByRSA(byte[] plainData) throws Exception {
        byte[] base64Bytes = EncryptUtil.encrypt((Mechanism)mechanism, (Key)this.x509Cert.getPublicKey(), (byte[])plainData, (Session)session);
        return new String(base64Bytes, "UTF-8");
    }

    public static String encode(String str, String key) throws Exception {
        return new String(Base64.encode(EncryptUtil.encryptMessageBySM4((byte[])str.getBytes(), (String)key)), "UTF-8");
    }

    public byte[] sign(byte[] data) throws Exception {
        Signature signature = new Signature();
        return Base64.decode(signature.p7SignMessageDetach(signAlg, data, this.privateKey, this.x509Cert, session));
    }

    public String getDecryptKeyByteByRSA(String respDgtlEnvlp) throws Exception {
        return new String(EncryptUtil.decrypt((Mechanism)mechanism, (Key)this.privateKey, (byte[])respDgtlEnvlp.getBytes(), (Session)session), "UTF-8");
    }

    public String decodeByAES(String message, String digitalEnvelope) throws Exception {
        return new String(EncryptUtil.decryptMessageBySM4((byte[])Base64.decode(message), (String)digitalEnvelope), "UTF-8");
    }

    public static String bytes2hex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        String b = "";
        if (null == bytes) {
            return null;
        }
        for (int i = 0; i < bytes.length; ++i) {
            b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() == 1) {
                result.append("0");
            }
            result.append(b);
        }
        return result.toString().toUpperCase();
    }

    public static byte[] hex2bytes(String hexStringParam) {
        String hexString = hexStringParam;
        hexString = hexString.toUpperCase();
        char[] chars = hexString.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int index = 0;
        for (int i = 0; i < chars.length; i += 2) {
            byte newByte = 0;
            newByte = (byte)(newByte | EncryptAndDecryptSM2.char2byte(chars[i]));
            newByte = (byte)(newByte << 4);
            bytes[index] = newByte = (byte)(newByte | EncryptAndDecryptSM2.char2byte(chars[i + 1]));
            ++index;
        }
        return bytes;
    }

    private static byte char2byte(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return Byte.parseByte(String.valueOf(ch), 16);
            }
        }
        return 0;
    }

    public static String createLinkStringByGet(Map<String, String> params) throws UnsupportedEncodingException {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            value = URLEncoder.encode(value, "UTF-8");
            prestr = i == keys.size() - 1 ? prestr + key + "=" + value : prestr + key + "=" + value + "&";
        }
        return prestr;
    }

    static {
        mechanism = new Mechanism("SM2");
    }
}

