/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.card.SM2Key;
import cfca.sadk.lib.crypto.card.c200.SM2CardKey;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public final class SM2CardPublicKey
extends SM2CardKey
implements ECPublicKey,
SM2Key {
    private static final long serialVersionUID = -940772119584430981L;
    private final ECParameterSpec sm2ParameterSpec = SM2Params.sm2ParameterSpec;
    private final ECPoint Q;
    private final BigInteger iPubX;
    private final BigInteger iPubY;

    SM2CardPublicKey(byte[] defaultZ, long keyHandle, byte[] pubKeyX, byte[] pubKeyY, String CKID, int keyUsage) {
        super(defaultZ, keyHandle, pubKeyX, pubKeyY, CKID, keyUsage);
        this.iPubX = new BigInteger(1, pubKeyX);
        this.iPubY = new BigInteger(1, pubKeyY);
        this.Q = this.sm2ParameterSpec.getCurve().createPoint(this.iPubX, this.iPubY).normalize();
    }

    SM2CardPublicKey(SM2PublicKey sm2Key) {
        super(sm2Key);
        this.iPubX = new BigInteger(1, this.pubKeyX);
        this.iPubY = new BigInteger(1, this.pubKeyY);
        this.Q = this.sm2ParameterSpec.getCurve().createPoint(this.iPubX, this.iPubY).normalize();
    }

    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithm = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, GMObjectIdentifiers.sm2);
            byte[] encoded = new byte[65];
            encoded[0] = 4;
            System.arraycopy(this.pubKeyX, 0, encoded, 1, 32);
            System.arraycopy(this.pubKeyY, 0, encoded, 33, 32);
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(algorithm, encoded);
            return info.getEncoded("DER");
        }
        catch (Exception e) {
            throw new RuntimeException("Encoded Failure for SM2PublicKey", e);
        }
    }

    public ECParameterSpec getParams() {
        return this.sm2ParameterSpec;
    }

    public ECParameterSpec getParameters() {
        return this.sm2ParameterSpec;
    }

    public ECPoint getQ() {
        return this.Q;
    }

    public BigInteger getPubXByInt() {
        return this.iPubX;
    }

    public BigInteger getPubYByInt() {
        return this.iPubY;
    }

    byte[] buildExternalData(byte[] sourceData) {
        byte[] sourceCardData = new byte[sourceData.length + 64];
        System.arraycopy(this.pubKeyX, 0, sourceCardData, 0, 32);
        System.arraycopy(this.pubKeyY, 0, sourceCardData, 32, 32);
        System.arraycopy(sourceData, 0, sourceCardData, 64, sourceData.length);
        return sourceCardData;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SM2CardPublicKey [CKID=");
        builder.append(this.CKID);
        builder.append(", keyHandle=");
        builder.append(this.keyHandle);
        builder.append(", keyUsage=");
        builder.append(this.keyUsage);
        builder.append(", internal=");
        builder.append(this.internal);
        builder.append(", pubKeyX=");
        builder.append(Hex.toHexString(this.pubKeyX));
        builder.append(", pubKeyY=");
        builder.append(Hex.toHexString(this.pubKeyY));
        builder.append(", defaultZ=");
        builder.append(Hex.toHexString(this.defaultZ));
        builder.append("]");
        return builder.toString();
    }
}

