/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKey;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.util.HashUtil;
import java.io.InputStream;
import java.math.BigInteger;

final class ECCCardHashHelper {
    private ECCCardHashHelper() {
    }

    static byte[] hash(Mechanism mechanism, byte[] sourceData) throws CryptoException {
        if (mechanism == null) {
            throw new CryptoException("hash missing mechanism");
        }
        if (sourceData == null) {
            throw new CryptoException("hash missing sourceData");
        }
        try {
            return HashUtil.RSAHashMessageByJNI(sourceData, mechanism, false);
        }
        catch (Exception e) {
            throw new CryptoException("hash failure", e);
        }
        catch (Throwable e) {
            throw new CryptoException("hash failure", e);
        }
    }

    static byte[] hash(Mechanism mechanism, InputStream sourceStream) throws CryptoException {
        if (mechanism == null) {
            throw new CryptoException("hash missing mechanism");
        }
        if (sourceStream == null) {
            throw new CryptoException("hash missing sourceStream");
        }
        try {
            return HashUtil.RSAHashFileByJNI(sourceStream, mechanism, false);
        }
        catch (Exception e) {
            throw new CryptoException("hash failure", e);
        }
        catch (Throwable e) {
            throw new CryptoException("hash failure", e);
        }
    }

    static byte[] formatHashData(ECCCardKey eccKey, byte[] hashValue, boolean shiftRight) throws CryptoException {
        if (eccKey == null) {
            throw new CryptoException("ECCCard formatHashData failed: eccKey=null");
        }
        if (hashValue == null) {
            throw new CryptoException("ECCCard formatHashData failed: hashValue=null");
        }
        if (!ECCCurveId.isCardSupport(eccKey.getCurveId())) {
            throw new CryptoException("ECCCard do not support: eccKey/curveName->" + (Object)((Object)eccKey.getCurveId()));
        }
        if (shiftRight) {
            int expectedsHashLength = eccKey.getCurveByteLength();
            int log2n = eccKey.getCurveId().getCurveNBitLength();
            int messageBitLength = hashValue.length * 8;
            byte[] hashData = null;
            if (log2n < messageBitLength) {
                BigInteger e = new BigInteger(1, hashValue);
                e = e.shiftRight(messageBitLength - log2n);
                hashData = BigIntegers.asUnsignedByteArray(expectedsHashLength, e);
            } else {
                hashData = new byte[expectedsHashLength];
                System.arraycopy(hashValue, 0, hashData, hashData.length - hashValue.length, hashValue.length);
            }
            return hashData;
        }
        return hashValue;
    }
}

