/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1Boolean;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.tsp.TimeStampReq;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.timestamp.client.BusinessTrustCerts;
import cfca.sadk.timestamp.client.HTTPRequester;
import cfca.sadk.timestamp.client.SSLContextManager;
import cfca.sadk.timestamp.client.TSASignedData;
import cfca.sadk.timestamp.client.TimestampNonce;
import cfca.sadk.timestamp.client.api.Timestamp;
import cfca.sadk.timestamp.client.api.TimestampClient;
import cfca.sadk.timestamp.client.api.TimestampConfig;
import cfca.sadk.timestamp.client.bean.HashAlgorithm;
import cfca.sadk.timestamp.client.bean.MessageImprint;
import cfca.sadk.timestamp.client.bean.TSARequestPolicy;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.timestamp.exception.TSAHttpStatusInfoException;
import cfca.sadk.timestamp.exception.TSAPkixStatusInfoException;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import javax.net.ssl.SSLContext;

final class StandardTimestampClient
implements TimestampClient {
    private static final Logger logger = LoggerFactory.getLogger(StandardTimestampClient.class);
    private static final int bufferSize = 16384;
    private final BusinessTrustCerts trustCerts;
    private TSARequestPolicy timestampMode = TSARequestPolicy.HTTP_AUTH;
    private boolean requiredNonceOptional = true;
    private boolean requiredCertOptional = true;
    private HTTPRequester requester;
    private SSLContext timestampSSL;
    private int httpTimeout;
    private String httpAuthUsername = null;
    private String httpAuthpassword = null;
    private boolean hostnameChecker = true;
    private final byte[] _requestBytes;
    private final byte[] _requestSignedBytes;
    private final byte[] _requestSM2Bytes;
    private final byte[] _requestSM2SignedBytes;
    private X509Cert signCert = null;
    private Session session;
    private boolean verifyTimestamp = true;

    StandardTimestampClient(TimestampConfig config, boolean testRunner) throws TSAException {
        logger.info("StandardTimestampClient instance running...");
        if (config == null) {
            logger.error("StandardTimestampClient missing parameter@timestampConfig");
            throw new TSAException(TSAErrorCode.timestampClientMissingConfig, "required parameter timestampConfig");
        }
        if (logger.isInfoEnabled()) {
            logger.info(config.toString(true));
        }
        try {
            this.trustCerts = new BusinessTrustCerts(config.getBusinessTrustCertPath(), config.getBusinessTrustCRLPath());
        }
        catch (TSAException e) {
            logger.error("StandardTimestampClient@BusinessTrustCerts failure: {}", (Object)config, (Object)e);
            throw e;
        }
        try {
            this.trustCerts.setBusinessSignedCert(config.getBusinessCertPath(), config.getBusinessCertPassword());
        }
        catch (TSAException e) {
            logger.error("StandardTimestampClient@setBusinessSignedCert failure: {}", (Object)config, (Object)e);
            throw e;
        }
        try {
            SSLContextManager manager = SSLContextManager.buildTLSContextManager(config);
            this.timestampSSL = manager.context.getContext();
        }
        catch (TSAException e) {
            logger.error("StandardTimestampClient@buildTLSContextManager failure: {}", (Object)config, (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("StandardTimestampClient@buildTLSContextManager failure: {}", (Object)config, (Object)e);
            throw new TSAException(TSAErrorCode.timestampClientBuildRequestorFailure, "requestor build failure", (Throwable)e);
        }
        String timestampUrl = config.getHttpURL();
        this.httpTimeout = config.getHttpTimeout();
        this.setTimestampHttpAuthInfo(config.getHttpAuthUsername(), config.getHttpAuthPassword());
        this.setTimestampURL(timestampUrl, this.timestampSSL);
        this.setHostnameChecker(config.isHostnameChecker());
        logger.info("StandardTimestampClient instance finished");
        this._requestBytes = this.buildTestRunnerForRequestFixedTimestampBytes(testRunner);
        this._requestSignedBytes = this.buildTestRunnerForSignedRequestFixedTimestampBytes(testRunner);
        this._requestSM2Bytes = this.buildTestRunnerForRequestFixedSM2TimestampBytes(testRunner);
        this._requestSM2SignedBytes = this.buildTestRunnerForSignedRequestFixedSM2TimestampBytes(testRunner);
        this.session = BCSoftLib.INSTANCE();
    }

    public void setHostnameChecker(boolean hostnameChecker) {
        this.hostnameChecker = hostnameChecker;
    }

    @Override
    public void setSignCert(X509Cert signCert) {
        this.signCert = signCert;
    }

    @Override
    public BusinessTrustCerts currentBusinessTrustCerts() throws TSAException {
        return this.trustCerts;
    }

    @Override
    public void setTimestampURL(String timestampURL) throws TSAException {
        this.setTimestampURL(timestampURL, this.timestampSSL);
    }

    @Override
    public void setTimestampURL(String timestampURL, SSLContext timestampSSL) throws TSAException {
        HTTPRequester requester;
        try {
            if (this.startWithHTTPs(timestampURL)) {
                if (timestampSSL == null) {
                    throw new TSAException(TSAErrorCode.serverUrlHTTPSRequireSSLContext, "setTimestampURL required timestampSSL for " + timestampURL);
                }
                requester = HTTPRequester.getHttpsInstance(timestampURL, timestampSSL);
            } else {
                requester = HTTPRequester.getHttpInstance(timestampURL);
            }
            requester.setUsername(this.httpAuthUsername);
            requester.setPassword(this.httpAuthpassword);
        }
        catch (TSAException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timestampClientBuildRequestorFailure, "requestor build failure", (Throwable)e);
        }
        this.requester = requester;
    }

    @Override
    public void setTimestampHttpAuthInfo(String username, String password) throws TSAException {
        this.httpAuthUsername = username;
        this.httpAuthpassword = password;
        if (this.requester != null) {
            this.requester.setUsername(this.httpAuthUsername);
            this.requester.setPassword(this.httpAuthpassword);
        }
    }

    @Override
    public void setTimestampMode(TSARequestPolicy timestampMode) throws TSAException {
        logger.info("StandardTimestampClient@setTimestameMode running: {}", (Object)timestampMode);
        if (timestampMode == null) {
            logger.error("StandardTimestampClient@setTimestameMode missing parameter@timestampConfig");
            throw new TSAException(TSAErrorCode.timestampClientMissingPolicyMode, "required parameter timestampMode");
        }
        this.timestampMode = timestampMode;
        logger.info("StandardTimestampClient@setTimestameMode finished: {}", (Object)timestampMode);
    }

    @Override
    public Timestamp requestTimestamp(HashAlgorithm hashAlgorithm, byte[] sourceMessage) throws TSAPkixStatusInfoException, TSAException {
        return this.requestTimestamp(this.httpTimeout, hashAlgorithm, sourceMessage);
    }

    @Override
    public Timestamp requestTimestamp(HashAlgorithm hashAlgorithm, InputStream sourceInputStream) throws TSAPkixStatusInfoException, TSAException {
        return this.requestTimestamp(this.httpTimeout, hashAlgorithm, sourceInputStream);
    }

    @Override
    public Timestamp requestTimestamp(MessageImprint messageImprint) throws TSAPkixStatusInfoException, TSAException {
        return this.requestTimestamp(this.httpTimeout, messageImprint);
    }

    @Override
    public Timestamp requestTimestamp(int timeout, HashAlgorithm hashAlgorithm, byte[] sourceMessage) throws TSAPkixStatusInfoException, TSAException {
        MessageImprint messageImprint;
        logger.debug("StandardTimestampClient@requestTimestamp running: {}", (Object)hashAlgorithm);
        if (hashAlgorithm == null) {
            logger.error("StandardTimestampClient@requestTimestamp missing parameter@hashAlgorithm: {}", (Object)hashAlgorithm);
            throw new TSAException(TSAErrorCode.timestampClientMissingHashAlgorithm, "required parameter hashAlgorithm");
        }
        if (sourceMessage == null) {
            logger.error("StandardTimestampClient@requestTimestamp missing parameter@sourceMessage: {}", (Object)hashAlgorithm);
            throw new TSAException(TSAErrorCode.timestampClientMissingSourceMessage, "required parameter sourceMessage");
        }
        try {
            messageImprint = this.buildMessageImprint(hashAlgorithm, sourceMessage, null);
        }
        catch (TSAException e) {
            logger.error("StandardTimestampClient@requestTimestamp buildMessageImprint failure: {}", (Object)hashAlgorithm, (Object)e);
            throw e;
        }
        return this.generateTimestamp(timeout, messageImprint);
    }

    @Override
    public Timestamp requestTimestamp(int timeout, HashAlgorithm hashAlgorithm, InputStream sourceInputStream) throws TSAPkixStatusInfoException, TSAException {
        MessageImprint messageImprint;
        logger.debug("StandardTimestampClient@requestTimestamp running: {}", (Object)hashAlgorithm);
        if (hashAlgorithm == null) {
            logger.error("StandardTimestampClient@requestTimestamp missing parameter@hashAlgorithm: {}", (Object)hashAlgorithm);
            throw new TSAException(TSAErrorCode.timestampClientMissingHashAlgorithm, "required parameter hashAlgorithm");
        }
        if (sourceInputStream == null) {
            logger.error("StandardTimestampClient@requestTimestamp missing parameter@sourceInputStream: {}", (Object)hashAlgorithm);
            throw new TSAException(TSAErrorCode.timestampClientMissingSourceStream, "required parameter sourceInputStream");
        }
        try {
            messageImprint = this.buildMessageImprint(hashAlgorithm, null, sourceInputStream);
        }
        catch (TSAException e) {
            logger.error("StandardTimestampClient@requestTimestamp buildMessageImprint failure: {}", (Object)hashAlgorithm, (Object)e);
            throw e;
        }
        return this.generateTimestamp(timeout, messageImprint);
    }

    @Override
    public Timestamp requestTimestamp(int timeout, MessageImprint messageImprint) throws TSAPkixStatusInfoException, TSAException {
        logger.debug("StandardTimestampClient@requestTimestamp running: {}", (Object)messageImprint);
        if (messageImprint == null) {
            logger.error("StandardTimestampClient@requestTimestamp missing parameter@messageImprint: {}", (Object)messageImprint);
            throw new TSAException(TSAErrorCode.timestampClientMissingMessageImprint, "required parameter messageImprint");
        }
        if (messageImprint.getHashAlgorithm() == null) {
            logger.error("StandardTimestampClient@requestTimestamp messageImprint required hashAlgorithm: {}", (Object)messageImprint);
            throw new TSAException(TSAErrorCode.timestampClientMessageImprintMissingAlgorithm, "messageImprint required hashAlgorithm");
        }
        if (messageImprint.getHashedMessage() == null) {
            logger.error("StandardTimestampClient@requestTimestamp messageImprint required hashedMessage: {}", (Object)messageImprint);
            throw new TSAException(TSAErrorCode.timestampClientMessageImprintMissingHashedMessage, "messageImprint required hashedMessage");
        }
        if (messageImprint.getHashedMessage().length != messageImprint.getHashAlgorithm().hashLength) {
            logger.error("StandardTimestampClient@requestTimestamp messageImprint invalid: {}", (Object)messageImprint);
            throw new TSAException(TSAErrorCode.timestampClientMessageImprintInvalid, "messageImprint invalid");
        }
        return this.generateTimestamp(timeout, messageImprint);
    }

    private final Timestamp generateTimestamp(int timeout, MessageImprint messageImprint) throws TSAHttpStatusInfoException, TSAPkixStatusInfoException, TSAException {
        TSASignedData signedData;
        byte[] responseBytes;
        byte[] requestBytes;
        BigInteger nonceRequest;
        logger.debug("StandardTimestampClient@generateTimestamp running...{}", (Object)messageImprint);
        BigInteger bigInteger = nonceRequest = this.requiredNonceOptional ? TimestampNonce.randomUUID() : null;
        if (this.requester == null) {
            logger.error("StandardTimestampClient@generateTimestamp requester not setting");
            throw new TSAException(TSAErrorCode.timestampClientRequesterNotSetting, "required requester");
        }
        try {
            requestBytes = this.buildTimestampRequest(messageImprint, nonceRequest);
        }
        catch (TSAException e) {
            logger.error("StandardTimestampClient@generateTimestamp buildTimestampRequest failure: {}", (Object)messageImprint, (Object)e);
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("StandardTimestampClient@generateTimestamp nonce={}, requestBytes: {}", (Object)nonceRequest, (Object)Base64.toBase64String((byte[])requestBytes));
        }
        try {
            responseBytes = this.requester.sendRequest(requestBytes, timeout, this.hostnameChecker);
        }
        catch (TSAHttpStatusInfoException e) {
            logger.error("StandardTimestampClient@generateTimestamp sendRequest failure: {}", (Object)messageImprint, (Object)e);
            throw e;
        }
        catch (TSAException e) {
            logger.error("StandardTimestampClient@generateTimestamp sendRequest failure: {}", (Object)messageImprint, (Object)e);
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("StandardTimestampClient@generateTimestamp nonce={}, responseBytes: {}", (Object)nonceRequest, (Object)Base64.toBase64String((byte[])responseBytes));
        }
        try {
            signedData = new TSASignedData(requestBytes, responseBytes, this.requiredCertOptional, this.signCert);
        }
        catch (TSAException e) {
            logger.error("StandardTimestampClient@generateTimestamp invalid response: {}", (Object)Base64.toBase64String((byte[])responseBytes), (Object)e);
            throw e;
        }
        BigInteger nonceResponse = signedData.getNonce();
        if (nonceRequest != null) {
            if (nonceResponse == null) {
                logger.error("StandardTimestampClient@generateTimestamp response without nonce");
                throw new TSAException(TSAErrorCode.timestampClientResponseNonceMissing, "TSASignedData@nonce missing");
            }
            if (!nonceRequest.equals(nonceResponse)) {
                logger.error("StandardTimestampClient@generateTimestamp response with invalid nonce");
                throw new TSAException(TSAErrorCode.timestampClientResponseNonceInvalid, String.format("TSASignedData@nonce not match with request %s<-->%s", nonceRequest, nonceResponse));
            }
        }
        String OID_RSP = signedData.getPolicyID();
        switch (this.timestampMode) {
            case SIGN_AUTH: 
            case HTTP_AUTH: 
            case TEST_OID: {
                if (OID_RSP == null) {
                    logger.error("StandardTimestampClient@generateTimestamp response without policyId");
                    throw new TSAException(TSAErrorCode.timestampClientResponseNonceMissing, "TSASignedData@policyId missing");
                }
                if (this.timestampMode.OID.equals(OID_RSP)) break;
                logger.error("StandardTimestampClient@generateTimestamp response invalid policyId");
                throw new TSAException(TSAErrorCode.timestampClientResponsePolicyIdInvalid, String.format("TSASignedData@nonce not match with request %s<-->%s", nonceRequest, nonceResponse));
            }
        }
        MessageImprint messageImprintResponse = signedData.getMessageImprint();
        if (messageImprintResponse == null) {
            logger.error("StandardTimestampClient@generateTimestamp response without messageImprint");
            throw new TSAException(TSAErrorCode.timestampClientResponseMessageImprintMissing, "TSASignedData@messageImprint missing");
        }
        if (!messageImprintResponse.equals(messageImprint)) {
            logger.error("StandardTimestampClient@generateTimestamp response with invalid messageImprint");
            throw new TSAException(TSAErrorCode.timestampClientResponseMessageImprintInvalid, "TSASignedData@messageImprint invalid");
        }
        if (this.verifyTimestamp && (this.requiredCertOptional || this.signCert != null)) {
            boolean verifySignature;
            try {
                verifySignature = signedData.verifySignedData(this.trustCerts, this.session);
            }
            catch (TSAException e) {
                logger.error("StandardTimestampClient@generateTimestamp check signedData/signedCert failure", (Throwable)e);
                throw e;
            }
            if (!verifySignature) {
                logger.error("StandardTimestampClient@generateTimestamp response with invalid signedDataOrSignedCert");
                throw new TSAException(TSAErrorCode.timestampClientResponseSignedDataOrSignedCertInvalid, "TSASignedData@signedData/signedCert invalid");
            }
        }
        Timestamp timestamp = signedData.getTimeStamp();
        return timestamp;
    }

    private final byte[] buildTimestampRequest(MessageImprint messageImprint, BigInteger nonce) throws TSAException {
        byte[] timeStampReqBytes = null;
        try {
            ASN1ObjectIdentifier asn1ReqTSAPolicyId;
            ASN1Integer nonceValue = nonce == null ? null : new ASN1Integer(nonce);
            ASN1Boolean asn1CertReq = ASN1Boolean.getInstance((boolean)this.requiredCertOptional);
            AlgorithmIdentifier oid = new AlgorithmIdentifier(new ASN1ObjectIdentifier(messageImprint.getHashAlgorithm().oid), (ASN1Encodable)DERNull.INSTANCE);
            cfca.sadk.org.bouncycastle.asn1.tsp.MessageImprint mssageImprint = new cfca.sadk.org.bouncycastle.asn1.tsp.MessageImprint(oid, messageImprint.getHashedMessage());
            Extensions extensions = null;
            switch (this.timestampMode) {
                case SIGN_AUTH: {
                    asn1ReqTSAPolicyId = new ASN1ObjectIdentifier(this.timestampMode.OID);
                    byte[] signedData = this.trustCerts.signedP7Detach(mssageImprint, nonceValue);
                    Extension extension = new Extension(asn1ReqTSAPolicyId, true, (ASN1OctetString)new DEROctetString(signedData));
                    extensions = new Extensions(extension);
                    break;
                }
                case HTTP_AUTH: {
                    asn1ReqTSAPolicyId = new ASN1ObjectIdentifier(this.timestampMode.OID);
                    break;
                }
                case TEST_OID: {
                    asn1ReqTSAPolicyId = new ASN1ObjectIdentifier(this.timestampMode.OID);
                    break;
                }
                default: {
                    asn1ReqTSAPolicyId = null;
                }
            }
            TimeStampReq timeStampReq = new TimeStampReq(mssageImprint, asn1ReqTSAPolicyId, nonceValue, asn1CertReq, extensions);
            timeStampReqBytes = timeStampReq.getEncoded();
        }
        catch (TSAException e) {
            throw e;
        }
        catch (IOException e) {
            throw new TSAException(TSAErrorCode.timestampClientRequestMessageBuildFailure, String.format("nonce=%s %s", nonce, messageImprint), (Throwable)e);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timestampClientRequestMessageBuildFailure, String.format("nonce=%s %s", nonce, messageImprint), (Throwable)e);
        }
        return timeStampReqBytes;
    }

    private final MessageImprint buildMessageImprint(HashAlgorithm hashAlgorithm, byte[] sourceMessage, InputStream sourceStream) throws TSAException {
        SM3Digest digest;
        switch (hashAlgorithm) {
            case SM3: {
                digest = new SM3Digest();
                break;
            }
            case SHA1: {
                digest = new SHA1Digest();
                break;
            }
            case SHA256: {
                digest = new SHA256Digest();
                break;
            }
            case SHA512: {
                digest = new SHA512Digest();
                break;
            }
            case MD5TEST: {
                digest = new MD5Digest();
                break;
            }
            default: {
                throw new TSAException(TSAErrorCode.timestampClientMessageImprintInvalidHashAlgorithm, "hashAlgorithm invalid: " + (Object)((Object)hashAlgorithm));
            }
        }
        if (sourceMessage != null) {
            digest.update(sourceMessage, 0, sourceMessage.length);
        } else if (sourceStream != null) {
            try {
                byte[] buffer = new byte[16384];
                int readLength = 0;
                while ((readLength = sourceStream.read(buffer)) > 0) {
                    digest.update(buffer, 0, readLength);
                }
            }
            catch (Exception e) {
                throw new TSAException(TSAErrorCode.timestampClientMessageImprintBuildFailure, "update failure: " + (Object)((Object)hashAlgorithm), (Throwable)e);
            }
        } else {
            throw new TSAException(TSAErrorCode.timestampClientMessageImprintMissingSourceData, "hashAlgorithm invalid: " + (Object)((Object)hashAlgorithm));
        }
        byte[] hashedMessage = new byte[digest.getDigestSize()];
        try {
            digest.doFinal(hashedMessage, 0);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timestampClientMessageImprintBuildFailure, "doFinal failure: " + (Object)((Object)hashAlgorithm), (Throwable)e);
        }
        MessageImprint messageImprint = new MessageImprint(hashAlgorithm, hashedMessage);
        return messageImprint;
    }

    private final boolean startWithHTTPs(String timestampUrl) {
        return timestampUrl != null && timestampUrl.trim().toLowerCase().startsWith("https://");
    }

    @Override
    public byte[] testRunner(boolean signed, boolean smx) throws TSAHttpStatusInfoException, TSAException {
        byte[] requestBytes = signed ? (smx ? (byte[])this._requestSM2SignedBytes.clone() : (byte[])this._requestSignedBytes.clone()) : (smx ? (byte[])this._requestSM2Bytes.clone() : (byte[])this._requestBytes.clone());
        byte[] responseBytes = this.requester.sendRequest(requestBytes, this.httpTimeout, false);
        return responseBytes;
    }

    @Override
    public void testRequiredNonceOptional(boolean requiredNonceOptional) {
        this.requiredNonceOptional = requiredNonceOptional;
    }

    @Override
    public void testRequiredCertOptional(boolean requiredCertOptional) {
        this.requiredCertOptional = requiredCertOptional;
    }

    private final byte[] buildTestRunnerForRequestFixedTimestampBytes(boolean testRunnerForRequestFixedTimestamp) {
        byte[] testRunnerForSignedRequestFixedTimestampBytes = null;
        if (testRunnerForRequestFixedTimestamp) {
            String testRunnerForRequestFixedTimestampBytes = "MGoCAQEwTzALBglghkgBZQMEAgMEQHv6laaIkkxHx9IjgfIMySb1JL6ssT+E4gPUvYy2ui/OgcV6XwWb89UJkmSHvekls7zuBjXk97rroFTl26aWsr8GCSsGAQQB8GFkAQIGIBYSIRUYAQH/";
            testRunnerForSignedRequestFixedTimestampBytes = Base64.decode((String)testRunnerForRequestFixedTimestampBytes);
        } else {
            testRunnerForSignedRequestFixedTimestampBytes = new byte[20];
        }
        return testRunnerForSignedRequestFixedTimestampBytes;
    }

    private final byte[] buildTestRunnerForRequestFixedSM2TimestampBytes(boolean testRunnerForRequestFixedTimestamp) {
        byte[] testRunnerForSignedRequestFixedTimestampBytes = null;
        if (testRunnerForRequestFixedTimestamp) {
            String testRunnerForRequestFixedTimestampBytes = "MEsCAQEwLjAKBggqgRzPVQGDEQQgoLfHxySREo4UU5F8iN4qZNKd5wHxQuJcYKtmJP6pY54GCSsGAQQB8GFkAQIIvnUwnzHOPqsBAf8=";
            testRunnerForSignedRequestFixedTimestampBytes = Base64.decode((String)testRunnerForRequestFixedTimestampBytes);
        } else {
            testRunnerForSignedRequestFixedTimestampBytes = new byte[20];
        }
        return testRunnerForSignedRequestFixedTimestampBytes;
    }

    private final byte[] buildTestRunnerForSignedRequestFixedTimestampBytes(boolean testRunnerForRequestFixedTimestamp) {
        byte[] testRunnerForSignedRequestFixedTimestampBytes = null;
        if (testRunnerForRequestFixedTimestamp) {
            String testRunnerForRequestFixedTimestampBytes = "MIIFlwIBATBPMAsGCWCGSAFlAwQCAwRAe/qVpoiSTEfH0iOB8gzJJvUkvqyxP4TiA9S9jLa6L86BxXpfBZvz1QmSZIe96SWzvO4GNeT3uuugVOXbppayvwYJKwYBBAHwYWQCAgYgFhIhFRgBAf+gggUpMIIFJQYJKwYBBAHwYWQCAQH/BIIFEzCCBQ8GCSqGSIb3DQEHAqCCBQAwggT8AgEBMQ8wDQYJYIZIAWUDBAIBBQAwCwYJKoZIhvcNAQcBoIIDdzCCA3MwggJboAMCAQICAQQwDQYJKoZIhvcNAQENBQAwLDEOMAwGA1UEAwwFVFNBQ0ExDTALBgNVBAoMBENGQ0ExCzAJBgNVBAYTAkNOMCAXDTE2MTIxNTAyMzE1N1oYDzIwNTYxMjE1MDIzMTU3WjBvMS0wKwYDVQQDDCRDRkNBIFRJTUVTVEFNUDQwIFJTQTIwNDggQ0xJRU5UIFRFU1QxIjAgBgkqhkiG9w0BCQEWE3FhemhhbmdAY2ZjYS5jb20uY24xDTALBgNVBAoMBENGQ0ExCzAJBgNVBAYTAkFVMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArb/otxe1qPDuMiIOX3LSVLmYO9NuqKtS6Om+DvgzcNAIdU8GEdjJhv6xSoYUuHmleS1Scr79hk77kj9wsDhAW6RcKEbk3hGlMf1cEAe5Rk0l4rxsbpLxEoCUlmv6BRc1ZxhbNBk0CrqDHlSdRCg1Gd0MKcEb85W+4FI7X71tIiKiYPJ4AnqIgaCqLLbGVjv7A99HYK8g1l94UDdyYv0dECEh+8XgOf8q6OgHacQDTpeNl9qlTkWbXBwPch3Djgtm1YkNSLllLnrTeMtG9ugtvt3HDhAaGf8KfJ70X3IVmEL3G+cUEg5H2a/z23+oGOO8vUX+qumFSAfKt4+1/FWJKwIDAQABo1swWTAdBgNVHQ4EFgQUCGxFQAx26vYb+pbs2Gve1n+wd/4wHwYDVR0jBBgwFoAU+7bgBBOFOWkcCUvjX55iyy10tvswFwYDVR0lAQH/BA0wCwYJKwYBBAHwYWQCMA0GCSqGSIb3DQEBDQUAA4IBAQA5ymvWTceTpL1gSLOxrdgR/E6xj8KpsDMDO0mvD+IApO3+pn3YBZvFDpNNVz9/z4/BXhj3li2kRqaiILuTTaUKe9ftoYeaPoMj9t2Gc6mhSXEIaUcmfEYnhE8FD1G+xz2lnZOgKom5/9Coz05evUmfC0allql7xqoPhR/lA4GYkyWtaMjI8EqSW8qJli8Gaz9tXb4vnEjWKm4+HKizL5UceGwUgjlP+4JRFF7/Wnkzr7F8SVDhvQNvNmtBqN+r7QzjNzMwvkSnvP+8tIvF6zJ4vuVVy5P0D1B6Z7Z4LB76xFQimoKbDwTBZmnhVoOny+QRtEHUCEjcu69i+t/O15JbMYIBXDCCAVgCAQEwMTAsMQ4wDAYDVQQDDAVUU0FDQTENMAsGA1UECgwEQ0ZDQTELMAkGA1UEBhMCQ04CAQQwDQYJYIZIAWUDBAIBBQAwDQYJKoZIhvcNAQEBBQAEggEAFTHBLjKRhvdEtJP4dO20m7oginymDOUpD89WdxzziokscLExUK3XPGbHyWZSVL++pTWsHoQ+Eoy0vVOXBWY9ybj4xinFt2CPNQ74v6/XPRBf6huFR/1yOTfl7NLzYb6ojqVXG4+uWnZ/ffyLKTCFxcNTS2oW55dwlWbUb12ytU/FseTOu0RmBv9Ty/hzi7H2Sh01R5KC6mWaFRF1L0pOfKzBiR77jsiCWcO74f0pY1QEmyhrd0LMIEyHlnmZmRynPQY9M8g+nzPg9fnStbjfzkS5YPdjRnfzkF4M9Wq1tr14pf+8KOedsRL13/xVaLVh469WCDst5Sc55agJWS8xLQ==";
            testRunnerForSignedRequestFixedTimestampBytes = Base64.decode((String)testRunnerForRequestFixedTimestampBytes);
        } else {
            testRunnerForSignedRequestFixedTimestampBytes = new byte[20];
        }
        return testRunnerForSignedRequestFixedTimestampBytes;
    }

    private final byte[] buildTestRunnerForSignedRequestFixedSM2TimestampBytes(boolean testRunnerForRequestFixedTimestamp) {
        byte[] testRunnerForSignedRequestFixedTimestampBytes = null;
        if (testRunnerForRequestFixedTimestamp) {
            String testRunnerForRequestFixedTimestampBytes = "MIIFeAIBATAuMAoGCCqBHM9VAYMRBCCgt8fHJJESjhRTkXyI3ipk0p3nAfFC4lxgq2Yk/qljngYJKwYBBAHwYWQCAgiNM/wEhysDqwEB/6CCBSkwggUlBgkrBgEEAfBhZAIBAf8EggUTMIIFDwYJKoZIhvcNAQcCoIIFADCCBPwCAQExDzANBglghkgBZQMEAgEFADALBgkqhkiG9w0BBwGgggN3MIIDczCCAlugAwIBAgIBBDANBgkqhkiG9w0BAQ0FADAsMQ4wDAYDVQQDDAVUU0FDQTENMAsGA1UECgwEQ0ZDQTELMAkGA1UEBhMCQ04wIBcNMTYxMjE1MDIzMTU3WhgPMjA1NjEyMTUwMjMxNTdaMG8xLTArBgNVBAMMJENGQ0EgVElNRVNUQU1QNDAgUlNBMjA0OCBDTElFTlQgVEVTVDEiMCAGCSqGSIb3DQEJARYTcWF6aGFuZ0BjZmNhLmNvbS5jbjENMAsGA1UECgwEQ0ZDQTELMAkGA1UEBhMCQVUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCtv+i3F7Wo8O4yIg5fctJUuZg7026oq1Lo6b4O+DNw0Ah1TwYR2MmG/rFKhhS4eaV5LVJyvv2GTvuSP3CwOEBbpFwoRuTeEaUx/VwQB7lGTSXivGxukvESgJSWa/oFFzVnGFs0GTQKuoMeVJ1EKDUZ3QwpwRvzlb7gUjtfvW0iIqJg8ngCeoiBoKostsZWO/sD30dgryDWX3hQN3Ji/R0QISH7xeA5/yro6AdpxANOl42X2qVORZtcHA9yHcOOC2bViQ1IuWUuetN4y0b26C2+3ccOEBoZ/wp8nvRfchWYQvcb5xQSDkfZr/Pbf6gY47y9Rf6q6YVIB8q3j7X8VYkrAgMBAAGjWzBZMB0GA1UdDgQWBBQIbEVADHbq9hv6luzYa97Wf7B3/jAfBgNVHSMEGDAWgBT7tuAEE4U5aRwJS+NfnmLLLXS2+zAXBgNVHSUBAf8EDTALBgkrBgEEAfBhZAIwDQYJKoZIhvcNAQENBQADggEBADnKa9ZNx5OkvWBIs7Gt2BH8TrGPwqmwMwM7Sa8P4gCk7f6mfdgFm8UOk01XP3/Pj8FeGPeWLaRGpqIgu5NNpQp71+2hh5o+gyP23YZzqaFJcQhpRyZ8RieETwUPUb7HPaWdk6Aqibn/0KjPTl69SZ8LRqWWqXvGqg+FH+UDgZiTJa1oyMjwSpJbyomWLwZrP21dvi+cSNYqbj4cqLMvlRx4bBSCOU/7glEUXv9aeTOvsXxJUOG9A282a0Go36vtDOM3MzC+RKe8/7y0i8XrMni+5VXLk/QPUHpntngsHvrEVCKagpsPBMFmaeFWg6fL5BG0QdQISNy7r2L6387XklsxggFcMIIBWAIBATAxMCwxDjAMBgNVBAMMBVRTQUNBMQ0wCwYDVQQKDARDRkNBMQswCQYDVQQGEwJDTgIBBDANBglghkgBZQMEAgEFADANBgkqhkiG9w0BAQEFAASCAQAvaY9TeTy2YxpGBkqm5ccFbtD9BeydxmSsDpGQ4wLzjvlKTRnf86pbcybPOFj/1kkpulADJPWgz3YSzeRtib9tkNwHk8Ft9Hcuquj04SWdskGVzTTDXuQ/G8oYANYEzJMAqOc5eLz7Lo5oUo/mv7onpGyXXBEefGvSKJpMGo3ja8G6HReM65AtBT8vLKASd3kBwa436PKpQpoxwQZotHbMeqiorx1Lb4Qc5Wy7czcl8ODMGmm5vYENw82nOM0SuCNJf4EqEo2ZEpnG7szv3Gm5/PwGP98uIOcgRFXBkV7kNOmAWZ7/4dvkayfcil5nIOKBBulHXyrvZTY5E27/lEqK";
            testRunnerForSignedRequestFixedTimestampBytes = Base64.decode((String)testRunnerForRequestFixedTimestampBytes);
        } else {
            testRunnerForSignedRequestFixedTimestampBytes = new byte[20];
        }
        return testRunnerForSignedRequestFixedTimestampBytes;
    }

    @Override
    public void setSession(Session session) {
        this.session = session == null ? BCSoftLib.INSTANCE() : session;
    }

    @Override
    public void setTimestampVerify(boolean verify) {
        this.verifyTimestamp = verify;
    }
}

