/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.paperless.util;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.cms.Attribute;
import cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.KeyPurposeId;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cms.CMSException;
import cfca.sadk.org.bouncycastle.cms.CMSSignedData;
import cfca.sadk.org.bouncycastle.cms.SignerId;
import cfca.sadk.org.bouncycastle.tsp.TSPException;
import cfca.sadk.org.bouncycastle.tsp.TSPValidationException;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import cfca.sadk.org.bouncycastle.tsp.TimeStampTokenInfo;
import cfca.sadk.org.bouncycastle.util.Selector;
import cfca.sadk.org.bouncycastle.util.Store;
import cfca.sadk.paperless.PaperlessException;
import cfca.sadk.paperless.system.PaperlessEnvironments;
import cfca.sadk.paperless.system.PaperlessLogger;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;

public final class PaperlessP7Util {
    private static final long LOGGING_WARN_THRESHOLD_TIME = 2000L;
    private static final char BASE64_P7_START_WITH_CHAR = 'M';
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSZ";
    private static final ASN1ObjectIdentifier OID_ATTR_TIMESTAMP = PKCSObjectIdentifiers.id_aa_signatureTimeStampToken;
    private TimeStampToken timestampToken = null;
    private Date tsaDate = null;
    private X509Cert tsaCert = null;
    private final ReentrantLock reentrantLock = new ReentrantLock();

    private PaperlessP7Util(byte[] pkcs7DataWithTimestamp) throws PaperlessException {
        this.parseP7WithTimeStamp(pkcs7DataWithTimestamp);
    }

    public static final PaperlessP7Util getInstance(byte[] pkcs7DataWithTimestamp) throws PaperlessException {
        PaperlessEnvironments.getInstance();
        return new PaperlessP7Util(pkcs7DataWithTimestamp);
    }

    private final void parseP7WithTimeStamp(byte[] pkcs7DataWithTimestamp) throws PaperlessException {
        PaperlessLogger.SYSTEM_LOGGER.info("P7/TIMESTAMP Parse running");
        long strTime = System.currentTimeMillis();
        if (PaperlessLogger.DEBUG_LOGGER.isDebugEnabled()) {
            String paramP7Data = PaperlessLogger.dump(pkcs7DataWithTimestamp);
            PaperlessLogger.DEBUG_LOGGER.debug("PaperlessP7Util Running: pkcs7DataWithTimestamp={}", (Object)paramP7Data);
        }
        PaperlessException paperlessException = null;
        try {
            byte[] asn1P7WithTimestamp = this.decodeBase64(pkcs7DataWithTimestamp);
            ASN1Encodable attributeToken = this.parseTimestampToken(asn1P7WithTimestamp);
            this.timestampToken = this.parseToken(attributeToken);
        }
        catch (PaperlessException e) {
            paperlessException = e;
            throw e;
        }
        catch (Exception e) {
            paperlessException = new PaperlessException(e);
            throw paperlessException;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long runTime = endTime - strTime;
            if (paperlessException == null) {
                if (runTime > 2000L) {
                    PaperlessLogger.EXCEPTION_LOGGER.error("P7/TIMESTAMP Parse finished: longTime={}ms, ", (Object)runTime);
                } else {
                    PaperlessLogger.SYSTEM_LOGGER.info("P7/TIMESTAMP Parse finished: runtime={}ms", (Object)runTime);
                }
            } else {
                PaperlessLogger.EXCEPTION_LOGGER.error("P7/TIMESTAMP Parse failure: longTime={}ms, ", (Object)runTime);
                if (PaperlessLogger.EXCEPTION_LOGGER.isErrorEnabled()) {
                    String paramP7Data = PaperlessLogger.dump(pkcs7DataWithTimestamp);
                    PaperlessLogger.EXCEPTION_LOGGER.error("PaperlessP7Util Failed: pkcs7DataWithTimestamp={}", (Object)paramP7Data, (Object)paperlessException);
                }
            }
        }
    }

    private final byte[] decodeBase64(byte[] pkcs7DataWithTimestamp) throws PaperlessException {
        if (pkcs7DataWithTimestamp == null) {
            throw new PaperlessException("pkcs7DataWithTimestamp should not be null");
        }
        if (pkcs7DataWithTimestamp.length < 1) {
            throw new PaperlessException("pkcs7DataWithTimestamp should not be less one");
        }
        byte[] asn1Coding = null;
        if (pkcs7DataWithTimestamp[0] == 77) {
            try {
                asn1Coding = Base64.decode((byte[])pkcs7DataWithTimestamp);
            }
            catch (Exception e) {
                throw new PaperlessException("pkcs7DataWithTimestamp base64 decoding failure", e);
            }
        } else {
            asn1Coding = pkcs7DataWithTimestamp;
        }
        return asn1Coding;
    }

    private final ASN1Encodable parseTimestampToken(byte[] asn1P7WithTimestamp) throws PaperlessException {
        ASN1Encodable attributeToken = null;
        try {
            ContentInfo contentInfo = ContentInfo.getInstance((Object)asn1P7WithTimestamp);
            SignedData sd = null;
            sd = SignedData.getInstance((Object)contentInfo.getContent());
            ASN1Set signers = sd.getSignerInfos();
            SignerInfo signerInfo = SignerInfo.getInstance((Object)signers.getObjectAt(0));
            AttributeTable unsignedAttributes = null;
            Attribute tsaAttribute = null;
            ASN1Encodable[] attributeValues = null;
            ASN1Set unauthenticatedAttributes = signerInfo.getUnauthenticatedAttributes();
            if (unauthenticatedAttributes == null) {
                throw new PaperlessException("missing timestampToken in signerInfo");
            }
            unsignedAttributes = new AttributeTable(unauthenticatedAttributes);
            if (unsignedAttributes != null && (tsaAttribute = unsignedAttributes.get(OID_ATTR_TIMESTAMP)) != null && (attributeValues = tsaAttribute.getAttributeValues()) != null && attributeValues.length > 0 && attributeValues[0] != null) {
                attributeToken = attributeValues[0];
            }
        }
        catch (PaperlessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PaperlessException("parseTimestampAttribute decode failed", e);
        }
        return attributeToken;
    }

    private final TimeStampToken parseToken(ASN1Encodable tokenEncodable) throws PaperlessException {
        CMSSignedData signedData;
        ContentInfo tokenContentInfo = ContentInfo.getInstance((Object)tokenEncodable);
        try {
            signedData = new CMSSignedData(tokenContentInfo);
        }
        catch (CMSException e) {
            throw new PaperlessException("invalid tokenContentInfo", e);
        }
        TimeStampToken timeStampToken = null;
        try {
            timeStampToken = new TimeStampToken(signedData);
        }
        catch (TSPValidationException e) {
            throw new PaperlessException("invalid timeStampToken", e);
        }
        catch (TSPException e) {
            throw new PaperlessException("invalid timeStampToken", e);
        }
        catch (Exception e) {
            throw new PaperlessException("invalid timeStampToken", e);
        }
        return timeStampToken;
    }

    private final Date parseTime(TimeStampToken timeStampToken) throws PaperlessException {
        TimeStampTokenInfo tokenInfo;
        Date genTime = null;
        if (timeStampToken != null && (tokenInfo = timeStampToken.getTimeStampInfo()) != null) {
            genTime = tokenInfo.getGenTime();
        }
        return genTime;
    }

    private final X509Cert parseCert(TimeStampToken timeStampToken) throws PaperlessException {
        X509Cert tsaCert = null;
        if (timeStampToken != null) {
            Collection collection;
            try {
                SignerId selector = timeStampToken.getSID();
                Store store = timeStampToken.getCertificates();
                collection = store.getMatches((Selector)selector);
            }
            catch (Exception e) {
                throw new PaperlessException("signedCert selector failure", e);
            }
            if (collection != null) {
                Iterator iterator = collection.iterator();
                X509CertificateHolder certHolder = null;
                while (iterator.hasNext()) {
                    try {
                        boolean hasTimestampExtendedKeyUsage;
                        certHolder = (X509CertificateHolder)iterator.next();
                        if (certHolder == null || !(hasTimestampExtendedKeyUsage = this.hasTimestampExtendedKeyUsage(certHolder))) continue;
                        tsaCert = new X509Cert(certHolder.getEncoded());
                        break;
                    }
                    catch (PKIException e) {
                        throw new PaperlessException("signedCert deocde failed", e);
                    }
                    catch (Exception e) {
                        throw new PaperlessException("signedCert deocde failed", e);
                    }
                }
            }
        }
        return tsaCert;
    }

    private final boolean hasTimestampExtendedKeyUsage(X509CertificateHolder certHolder) throws PaperlessException {
        boolean hasTimestampExtendedKeyUsage = false;
        if (certHolder != null) {
            try {
                Extension extension = certHolder.getExtension(Extension.extendedKeyUsage);
                if (extension != null) {
                    ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.getInstance((Object)extension.getParsedValue());
                    hasTimestampExtendedKeyUsage = extendedKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_timeStamping);
                }
            }
            catch (Exception e) {
                throw new PaperlessException("signedCert hasTimestampExtendedKeyUsage failed", e);
            }
        }
        return hasTimestampExtendedKeyUsage;
    }

    public String getTSATime() throws PaperlessException {
        Date tsaDate = this.getTSADate();
        String tsaTimeText = null;
        if (tsaDate != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_FORMAT, Locale.CHINA);
                tsaTimeText = dateFormat.format(tsaDate);
            }
            catch (Exception e) {
                throw new PaperlessException("genTime format failure", e);
            }
        }
        return tsaTimeText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getTSADate() throws PaperlessException {
        block11: {
            PaperlessLogger.SYSTEM_LOGGER.info("Date/Time GET running");
            long strTime = System.currentTimeMillis();
            boolean passed = false;
            try {
                if (this.tsaDate != null) break block11;
                try {
                    this.reentrantLock.lock();
                    if (this.tsaDate == null) {
                        this.tsaDate = this.parseTime(this.timestampToken);
                    }
                    passed = true;
                }
                finally {
                    this.reentrantLock.unlock();
                }
            }
            finally {
                long endTime = System.currentTimeMillis();
                long runTime = endTime - strTime;
                if (passed) {
                    if (runTime > 2000L) {
                        PaperlessLogger.EXCEPTION_LOGGER.error("Date/Time GET OKAY: longTime={}ms", (Object)runTime);
                    } else {
                        PaperlessLogger.SYSTEM_LOGGER.info("Date/Time GET OKAY: runtime={}ms", (Object)runTime);
                    }
                } else {
                    PaperlessLogger.EXCEPTION_LOGGER.error("Date/Time GET FAILED: longTime={}ms", (Object)runTime);
                }
            }
        }
        return this.tsaDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Cert getTSACert() throws PaperlessException {
        block11: {
            PaperlessLogger.SYSTEM_LOGGER.info("CERT GET running");
            long strTime = System.currentTimeMillis();
            boolean passed = false;
            try {
                if (this.tsaCert != null) break block11;
                try {
                    this.reentrantLock.lock();
                    if (this.tsaCert == null) {
                        this.tsaCert = this.parseCert(this.timestampToken);
                    }
                    passed = true;
                }
                finally {
                    this.reentrantLock.unlock();
                }
            }
            finally {
                long endTime = System.currentTimeMillis();
                long runTime = endTime - strTime;
                if (passed) {
                    if (runTime > 2000L) {
                        PaperlessLogger.EXCEPTION_LOGGER.error("CERT GET OKAY: longTime={}ms", (Object)runTime);
                    } else {
                        PaperlessLogger.SYSTEM_LOGGER.info("CERT GET OKAY: runtime={}ms", (Object)runTime);
                    }
                } else {
                    PaperlessLogger.EXCEPTION_LOGGER.error("CERT GET FAILED: longTime={}ms", (Object)runTime);
                }
            }
        }
        return this.tsaCert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTSATimestampToken() throws PaperlessException {
        PaperlessLogger.SYSTEM_LOGGER.info("TIMESTAMP TOKEN GET running");
        long strTime = System.currentTimeMillis();
        boolean passed = false;
        byte[] timestampTokenBytes = null;
        try {
            if (this.timestampToken != null) {
                try {
                    timestampTokenBytes = this.timestampToken.getEncoded();
                }
                catch (IOException e) {
                    throw new PaperlessException("timestampToken getEncoded failure", e);
                }
            }
            passed = true;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long runTime = endTime - strTime;
            if (passed) {
                if (runTime > 2000L) {
                    PaperlessLogger.EXCEPTION_LOGGER.error("TIMESTAMP TOKEN OKAY: longTime={}ms", (Object)runTime);
                } else {
                    PaperlessLogger.SYSTEM_LOGGER.info("TIMESTAMP TOKEN OKAY: runtime={}ms", (Object)runTime);
                }
            } else {
                PaperlessLogger.EXCEPTION_LOGGER.error("TIMESTAMP TOKEN FAILED: longTime={}ms", (Object)runTime);
            }
        }
        return timestampTokenBytes;
    }
}

