/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.paperless.system;

import cfca.sadk.paperless.system.PaperlessLogger;
import cfca.sadk.system.Environments;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public final class PaperlessEnvironments {
    private static final File WARNING_LOG_HOME = new File("/var/log");
    private static final String COMPANY_NAME = "China Financial Certification Authority";
    private static final String PRODUCT_NAME = "Paperless sadk-ext";
    private static final String VERSION = "v3.0.2.1-20191203";
    private static volatile PaperlessEnvironments instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PaperlessEnvironments getInstance() {
        if (instance != null) return instance;
        Class<PaperlessEnvironments> clazz = PaperlessEnvironments.class;
        synchronized (PaperlessEnvironments.class) {
            if (instance != null) return instance;
            try {
                WARNING_LOG_HOME.mkdirs();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            String sadkInfo = null;
            try {
                sadkInfo = Environments.environments().buildEnvironments();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            PaperlessEnvironments env = new PaperlessEnvironments();
            String message = env.buildEnvironments();
            PaperlessLogger.SYSTEM_LOGGER.info(message);
            PaperlessLogger.ENVIRONMENT_LOGGER.info(sadkInfo);
            PaperlessLogger.ENVIRONMENT_LOGGER.info(message);
            instance = env;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    final StringBuilder appendOS(StringBuilder builder) {
        if (builder != null) {
            builder.append("\n");
            builder.append("\n ===================OSx info===================");
            builder.append("\n \u64cd\u4f5c\u7cfb\u7edf\u540d\u79f0: " + System.getProperty("os.name"));
            builder.append("\n \u64cd\u4f5c\u7cfb\u7edf\u67b6\u6784: " + System.getProperty("os.arch"));
            builder.append("\n \u64cd\u4f5c\u7cfb\u7edf\u7248\u672c: " + System.getProperty("os.version"));
            builder.append("\n \u64cd\u4f5c\u7cfb\u7edf\u7528\u6237\u540d: " + System.getProperty("user.name"));
            builder.append("\n user.home: " + System.getProperty("user.home"));
            builder.append("\n user.dir: " + System.getProperty("user.dir"));
            builder.append("\n user.timezone: ").append(System.getProperty("user.timezone"));
            builder.append("\n user.language: ").append(System.getProperty("user.language"));
        }
        return builder;
    }

    final StringBuilder appendJDK(StringBuilder builder) {
        if (builder != null) {
            builder.append("\n");
            builder.append("\n ===================JDK info===================");
            builder.append("\n JDK\u4e3b\u7248\u672c: " + System.getProperty("java.version"));
            builder.append("\n JDK\u4f9b\u5e94\u5546: " + System.getProperty("java.vendor"));
            builder.append("\n JDK\u4e3b\u76ee\u5f55: " + System.getProperty("java.home"));
            builder.append("\n JDK\u7c7b\u8def\u5f84: " + System.getProperty("java.class.path"));
            builder.append("\n JDK\u52a8\u6001\u5e93: " + System.getProperty("java.library.path"));
        }
        return builder;
    }

    final StringBuilder appendJVM(StringBuilder builder) {
        if (builder != null) {
            builder.append("\n");
            builder.append("\n ===================JVM info===================");
            builder.append("\n java.vm.vendor=").append(System.getProperty("java.vm.vendor"));
            builder.append("\n java.vm.name=").append(System.getProperty("java.vm.name"));
            builder.append("\n java.vm.version=").append(System.getProperty("java.vm.version"));
            builder.append("\n java.specification.version=").append(System.getProperty("java.specification.version"));
            builder.append("\n java.home=").append(System.getProperty("java.home"));
            builder.append("\n java.class.path=").append(System.getProperty("java.class.path"));
            builder.append("\n java.class.version=").append(System.getProperty("java.class.version"));
            builder.append("\n java.runtime.name=").append(System.getProperty("java.runtime.name"));
            builder.append("\n java.runtime.version=").append(System.getProperty("java.runtime.version"));
            builder.append("\n java.library.path=").append(System.getProperty("java.library.path"));
            builder.append("\n java.version=").append(System.getProperty("java.version"));
            builder.append("\n sun.arch.data.model=").append(System.getProperty("sun.arch.data.model"));
            builder.append("\n sun.os.patch.level=").append(System.getProperty("sun.os.patch.level"));
            builder.append("\n ");
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            builder.append("\n ===================Runtime info===================");
            builder.append("\n SystemProperties: " + bean.getSystemProperties());
            builder.append("\n Name: " + bean.getName());
            builder.append("\n VmName: " + bean.getVmName());
            builder.append("\n VmVendor: " + bean.getVmVendor());
            builder.append("\n VmVersion: " + bean.getVmVersion());
            builder.append("\n SpecName: " + bean.getSpecName());
            builder.append("\n SpecVendor: " + bean.getSpecVendor());
            builder.append("\n SpecVersion: " + bean.getSpecVersion());
            builder.append("\n BootClassPath: " + bean.getBootClassPath());
            builder.append("\n ClassPath: " + bean.getClassPath());
            builder.append("\n LibraryPath: " + bean.getLibraryPath());
            builder.append("\n InputArguments: " + bean.getInputArguments());
            builder.append("\n JVMTotalMemory: " + (Runtime.getRuntime().totalMemory() >> 20) + "MB");
            builder.append("\n JVMFreeMemory: " + (Runtime.getRuntime().freeMemory() >> 20) + "MB");
            builder.append("\n JVMMaxMemory: " + (Runtime.getRuntime().maxMemory() >> 20) + "MB");
        }
        return builder;
    }

    final StringBuilder appendME(StringBuilder builder) {
        if (builder != null) {
            builder.append("\n");
            builder.append("\n ===================Paperless sadk-ext info===================");
            builder.append("\n \u5e94\u7528\u5382\u5546: China Financial Certification Authority");
            builder.append("\n \u5e94\u7528\u540d\u79f0: Paperless sadk-ext");
            builder.append("\n \u5e94\u7528\u7248\u672c: v3.0.2.1-20191203");
        }
        return builder;
    }

    public final String buildEnvironments() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n\n");
        this.appendME(builder);
        builder.append("\n\n");
        return builder.toString();
    }
}

